/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.mask;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.mask.MaskTable;

abstract class MaskForm {
    private final MaskTable maskTable;

    protected MaskForm(boolean maskManagmentMode, ListSelectionListener selectionListener) {
        this.maskTable = new MaskTable(maskManagmentMode);
        this.maskTable.getSelectionModel().addListSelectionListener(selectionListener);
        this.maskTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MaskForm.this.updateState();
            }
        });
        this.maskTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                MaskForm.this.updateState();
            }
        });
        this.maskTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Action action;
                if (e.getClickCount() == 2 && (action = MaskForm.this.getDoubleClickAction()).isEnabled()) {
                    action.actionPerformed(new ActionEvent(e.getSource(), e.getID(), null));
                }
            }
        });
    }

    public JTable getMaskTable() {
        return this.maskTable;
    }

    public Action getDoubleClickAction() {
        return null;
    }

    public AbstractButton getHelpButton() {
        return null;
    }

    public void updateState() {
    }

    public abstract JPanel createContentPanel();

    public Product getProduct() {
        return this.maskTable.getProduct();
    }

    public RasterDataNode getRaster() {
        return this.maskTable.getModel().getVisibleBand();
    }

    public Mask getSelectedMask() {
        return this.maskTable.getSelectedMask();
    }

    public Mask[] getSelectedMasks() {
        return this.maskTable.getSelectedMasks();
    }

    public Mask getMask(int rowIndex) {
        return this.maskTable.getMask(rowIndex);
    }

    public void addMask(Mask mask) {
        this.maskTable.addMask(mask);
    }

    public void insertMask(Mask mask, int index) {
        this.maskTable.insertMask(mask, index);
    }

    public void removeMask(Mask mask) {
        this.maskTable.removeMask(mask);
    }

    public boolean isInManagementMode() {
        return this.maskTable.isInManagmentMode();
    }

    public int getSelectedRowCount() {
        return this.maskTable.getSelectedRowCount();
    }

    public int getSelectedRow() {
        return this.maskTable.getSelectedRow();
    }

    public void setSelectedRow(int rowIndex) {
        this.maskTable.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
    }

    public int getRowCount() {
        return this.maskTable.getRowCount();
    }

    void reconfigureMaskTable(Product product, RasterDataNode visibleBand) {
        this.maskTable.setProduct(product, visibleBand);
    }

    void clearMaskTable() {
        this.maskTable.clear();
    }

    Dimension getTargetMaskSize() {
        RasterDataNode raster = this.getRaster();
        if (raster != null) {
            return new Dimension(raster.getRasterWidth(), raster.getRasterHeight());
        }
        Product product = this.getProduct();
        if (product != null) {
            return new Dimension(product.getSceneRasterWidth(), product.getSceneRasterHeight());
        }
        return null;
    }
}

