/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.magicwand;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerListener;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.support.AbstractLayerListener;
import com.bc.ceres.swing.figure.ViewportInteractor;
import com.bc.ceres.swing.undo.UndoContext;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.layer.MaskLayerType;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.magicwand.MagicWandForm;
import org.esa.snap.rcp.magicwand.MagicWandModel;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.util.MultiSizeIssue;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSceneView;

public class MagicWandInteractor
extends ViewportInteractor
implements MagicWandModel.Listener {
    private static final String DIALOG_TITLE = "Magic Wand Tool";
    private JDialog optionsWindow;
    private final MyLayerListener layerListener = new MyLayerListener();
    private MagicWandModel model = new MagicWandModel();
    private UndoContext undoContext;
    private MagicWandForm form;
    private boolean modelModified;

    public MagicWandInteractor() {
        this.model.addListener(this);
    }

    public boolean isModelModified() {
        return this.modelModified;
    }

    public void setModelModified(boolean modelModified) {
        this.modelModified = modelModified;
    }

    @Override
    public void modelChanged(MagicWandModel model, boolean recomputeMask) {
        this.setModelModified(true);
        if (recomputeMask) {
            this.updateMask();
        }
        if (this.form != null) {
            this.updateForm();
        }
    }

    void updateForm() {
        if (this.form.getSettingsFile() != null) {
            this.optionsWindow.setTitle("Magic Wand Tool - " + FileUtils.getFilenameWithoutExtension((File)this.form.getSettingsFile()));
        } else {
            this.optionsWindow.setTitle(DIALOG_TITLE);
        }
        this.form.getBindingContext().adjustComponents();
        this.form.updateState();
    }

    public Window getOptionsWindow() {
        return this.optionsWindow;
    }

    static double[] getSpectrum(List<Band> bands, int pixelX, int pixelY) throws IOException {
        double[] pixel = new double[1];
        double[] spectrum = new double[bands.size()];
        for (int i = 0; i < bands.size(); ++i) {
            Band band = bands.get(i);
            band.readPixels(pixelX, pixelY, 1, 1, pixel, ProgressMonitor.NULL);
            double value = band.isPixelValid(pixelX, pixelY) ? pixel[0] : Double.NaN;
            spectrum[i] = value;
        }
        return spectrum;
    }

    public boolean activate() {
        if (this.optionsWindow == null) {
            this.optionsWindow = this.createOptionsWindow();
        }
        this.optionsWindow.setVisible(true);
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        if (view != null) {
            view.getRootLayer().addListener((LayerListener)this.layerListener);
        }
        return super.activate();
    }

    public void deactivate() {
        ProductSceneView view;
        super.deactivate();
        if (this.optionsWindow != null) {
            this.optionsWindow.setVisible(false);
        }
        if ((view = SnapApp.getDefault().getSelectedProductSceneView()) != null) {
            view.getRootLayer().removeListener((LayerListener)this.layerListener);
        }
    }

    public void mouseClicked(MouseEvent event) {
        double[] spectrum;
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        if (view == null) {
            return;
        }
        Product product = view.getProduct();
        if (!this.ensureBandNamesSet(view, product)) {
            return;
        }
        List<Band> bands = this.model.getBands(product);
        if (bands == null) {
            if (!this.handleInvalidBandFilter(view)) {
                return;
            }
            bands = this.model.getBands(product);
            if (bands == null) {
                return;
            }
        }
        int band0Width = bands.get(0).getRasterWidth();
        int band0Height = bands.get(0).getRasterHeight();
        for (int i = 1; i < bands.size(); ++i) {
            Band band = bands.get(i);
            if (ProductUtils.areRastersEqualInSize((int)band0Width, (int)band0Height, (RasterDataNode[])new RasterDataNode[]{band})) continue;
            MultiSizeIssue.chooseBandsWithSameSize();
            return;
        }
        GeoCoding band0Geocoding = bands.get(0).getGeoCoding();
        Point pixelPos = this.getPixelPos(band0Geocoding, band0Width, band0Height, event);
        if (pixelPos == null) {
            return;
        }
        try {
            spectrum = MagicWandInteractor.getSpectrum(bands, pixelPos.x, pixelPos.y);
        }
        catch (IOException e1) {
            return;
        }
        MagicWandModel oldModel = this.getModel().clone();
        this.getModel().addSpectrum(spectrum);
        MagicWandModel newModel = this.getModel().clone();
        this.ensureMaskVisible(view);
        this.undoContext.postEdit((UndoableEdit)new MyUndoableEdit(oldModel, newModel));
    }

    void clearSpectra() {
        MagicWandModel oldModel = this.getModel().clone();
        this.getModel().clearSpectra();
        MagicWandModel newModel = this.getModel().clone();
        this.undoContext.postEdit((UndoableEdit)new MyUndoableEdit(oldModel, newModel));
    }

    private void ensureMaskVisible(ProductSceneView view) {
        Product product = view.getProduct();
        ProductNodeGroup overlayMaskGroup = view.getRaster().getOverlayMaskGroup();
        Mask mask = (Mask)overlayMaskGroup.getByDisplayName("magic_wand");
        if (mask == null && (mask = (Mask)product.getMaskGroup().get("magic_wand")) != null) {
            overlayMaskGroup.add((ProductNode)mask);
        }
    }

    private boolean handleInvalidBandFilter(ProductSceneView view) {
        Product product = view.getProduct();
        Dialogs.Answer answer = Dialogs.requestDecision(DIALOG_TITLE, "The currently selected band filter does not match\nthe bands of the selected data product.\n\nReset filter and use the ones of the selected product?", false, "reset_magic_wand_filter");
        if (answer == Dialogs.Answer.YES) {
            this.model.setBandNames(new String[0]);
            return this.ensureBandNamesSet(view, product);
        }
        return false;
    }

    Point getPixelPos(Product product, MouseEvent event) {
        Point2D ip;
        Point2D mp = this.toModelPoint(event);
        if (product.getSceneGeoCoding() != null) {
            AffineTransform transform = Product.findImageToModelTransform((GeoCoding)product.getSceneGeoCoding());
            try {
                ip = transform.inverseTransform(mp, null);
            }
            catch (NoninvertibleTransformException e) {
                Dialogs.showError(DIALOG_TITLE, "A geographic transformation problem occurred:\n" + e.getMessage());
                return null;
            }
        } else {
            ip = mp;
        }
        int pixelX = (int)ip.getX();
        int pixelY = (int)ip.getY();
        if (pixelX < 0 || pixelY < 0 || pixelX >= product.getSceneRasterWidth() || pixelY >= product.getSceneRasterHeight()) {
            return null;
        }
        return new Point(pixelX, pixelY);
    }

    Point getPixelPos(GeoCoding geocoding, int width, int height, MouseEvent event) {
        Point2D ip;
        Point2D mp = this.toModelPoint(event);
        if (geocoding != null) {
            AffineTransform transform = Product.findImageToModelTransform((GeoCoding)geocoding);
            try {
                ip = transform.inverseTransform(mp, null);
            }
            catch (NoninvertibleTransformException e) {
                Dialogs.showError(DIALOG_TITLE, "A geographic transformation problem occurred:\n" + e.getMessage());
                return null;
            }
        } else {
            ip = mp;
        }
        int pixelX = (int)ip.getX();
        int pixelY = (int)ip.getY();
        if (pixelX < 0 || pixelY < 0 || pixelX >= width || pixelY >= height) {
            return null;
        }
        return new Point(pixelX, pixelY);
    }

    private boolean ensureBandNamesSet(ProductSceneView view, Product product) {
        if (this.model.getBandCount() == 0) {
            this.model.setSpectralBandNames(product);
        }
        if (this.model.getBandCount() == 0) {
            this.model.setBandNames(view.getRaster().getName());
        }
        if (this.model.getBandCount() == 0) {
            Dialogs.showError(DIALOG_TITLE, "No bands selected.");
            return false;
        }
        return true;
    }

    void updateMask() {
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        if (view != null) {
            Product product = view.getProduct();
            this.updateMagicWandMask(product);
        }
    }

    private void updateMagicWandMask(Product product) {
        MagicWandModel.setMagicWandMask(product, this.getModel().createMaskExpression());
    }

    private JDialog createOptionsWindow() {
        this.form = new MagicWandForm(this);
        JDialog optionsWindow = new JDialog(SnapApp.getDefault().getMainFrame(), DIALOG_TITLE, false);
        UIUtils.centerComponent((Component)optionsWindow, (Component)SnapApp.getDefault().getMainFrame());
        optionsWindow.getContentPane().add(this.form.createPanel());
        optionsWindow.pack();
        return optionsWindow;
    }

    public MagicWandModel getModel() {
        return this.model;
    }

    public void setUndoContext(UndoContext undoContext) {
        this.undoContext = undoContext;
    }

    void assignModel(MagicWandModel other) {
        this.getModel().assign(other);
    }

    private class MyUndoableEdit
    extends AbstractUndoableEdit {
        private final MagicWandModel oldModel;
        private final MagicWandModel newModel;

        public MyUndoableEdit(MagicWandModel oldModel, MagicWandModel newModel) {
            this.oldModel = oldModel;
            this.newModel = newModel;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            MagicWandInteractor.this.assignModel(this.oldModel);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            MagicWandInteractor.this.assignModel(this.newModel);
        }

        @Override
        public String getPresentationName() {
            return "Modify magic wand mask";
        }
    }

    private static class MyLayerListener
    extends AbstractLayerListener {
        private MyLayerListener() {
        }

        public void handleLayersAdded(Layer parentLayer, Layer[] childLayers) {
            for (Layer childLayer : childLayers) {
                LayerType layerType = childLayer.getLayerType();
                if (!(layerType instanceof MaskLayerType) || !childLayer.getName().equals("magic_wand")) continue;
                childLayer.setVisible(true);
            }
        }
    }
}

