/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.wms;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.layermanager.layersrc.wms.WmsAssistantPage3;
import org.esa.snap.rcp.layermanager.layersrc.wms.WmsLayerSource;
import org.esa.snap.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.snap.ui.layer.LayerSourcePageContext;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WMSCapabilities;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class WmsAssistantPage2
extends AbstractLayerSourceAssistantPage {
    private JLabel infoLabel;
    private JTree layerTree;
    private CoordinateReferenceSystem modelCRS;

    WmsAssistantPage2() {
        super("Select Layer");
    }

    public boolean performFinish() {
        WmsLayerSource.insertWmsLayer(this.getContext());
        return true;
    }

    public AbstractLayerSourceAssistantPage getNextPage() {
        return new WmsAssistantPage3();
    }

    public boolean hasNextPage() {
        return true;
    }

    public boolean validatePage() {
        return this.getContext().getPropertyValue("selectedLayer") != null;
    }

    public Component createPageComponent() {
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add((Component)new JLabel("Available layers:"), "North");
        LayerSourcePageContext context = this.getContext();
        this.modelCRS = (CoordinateReferenceSystem)context.getLayerContext().getCoordinateReferenceSystem();
        WMSCapabilities wmsCapabilities = (WMSCapabilities)context.getPropertyValue("wmsCapabilities");
        this.layerTree = new JTree(new WmsTreeModel(wmsCapabilities.getLayer()));
        this.layerTree.setRootVisible(false);
        this.layerTree.setShowsRootHandles(true);
        this.layerTree.setExpandsSelectedPaths(true);
        this.layerTree.setCellRenderer(new MyDefaultTreeCellRenderer());
        this.layerTree.getSelectionModel().setSelectionMode(1);
        this.layerTree.getSelectionModel().addTreeSelectionListener(new LayerTreeSelectionListener());
        panel.add((Component)new JScrollPane(this.layerTree), "Center");
        this.infoLabel = new JLabel(" ");
        panel.add((Component)this.infoLabel, "South");
        this.getContext().setPropertyValue("selectedLayer", null);
        return panel;
    }

    private String getMatchingCRSCode(Layer layer) {
        Set srsSet = layer.getSrs();
        String modelSRS = CRS.toSRS((CoordinateReferenceSystem)this.modelCRS);
        if (modelSRS != null) {
            for (String srs : srsSet) {
                try {
                    CoordinateReferenceSystem crs = CRS.decode((String)srs, (boolean)true);
                    if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)this.modelCRS)) continue;
                    return srs;
                }
                catch (FactoryException factoryException) {
                }
            }
        }
        return null;
    }

    static String getLatLonBoundingBoxText(CRSEnvelope bbox) {
        if (bbox == null) {
            return "Lon = ?\u00b0 ... ?\u00b0, Lat = ?\u00b0 ... ?\u00b0";
        }
        return String.format("Lon = %.3f\u00b0 ... %.3f\u00b0, Lat = %.3f\u00b0 ... %.3f\u00b0", bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY());
    }

    private static class WmsTreeModel
    implements TreeModel {
        private final WeakHashMap<TreeModelListener, Object> treeModelListeners;
        private Layer rootLayer;

        private WmsTreeModel(Layer rootLayer) {
            this.rootLayer = rootLayer;
            this.treeModelListeners = new WeakHashMap();
        }

        @Override
        public Object getRoot() {
            return this.rootLayer;
        }

        @Override
        public Object getChild(Object parent, int index) {
            Layer layer = (Layer)parent;
            return layer.getChildren()[index];
        }

        @Override
        public int getChildCount(Object parent) {
            Layer layer = (Layer)parent;
            return layer.getChildren().length;
        }

        @Override
        public boolean isLeaf(Object node) {
            Layer layer = (Layer)node;
            return layer.getChildren() != null && layer.getChildren().length == 0;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            Layer layer = (Layer)parent;
            int index = Arrays.binarySearch(layer.getChildren(), child);
            return index < 0 ? -1 : index;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            this.fireTreeNodeChanged(path);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.treeModelListeners.put(l, "");
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.treeModelListeners.remove(l);
        }

        protected void fireTreeNodeChanged(TreePath treePath) {
            TreeModelEvent event = new TreeModelEvent((Object)this, treePath);
            for (TreeModelListener treeModelListener : this.treeModelListeners.keySet()) {
                treeModelListener.treeNodesChanged(event);
            }
        }
    }

    private class LayerTreeSelectionListener
    implements TreeSelectionListener {
        private LayerTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            LayerSourcePageContext context = WmsAssistantPage2.this.getContext();
            TreePath selectedLayerPath = WmsAssistantPage2.this.layerTree.getSelectionModel().getSelectionPath();
            Layer selectedLayer = (Layer)selectedLayerPath.getLastPathComponent();
            if (selectedLayer != null) {
                String crsCode = WmsAssistantPage2.this.getMatchingCRSCode(selectedLayer);
                if (crsCode == null) {
                    WmsAssistantPage2.this.infoLabel.setForeground(Color.RED.darker());
                    WmsAssistantPage2.this.infoLabel.setText("Coordinate system not supported.");
                } else {
                    RasterDataNode raster = SnapApp.getDefault().getSelectedProductSceneView().getRaster();
                    AffineTransform g2mTransform = Product.findImageToModelTransform((GeoCoding)raster.getGeoCoding());
                    Rectangle2D bounds = g2mTransform.createTransformedShape(new Rectangle(0, 0, raster.getRasterWidth(), raster.getRasterHeight())).getBounds2D();
                    CRSEnvelope crsEnvelope = new CRSEnvelope(crsCode, bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
                    context.setPropertyValue("crsEnvelope", (Object)crsEnvelope);
                    List styles = selectedLayer.getStyles();
                    if (!styles.isEmpty()) {
                        context.setPropertyValue("selectedStyle", styles.get(0));
                    } else {
                        context.setPropertyValue("selectedStyle", null);
                    }
                    context.setPropertyValue("selectedLayer", (Object)selectedLayer);
                    WmsAssistantPage2.this.infoLabel.setForeground(Color.DARK_GRAY);
                    WmsAssistantPage2.this.infoLabel.setText(WmsAssistantPage2.getLatLonBoundingBoxText(selectedLayer.getLatLonBoundingBox()));
                }
            } else {
                WmsAssistantPage2.this.infoLabel.setForeground(Color.DARK_GRAY);
                WmsAssistantPage2.this.infoLabel.setText("");
            }
            context.updateState();
        }
    }

    private static class MyDefaultTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyDefaultTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String text;
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof Layer) {
                Layer layer = (Layer)value;
                String title = layer.getTitle();
                if (title == null) {
                    title = layer.getName();
                }
                if (title == null) {
                    title = layer.toString();
                }
                StringBuilder sb = new StringBuilder(String.format("<html><b>%s</b>", title));
                Layer[] children = layer.getChildren();
                if (children.length > 1) {
                    sb.append(String.format(" (%d children)", children.length));
                } else if (children.length == 1) {
                    sb.append(" (1 child)");
                }
                text = sb.append("</html>").toString();
            } else if (value instanceof WMSCapabilities) {
                WMSCapabilities capabilities = (WMSCapabilities)value;
                text = String.format("<html><b>%s</b></html>", capabilities.getService().getName());
            } else {
                text = String.format("<html><b>%s</b></html>", value);
            }
            label.setText(text);
            return label;
        }
    }
}

