/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.windfield;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.RenderedImage;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.layermanager.layersrc.windfield.WindFieldLayerType;

public class WindFieldLayer
extends Layer {
    private RasterDataNode windu;
    private RasterDataNode windv;
    private final Color[] palette;
    private double maxLength = 10.0;
    private int res = 16;
    private float lineThickness = 2.0f;

    public WindFieldLayer(PropertyContainer configuration) {
        this(LayerTypeRegistry.getLayerType((String)WindFieldLayerType.class.getName()), (RasterDataNode)configuration.getValue("windu"), (RasterDataNode)configuration.getValue("windv"), (PropertySet)configuration);
    }

    public WindFieldLayer(LayerType layerType, RasterDataNode windu, RasterDataNode windv, PropertySet configuration) {
        super(layerType, configuration);
        this.setName("Wind Speed");
        this.windu = windu;
        this.windv = windv;
        this.palette = new Color[256];
        for (int i = 0; i < this.palette.length; ++i) {
            this.palette[i] = new Color(i, i, i);
        }
    }

    protected void renderLayer(Rendering rendering) {
        MultiLevelImage winduMLI = this.windu.getGeophysicalImage();
        MultiLevelImage windvMLI = this.windv.getGeophysicalImage();
        Viewport vp = rendering.getViewport();
        int level = ImageLayer.getLevel((MultiLevelModel)winduMLI.getModel(), (Viewport)vp);
        AffineTransform m2i = winduMLI.getModel().getModelToImageTransform(level);
        AffineTransform i2m = winduMLI.getModel().getImageToModelTransform(level);
        Rectangle vbounds = vp.getViewBounds();
        Shape mbounds = vp.getViewToModelTransform().createTransformedShape(vbounds);
        Shape ibounds = m2i.createTransformedShape(mbounds);
        RenderedImage winduRI = winduMLI.getImage(level);
        RenderedImage windvRI = windvMLI.getImage(level);
        int width = winduRI.getWidth();
        int height = winduRI.getHeight();
        Rectangle irect = ibounds.getBounds().intersection(new Rectangle(0, 0, width, height));
        if (irect.isEmpty()) {
            return;
        }
        AffineTransform m2v = vp.getModelToViewTransform();
        Graphics2D graphics = rendering.getGraphics();
        graphics.setStroke(new BasicStroke(this.lineThickness));
        MultiLevelImage winduValidMLI = this.windu.getValidMaskImage();
        MultiLevelImage windvValidMLI = this.windv.getValidMaskImage();
        RenderedImage winduValidRI = winduValidMLI != null ? winduValidMLI.getImage(level) : null;
        RenderedImage windvValidRI = windvValidMLI != null ? windvValidMLI.getImage(level) : null;
        int x1 = this.res * (irect.x / this.res);
        int x2 = x1 + this.res * (1 + irect.width / this.res);
        int y1 = this.res * (irect.y / this.res);
        int y2 = y1 + this.res * (1 + irect.height / this.res);
        double[] ipts = new double[8];
        double[] mpts = new double[8];
        double[] vpts = new double[8];
        Rectangle pixelRect = new Rectangle(0, 0, 1, 1);
        for (int y = y1; y <= y2; y += this.res) {
            for (int x = x1; x <= x2; x += this.res) {
                double v;
                boolean windvValid;
                boolean winduValid;
                if (x < 0 || x >= width || y < 0 || y >= height) continue;
                pixelRect.x = x;
                pixelRect.y = y;
                boolean bl = winduValid = winduValidRI == null || winduValidRI.getData(pixelRect).getSample(x, y, 0) != 0;
                if (!winduValid) continue;
                boolean bl2 = windvValid = windvValidRI == null || windvValidRI.getData(pixelRect).getSample(x, y, 0) != 0;
                if (!windvValid) continue;
                double u = winduRI.getData(pixelRect).getSampleDouble(x, y, 0);
                double length = Math.sqrt(u * u + (v = windvRI.getData(pixelRect).getSampleDouble(x, y, 0)) * v);
                double ndx = length > 0.0 ? u / length : 0.0;
                double ndy = length > 0.0 ? -v / length : 0.0;
                double ondx = -ndy;
                double ondy = ndx;
                double s0 = length / this.maxLength * (double)this.res;
                double s1 = s0 - 0.2 * (double)this.res;
                double s2 = 0.1 * (double)this.res;
                ipts[0] = x;
                ipts[1] = y;
                ipts[2] = (double)x + s0 * ndx;
                ipts[3] = (double)y + s0 * ndy;
                ipts[4] = (double)x + s1 * ndx + s2 * ondx;
                ipts[5] = (double)y + s1 * ndy + s2 * ondy;
                ipts[6] = (double)x + s1 * ndx - s2 * ondx;
                ipts[7] = (double)y + s1 * ndy - s2 * ondy;
                i2m.transform(ipts, 0, mpts, 0, 4);
                m2v.transform(mpts, 0, vpts, 0, 4);
                int grey = Math.min(255, (int)Math.round(256.0 * length / this.maxLength));
                graphics.setColor(this.palette[grey]);
                graphics.draw(new Line2D.Double(vpts[0], vpts[1], vpts[2], vpts[3]));
                graphics.draw(new Line2D.Double(vpts[4], vpts[5], vpts[2], vpts[3]));
                graphics.draw(new Line2D.Double(vpts[6], vpts[7], vpts[2], vpts[3]));
            }
        }
    }
}

