/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.shapefile;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.swing.LayerCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.layermanager.layersrc.shapefile.ShapefileLayerLoader;
import org.esa.snap.rcp.layermanager.layersrc.shapefile.ShapefileLoader;
import org.esa.snap.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.snap.ui.layer.LayerSourcePageContext;
import org.esa.snap.ui.product.ProductSceneView;
import org.geotools.styling.Style;
import org.opengis.util.InternationalString;

class ShapefileAssistantPage3
extends AbstractLayerSourceAssistantPage {
    private JComboBox styleList;
    private JPanel mapPanel;
    private SwingWorker<Layer, Object> worker;
    private boolean shapeFileLoaded = false;
    private JLabel infoLabel;
    private JLabel mapLabel;
    private ResizeAdapter resizeAdapter;

    ShapefileAssistantPage3() {
        super("Layer Preview");
    }

    public boolean validatePage() {
        return this.shapeFileLoaded;
    }

    public Component createPageComponent() {
        this.mapPanel = new JPanel(new BorderLayout());
        this.mapLabel = new JLabel();
        this.mapLabel.setHorizontalAlignment(0);
        this.mapPanel.add((Component)this.mapLabel, "Center");
        LayerSourcePageContext context = this.getContext();
        String filePath = (String)context.getPropertyValue("fileName");
        String fileName = new File(filePath).getName();
        this.infoLabel = new JLabel();
        this.styleList = new JComboBox();
        this.styleList.setRenderer(new StyleListCellRenderer());
        this.styleList.addItemListener(new StyleSelectionListener());
        this.styleList.setPreferredSize(new Dimension(100, this.styleList.getPreferredSize().height));
        JPanel panel2 = new JPanel(new BorderLayout(4, 4));
        panel2.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel2.add((Component)new JLabel("Style:"), "West");
        panel2.add((Component)this.styleList, "East");
        JPanel panel3 = new JPanel(new BorderLayout(4, 4));
        panel3.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel3.add((Component)new JLabel(String.format("<html><b>%s</b>", fileName)), "Center");
        panel3.add((Component)panel2, "East");
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add((Component)panel3, "North");
        panel.add((Component)this.mapPanel, "Center");
        panel.add((Component)this.infoLabel, "South");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShapefileAssistantPage3.this.updateMap();
            }
        });
        return panel;
    }

    public boolean performFinish() {
        LayerSourcePageContext context = this.getContext();
        new ShapefileLayerLoader(context).execute();
        return true;
    }

    private void updateMap() {
        if (this.worker != null && !this.worker.isDone()) {
            try {
                this.worker.cancel(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.mapLabel.setText("<html><i>Loading map...</i></html>");
        this.addToMapPanel(this.mapLabel);
        LayerSourcePageContext context = this.getContext();
        context.getWindow().setCursor(Cursor.getPredefinedCursor(3));
        this.shapeFileLoaded = false;
        context.updateState();
        this.worker = new ShapeFilePreviewLoader(context);
        this.worker.execute();
    }

    private void addToMapPanel(Component component) {
        if (this.resizeAdapter == null && component instanceof LayerCanvas) {
            LayerCanvas layerCanvas = (LayerCanvas)component;
            this.resizeAdapter = new ResizeAdapter(layerCanvas);
            this.mapPanel.addComponentListener(this.resizeAdapter);
        } else {
            this.mapPanel.removeComponentListener(this.resizeAdapter);
            this.resizeAdapter = null;
        }
        this.mapPanel.removeAll();
        this.mapPanel.add(component, "Center");
    }

    private static class ResizeAdapter
    extends ComponentAdapter {
        private final LayerCanvas layerCanvas;

        private ResizeAdapter(LayerCanvas layerCanvas) {
            this.layerCanvas = layerCanvas;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.layerCanvas.zoomAll();
        }
    }

    private class ShapeFilePreviewLoader
    extends ShapefileLoader {
        private ShapeFilePreviewLoader(LayerSourcePageContext context) {
            super(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void done() {
            LayerSourcePageContext context = this.getContext();
            context.getWindow().setCursor(Cursor.getDefaultCursor());
            ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
            try {
                Layer layer = (Layer)this.get();
                LayerCanvas layerCanvas = new LayerCanvas(layer);
                layerCanvas.getViewport().setModelYAxisDown(sceneView.getLayerCanvas().getViewport().isModelYAxisDown());
                ShapefileAssistantPage3.this.addToMapPanel((Component)layerCanvas);
                Rectangle2D bounds = layer.getModelBounds();
                ShapefileAssistantPage3.this.infoLabel.setText(String.format("Model bounds [%.3f : %.3f, %.3f : %.3f]", bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY()));
                Style[] styles = (Style[])context.getPropertyValue("styles");
                Style selectedStyle = (Style)context.getPropertyValue("selectedStyle");
                ShapefileAssistantPage3.this.styleList.setModel(new DefaultComboBoxModel<Style>(styles));
                ShapefileAssistantPage3.this.styleList.setSelectedItem(selectedStyle);
                ShapefileAssistantPage3.this.shapeFileLoaded = true;
            }
            catch (ExecutionException e) {
                String errorMessage = MessageFormat.format("<html><b>Error:</b> <i>{0}</i></html>", e.getMessage());
                e.printStackTrace();
                ShapefileAssistantPage3.this.mapLabel.setText(errorMessage);
                ShapefileAssistantPage3.this.addToMapPanel(ShapefileAssistantPage3.this.mapLabel);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                context.updateState();
            }
        }
    }

    private static class StyleListCellRenderer
    extends DefaultListCellRenderer {
        private StyleListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = null;
            if (value != null) {
                Style style = (Style)value;
                InternationalString title = style.getDescription().getTitle();
                text = title != null ? title.toString() : "Default Styler";
            }
            label.setText(text);
            return label;
        }
    }

    private class StyleSelectionListener
    implements ItemListener {
        private StyleSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            LayerSourcePageContext context = ShapefileAssistantPage3.this.getContext();
            context.setPropertyValue("selectedStyle", ShapefileAssistantPage3.this.styleList.getSelectedItem());
            context.updateState();
            ShapefileAssistantPage3.this.updateMap();
        }
    }
}

