/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.product;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerListener;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.glayer.support.ImageLayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.layer.RasterImageLayerType;
import org.esa.snap.core.util.ObjectUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.layermanager.layersrc.product.LayerDataHandler;
import org.esa.snap.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.snap.ui.product.ProductSceneView;
import org.geotools.referencing.CRS;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class ProductLayerAssistantPage
extends AbstractLayerSourceAssistantPage {
    private JTree tree;

    ProductLayerAssistantPage() {
        super("Select Band / Tie-Point Grid");
    }

    public Component createPageComponent() {
        ProductTreeModel model = this.createTreeModel();
        this.tree = new JTree(model);
        this.tree.setEditable(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new ProductNodeTreeCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.getSelectionModel().addTreeSelectionListener(new ProductNodeSelectionListener());
        List<CompatibleNodeList> nodeLists = model.compatibleNodeLists;
        for (CompatibleNodeList nodeList : nodeLists) {
            this.tree.expandPath(new TreePath(new Object[]{nodeLists, nodeList}));
        }
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add((Component)new JLabel("Compatible bands and tie-point grids:"), "North");
        panel.add((Component)new JScrollPane(this.tree), "Center");
        return panel;
    }

    public boolean validatePage() {
        TreePath path = this.tree.getSelectionPath();
        return path != null && path.getLastPathComponent() instanceof RasterDataNode;
    }

    public boolean hasNextPage() {
        return false;
    }

    public boolean canFinish() {
        return true;
    }

    public boolean performFinish() {
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return false;
        }
        for (TreePath treePath : selectionPaths) {
            RasterDataNode rasterDataNode = (RasterDataNode)treePath.getLastPathComponent();
            LayerType type = LayerTypeRegistry.getLayerType((String)RasterImageLayerType.class.getName());
            PropertySet configuration = type.createLayerConfig(this.getContext().getLayerContext());
            configuration.setValue("raster", (Object)rasterDataNode);
            configuration.setValue("borderShown", (Object)false);
            configuration.setValue("borderColor", (Object)ImageLayer.DEFAULT_BORDER_COLOR);
            configuration.setValue("borderWidth", (Object)1.0);
            configuration.setValue("pixelBorderShown", (Object)false);
            ImageLayer imageLayer = (ImageLayer)type.createLayer(this.getContext().getLayerContext(), configuration);
            imageLayer.setName(rasterDataNode.getDisplayName());
            ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
            Layer rootLayer = sceneView.getRootLayer();
            rootLayer.getChildren().add(sceneView.getFirstImageLayerIndex(), imageLayer);
            LayerDataHandler layerDataHandler = new LayerDataHandler(rasterDataNode, imageLayer);
            rasterDataNode.getProduct().addProductNodeListener((ProductNodeListener)layerDataHandler);
            rootLayer.addListener((LayerListener)layerDataHandler);
        }
        return true;
    }

    private ProductTreeModel createTreeModel() {
        ProductSceneView selectedProductSceneView = SnapApp.getDefault().getSelectedProductSceneView();
        Product selectedProduct = selectedProductSceneView.getProduct();
        RasterDataNode raster = selectedProductSceneView.getRaster();
        CoordinateReferenceSystem modelCRS = selectedProduct.getSceneCRS();
        ArrayList<CompatibleNodeList> compatibleNodeLists = new ArrayList<CompatibleNodeList>(3);
        ArrayList<Object> compatibleNodes = new ArrayList<RasterDataNode>();
        this.collectCompatibleBands(raster, (RasterDataNode[])selectedProduct.getBands(), compatibleNodes);
        if (raster.getRasterWidth() == selectedProduct.getSceneRasterWidth() && raster.getRasterHeight() == selectedProduct.getSceneRasterHeight()) {
            compatibleNodes.addAll(Arrays.asList(selectedProduct.getTiePointGrids()));
        }
        if (!compatibleNodes.isEmpty()) {
            compatibleNodeLists.add(new CompatibleNodeList(selectedProduct.getDisplayName(), compatibleNodes));
        }
        if (modelCRS != null) {
            Product[] products;
            ProductManager productManager = SnapApp.getDefault().getProductManager();
            for (Product product : products = productManager.getProducts()) {
                if (product == selectedProduct) continue;
                compatibleNodes = new ArrayList();
                this.collectCompatibleRasterDataNodes(modelCRS, (RasterDataNode[])product.getBands(), compatibleNodes);
                this.collectCompatibleRasterDataNodes(modelCRS, (RasterDataNode[])product.getTiePointGrids(), compatibleNodes);
                if (compatibleNodes.isEmpty()) continue;
                compatibleNodeLists.add(new CompatibleNodeList(product.getDisplayName(), compatibleNodes));
            }
        }
        return new ProductTreeModel(compatibleNodeLists);
    }

    private void collectCompatibleBands(RasterDataNode referenceRaster, RasterDataNode[] dataNodes, Collection<RasterDataNode> rasterDataNodes) {
        Dimension referenceRasterSize = referenceRaster.getRasterSize();
        for (RasterDataNode node : dataNodes) {
            if (!node.getRasterSize().equals(referenceRasterSize)) continue;
            rasterDataNodes.add(node);
        }
    }

    private void collectCompatibleRasterDataNodes(CoordinateReferenceSystem thisCrs, RasterDataNode[] bands, Collection<RasterDataNode> rasterDataNodes) {
        for (RasterDataNode node : bands) {
            CoordinateReferenceSystem otherCrs = Product.findModelCRS((GeoCoding)node.getGeoCoding());
            if (!CRS.equalsIgnoreMetadata((Object)thisCrs, (Object)otherCrs) && !ProductLayerAssistantPage.haveCommonReferenceIdentifiers(thisCrs, otherCrs)) continue;
            rasterDataNodes.add(node);
        }
    }

    private static boolean haveCommonReferenceIdentifiers(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        Set identifiers1 = crs1.getIdentifiers();
        Set identifiers2 = crs2.getIdentifiers();
        if (identifiers1 == null || identifiers1.isEmpty() || identifiers2 == null || identifiers2.isEmpty() || identifiers1.size() != identifiers2.size()) {
            return false;
        }
        int eqCount = 0;
        block0: for (ReferenceIdentifier refId1 : identifiers1) {
            for (ReferenceIdentifier refId2 : identifiers2) {
                if (!ProductLayerAssistantPage.compareRefIds(refId1, refId2)) continue;
                ++eqCount;
                continue block0;
            }
        }
        return eqCount == identifiers1.size();
    }

    private static boolean compareRefIds(ReferenceIdentifier refId1, ReferenceIdentifier refId2) {
        return ObjectUtils.equalObjects((Object)refId1.getCodeSpace(), (Object)refId2.getCodeSpace()) && ObjectUtils.equalObjects((Object)refId1.getCode(), (Object)refId2.getCode()) && ProductLayerAssistantPage.compareVersions(refId1.getVersion(), refId2.getVersion());
    }

    private static boolean compareVersions(String version1, String version2) {
        return version1 == null || version2 == null || version1.equalsIgnoreCase(version2);
    }

    private static class ProductTreeModel
    implements TreeModel {
        private final WeakHashMap<TreeModelListener, Object> treeModelListeners;
        private final List<CompatibleNodeList> compatibleNodeLists;

        private ProductTreeModel(List<CompatibleNodeList> compatibleNodeLists) {
            this.compatibleNodeLists = compatibleNodeLists;
            this.treeModelListeners = new WeakHashMap();
        }

        @Override
        public Object getRoot() {
            return this.compatibleNodeLists;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent == this.compatibleNodeLists) {
                return this.compatibleNodeLists.get(index);
            }
            if (parent instanceof CompatibleNodeList) {
                return ((CompatibleNodeList)parent).rasterDataNodes.get(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == this.compatibleNodeLists) {
                return this.compatibleNodeLists.size();
            }
            if (parent instanceof CompatibleNodeList) {
                return ((CompatibleNodeList)parent).rasterDataNodes.size();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            return node instanceof RasterDataNode;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent == this.compatibleNodeLists) {
                return this.compatibleNodeLists.indexOf(child);
            }
            if (parent instanceof CompatibleNodeList) {
                return ((CompatibleNodeList)parent).rasterDataNodes.indexOf(child);
            }
            return -1;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            this.fireTreeNodeChanged(path);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.treeModelListeners.put(l, "");
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.treeModelListeners.remove(l);
        }

        protected void fireTreeNodeChanged(TreePath treePath) {
            TreeModelEvent event = new TreeModelEvent((Object)this, treePath);
            for (TreeModelListener treeModelListener : this.treeModelListeners.keySet()) {
                treeModelListener.treeNodesChanged(event);
            }
        }
    }

    private class ProductNodeSelectionListener
    implements TreeSelectionListener {
        private ProductNodeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ProductLayerAssistantPage.this.getContext().updateState();
        }
    }

    private static class ProductNodeTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private ProductNodeTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof CompatibleNodeList) {
                label.setText(MessageFormat.format("<html><b>{0}</b></html>", ((CompatibleNodeList)value).name));
            } else if (value instanceof Band) {
                label.setText(MessageFormat.format("<html><b>{0}</b></html>", ((Band)value).getName()));
            } else if (value instanceof TiePointGrid) {
                label.setText(MessageFormat.format("<html><b>{0}</b> (Tie-point grid)</html>", ((TiePointGrid)value).getName()));
            }
            return label;
        }
    }

    private static class CompatibleNodeList {
        private final String name;
        private final List<RasterDataNode> rasterDataNodes;

        CompatibleNodeList(String name, List<RasterDataNode> rasterDataNodes) {
            this.name = name;
            this.rasterDataNodes = rasterDataNodes;
        }
    }
}

