/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.product;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.support.AbstractLayerListener;
import com.bc.ceres.glayer.support.ImageLayer;
import java.util.Arrays;
import java.util.List;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ColoredBandImageMultiLevelSource;

class LayerDataHandler
extends AbstractLayerListener
implements ProductNodeListener {
    private final List<String> imageChangingProperties = Arrays.asList("data", "noDataValue", "noDataValueUsed", "validPixelExpression", "imageInfo", "expression");
    private final RasterDataNode rasterDataNode;
    private final ImageLayer imageLayer;

    LayerDataHandler(RasterDataNode rasterDataNode, ImageLayer imageLayer) {
        this.rasterDataNode = rasterDataNode;
        this.imageLayer = imageLayer;
    }

    public void handleLayersRemoved(Layer parentLayer, Layer[] childLayers) {
        for (Layer childLayer : childLayers) {
            Product product;
            if (childLayer != this.imageLayer || (product = this.rasterDataNode.getProduct()) == null) continue;
            product.removeProductNodeListener((ProductNodeListener)this);
        }
    }

    public void nodeChanged(ProductNodeEvent event) {
        if (event.getSourceNode() == this.rasterDataNode) {
            if ("name".equals(event.getPropertyName())) {
                this.imageLayer.setName(this.rasterDataNode.getDisplayName());
            } else if (this.imageChangingProperties.contains(event.getPropertyName())) {
                ColoredBandImageMultiLevelSource bandImageSource = (ColoredBandImageMultiLevelSource)this.imageLayer.getMultiLevelSource();
                bandImageSource.setImageInfo(this.rasterDataNode.getImageInfo());
                this.imageLayer.regenerate();
            }
        }
    }

    public void nodeDataChanged(ProductNodeEvent event) {
        if (event.getSourceNode() == this.rasterDataNode) {
            this.imageLayer.regenerate();
        }
    }

    public void nodeAdded(ProductNodeEvent event) {
    }

    public void nodeRemoved(ProductNodeEvent event) {
    }
}

