/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.image;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.FileLoadDescriptor;

@LayerTypeMetadata(name="ImageFileLayerType", aliasNames={"org.esa.snap.rcp.layermanager.layersrc.image.ImageFileLayerType"})
public class ImageFileLayerType
extends ImageLayer.Type {
    static final String PROPERTY_NAME_IMAGE_FILE = "filePath";
    static final String PROPERTY_NAME_WORLD_TRANSFORM = "worldTransform";

    public Layer createLayer(LayerContext ctx, PropertySet configuration) {
        File file = (File)configuration.getValue(PROPERTY_NAME_IMAGE_FILE);
        AffineTransform transform = (AffineTransform)configuration.getValue(PROPERTY_NAME_WORLD_TRANSFORM);
        RenderedOp image = FileLoadDescriptor.create((String)file.getPath(), null, (Boolean)true, null);
        Rectangle2D modelBounds = DefaultMultiLevelModel.getModelBounds((AffineTransform)transform, (RenderedImage)image);
        DefaultMultiLevelModel model = new DefaultMultiLevelModel(1, transform, modelBounds);
        DefaultMultiLevelSource multiLevelSource = new DefaultMultiLevelSource((RenderedImage)image, (MultiLevelModel)model);
        return new ImageLayer((ImageLayer.Type)this, (MultiLevelSource)multiLevelSource, configuration);
    }

    public PropertySet createLayerConfig(LayerContext ctx) {
        PropertyContainer template = new PropertyContainer();
        Property filePathModel = Property.create((String)PROPERTY_NAME_IMAGE_FILE, File.class);
        filePathModel.getDescriptor().setNotNull(true);
        template.addProperty(filePathModel);
        Property worldTransformModel = Property.create((String)PROPERTY_NAME_WORLD_TRANSFORM, AffineTransform.class);
        worldTransformModel.getDescriptor().setNotNull(true);
        template.addProperty(worldTransformModel);
        return template;
    }
}

