/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.image;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.esa.snap.rcp.layermanager.layersrc.image.ImageFileLayerSource;
import org.esa.snap.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.snap.ui.layer.LayerSourcePageContext;

class ImageFileAssistantPage2
extends AbstractLayerSourceAssistantPage {
    private JTextField[] numberFields;

    ImageFileAssistantPage2() {
        super("Edit Affine Transformation");
    }

    public Component createPageComponent() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(4, 0, 4, 2);
        double[] flatmatrix = new double[6];
        this.numberFields = new JTextField[flatmatrix.length];
        AffineTransform transform = (AffineTransform)this.getContext().getPropertyValue("worldTransform");
        transform.getMatrix(flatmatrix);
        String[] labels = new String[]{"X-dimension of a pixel in map units: ", "Rotation parameter for row: ", "Rotation parameter for column: ", "Negative of Y-dimension of a pixel in map units: ", "X-coordinate of center of upper left pixel: ", "Y-coordinate of centre of upper left pixel: "};
        this.numberFields[0] = this.addRow(panel, labels[0], gbc);
        this.numberFields[0].setText(String.valueOf(flatmatrix[0]));
        this.numberFields[1] = this.addRow(panel, labels[1], gbc);
        this.numberFields[1].setText(String.valueOf(flatmatrix[1]));
        this.numberFields[2] = this.addRow(panel, labels[2], gbc);
        this.numberFields[2].setText(String.valueOf(flatmatrix[2]));
        this.numberFields[3] = this.addRow(panel, labels[3], gbc);
        this.numberFields[3].setText(String.valueOf(flatmatrix[3]));
        this.numberFields[4] = this.addRow(panel, labels[4], gbc);
        this.numberFields[4].setText(String.valueOf(flatmatrix[4]));
        this.numberFields[5] = this.addRow(panel, labels[5], gbc);
        this.numberFields[5].setText(String.valueOf(flatmatrix[5]));
        return panel;
    }

    public boolean validatePage() {
        try {
            return this.createTransform().getDeterminant() != 0.0;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public boolean performFinish() {
        AffineTransform transform = this.createTransform();
        LayerSourcePageContext context = this.getContext();
        context.setPropertyValue("worldTransform", (Object)transform);
        return ImageFileLayerSource.insertImageLayer(context);
    }

    private JTextField addRow(JPanel panel, String label, GridBagConstraints gbc) {
        ++gbc.gridy;
        gbc.weightx = 0.2;
        gbc.gridx = 0;
        panel.add((Component)new JLabel(label), gbc);
        gbc.weightx = 0.8;
        gbc.gridx = 1;
        JTextField fileField = new JTextField(12);
        fileField.setHorizontalAlignment(4);
        panel.add((Component)fileField, gbc);
        fileField.getDocument().addDocumentListener(new MyDocumentListener());
        return fileField;
    }

    private AffineTransform createTransform() {
        double[] flatmatrix = new double[this.numberFields.length];
        for (int i = 0; i < flatmatrix.length; ++i) {
            flatmatrix[i] = Double.parseDouble(this.getText(this.numberFields[i]));
        }
        return new AffineTransform(flatmatrix);
    }

    private String getText(JTextComponent textComponent) {
        String s = textComponent.getText();
        return s != null ? s.trim() : "";
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ImageFileAssistantPage2.this.getContext().updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ImageFileAssistantPage2.this.getContext().updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ImageFileAssistantPage2.this.getContext().updateState();
        }
    }
}

