/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.snap.ui.layer.LayerSource;
import org.esa.snap.ui.layer.LayerSourceDescriptor;
import org.esa.snap.ui.layer.LayerSourcePageContext;

public class SelectLayerSourceAssistantPage
extends AbstractLayerSourceAssistantPage {
    private JList list;
    private Map<LayerSourceDescriptor, LayerSource> layerSourceMap = new HashMap<LayerSourceDescriptor, LayerSource>();

    public SelectLayerSourceAssistantPage(LayerSourceDescriptor[] sourceDescriptors) {
        super("Select Layer Source");
        for (LayerSourceDescriptor sourceDescriptor : sourceDescriptors) {
            this.layerSourceMap.put(sourceDescriptor, sourceDescriptor.createLayerSource());
        }
    }

    public boolean validatePage() {
        return this.list.getSelectedIndex() >= 0;
    }

    public boolean hasNextPage() {
        LayerSourceDescriptor selected = (LayerSourceDescriptor)this.list.getSelectedValue();
        if (selected == null) {
            return false;
        }
        return this.layerSourceMap.get(selected).hasFirstPage();
    }

    public AbstractLayerSourceAssistantPage getNextPage() {
        LayerSourceDescriptor selected = (LayerSourceDescriptor)this.list.getSelectedValue();
        if (selected == null) {
            return null;
        }
        LayerSource layerSource = this.layerSourceMap.get(selected);
        LayerSourcePageContext pageContext = this.getContext();
        pageContext.setLayerSource(layerSource);
        return layerSource.getFirstPage(pageContext);
    }

    public boolean canFinish() {
        LayerSourceDescriptor selected = (LayerSourceDescriptor)this.list.getSelectedValue();
        if (selected == null) {
            return false;
        }
        return this.layerSourceMap.get(selected).canFinish(this.getContext());
    }

    public boolean performFinish() {
        LayerSourceDescriptor selected = (LayerSourceDescriptor)this.list.getSelectedValue();
        if (selected == null) {
            return false;
        }
        return this.layerSourceMap.get(selected).performFinish(this.getContext());
    }

    public Component createPageComponent() {
        LayerSourcePageContext context = this.getContext();
        Set<LayerSourceDescriptor> descriptorSet = this.layerSourceMap.keySet();
        ArrayList<LayerSourceDescriptor> descriptorList = new ArrayList<LayerSourceDescriptor>(descriptorSet.size());
        for (LayerSourceDescriptor lsd : descriptorSet) {
            LayerSource lsc = this.layerSourceMap.get(lsd);
            if (!lsc.isApplicable(context)) continue;
            descriptorList.add(lsd);
        }
        Collections.sort(descriptorList, new Comparator<LayerSourceDescriptor>(){

            @Override
            public int compare(LayerSourceDescriptor o1, LayerSourceDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.list = new JList<LayerSourceDescriptor>(descriptorList.toArray(new LayerSourceDescriptor[descriptorList.size()]));
        this.list.getSelectionModel().addListSelectionListener(new LayerSourceSelectionListener());
        this.list.setCellRenderer(new LayerSourceCellRenderer());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel.add((Component)new JLabel("Available layer sources:"), gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridy;
        gbc.fill = 1;
        panel.add((Component)new JScrollPane(this.list), gbc);
        return panel;
    }

    private static class LayerSourceCellRenderer
    extends DefaultListCellRenderer {
        private LayerSourceCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof LayerSourceDescriptor) {
                LayerSourceDescriptor layerSourceDescriptor = (LayerSourceDescriptor)value;
                label.setText("<html><b>" + layerSourceDescriptor.getName() + "</b>");
                label.setToolTipText(layerSourceDescriptor.getDescription());
            } else {
                label.setText("Invalid");
            }
            return label;
        }
    }

    private class LayerSourceSelectionListener
    implements ListSelectionListener {
        private LayerSourceSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SelectLayerSourceAssistantPage.this.getContext().updateState();
        }
    }
}

