/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.editors;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.Color;
import org.esa.snap.core.layer.GraticuleLayerType;
import org.esa.snap.ui.layer.AbstractLayerConfigurationEditor;

public class GraticuleLayerEditor
extends AbstractLayerConfigurationEditor {
    protected void addEditablePropertyDescriptors() {
        this.addSectionBreak("graticule.grid.spacing.section", "Grid Spacing", "Set grid spacing in degrees (0=AUTOSPACING)");
        PropertyDescriptor gridSpacingLatPD = new PropertyDescriptor("graticule.spacing.lat", Double.class);
        gridSpacingLatPD.setDefaultValue((Object)0.0);
        gridSpacingLatPD.setValueRange(new ValueRange(0.0, 90.0));
        gridSpacingLatPD.setDisplayName("Latitude");
        gridSpacingLatPD.setDescription("Set latitude grid spacing in degrees (0=AUTOSPACING)");
        gridSpacingLatPD.setDefaultConverter();
        this.addPropertyDescriptor(gridSpacingLatPD);
        PropertyDescriptor gridSpacingLonPD = new PropertyDescriptor("graticule.spacing.lon", Double.class);
        gridSpacingLonPD.setDefaultValue((Object)0.0);
        gridSpacingLonPD.setValueRange(new ValueRange(0.0, 180.0));
        gridSpacingLonPD.setDisplayName("Longitude");
        gridSpacingLonPD.setDescription("Set longitude grid spacing in degrees (0=AUTOSPACING)");
        gridSpacingLonPD.setDefaultConverter();
        this.addPropertyDescriptor(gridSpacingLonPD);
        this.addSectionBreak("graticule.labels.section", "Labels", "Configuration options for the labels");
        PropertyDescriptor labelsNorthPD = new PropertyDescriptor("graticule.labels.north", Boolean.class);
        labelsNorthPD.setDefaultValue((Object)true);
        labelsNorthPD.setDisplayName("North");
        labelsNorthPD.setDescription("Display north labels");
        labelsNorthPD.setDefaultConverter();
        this.addPropertyDescriptor(labelsNorthPD);
        PropertyDescriptor labelsSouthPD = new PropertyDescriptor("graticule.labels.south", Boolean.class);
        labelsSouthPD.setDefaultValue((Object)true);
        labelsSouthPD.setDisplayName("South");
        labelsSouthPD.setDescription("Display south labels");
        labelsSouthPD.setDefaultConverter();
        this.addPropertyDescriptor(labelsSouthPD);
        PropertyDescriptor labelsWestPD = new PropertyDescriptor("graticule.labels.west", Boolean.class);
        labelsWestPD.setDefaultValue((Object)true);
        labelsWestPD.setDisplayName("West");
        labelsWestPD.setDescription("Display west labels");
        labelsWestPD.setDefaultConverter();
        this.addPropertyDescriptor(labelsWestPD);
        PropertyDescriptor labelsEastPD = new PropertyDescriptor("graticule.labels.east", Boolean.class);
        labelsEastPD.setDefaultValue((Object)true);
        labelsEastPD.setDisplayName("East");
        labelsEastPD.setDescription("Display east labels");
        labelsEastPD.setDefaultConverter();
        this.addPropertyDescriptor(labelsEastPD);
        PropertyDescriptor labelsSuffixPD = new PropertyDescriptor("graticule.labels.suffix.nswe", Boolean.class);
        labelsSuffixPD.setDefaultValue((Object)true);
        labelsSuffixPD.setDisplayName("Suffix (N,S,W,E)");
        labelsSuffixPD.setDescription("Format label text with suffix (N,S,W,E) instead of (+/-)");
        labelsSuffixPD.setDefaultConverter();
        this.addPropertyDescriptor(labelsSuffixPD);
        PropertyDescriptor labelsDecimalPD = new PropertyDescriptor("graticule.labels.decimal.value", Boolean.class);
        labelsDecimalPD.setDefaultValue((Object)false);
        labelsDecimalPD.setDisplayName("Decimal Value");
        labelsDecimalPD.setDescription("Format label text with decimal value instead of degrees/minutes/seconds");
        labelsDecimalPD.setDefaultConverter();
        this.addPropertyDescriptor(labelsDecimalPD);
        PropertyDescriptor labelsInsidePD = new PropertyDescriptor("graticule.labels.inside", Boolean.class);
        labelsInsidePD.setDefaultValue((Object)false);
        labelsInsidePD.setDisplayName("Put on Inside");
        labelsInsidePD.setDescription("Put on labels inside of the data image (also see backdrop options below)");
        labelsInsidePD.setDefaultConverter();
        this.addPropertyDescriptor(labelsInsidePD);
        PropertyDescriptor labelsItalicsPD = new PropertyDescriptor("graticule.labels.font.italic", Boolean.class);
        labelsItalicsPD.setDefaultValue((Object)false);
        labelsItalicsPD.setDisplayName("Italic");
        labelsItalicsPD.setDescription("Format label text font in italic");
        labelsItalicsPD.setDefaultConverter();
        this.addPropertyDescriptor(labelsItalicsPD);
        PropertyDescriptor labelsBoldPD = new PropertyDescriptor("graticule.labels.font.bold", Boolean.class);
        labelsBoldPD.setDefaultValue((Object)false);
        labelsBoldPD.setDisplayName("Bold");
        labelsBoldPD.setDescription("Format label text font in bold");
        labelsBoldPD.setDefaultConverter();
        this.addPropertyDescriptor(labelsBoldPD);
        PropertyDescriptor labelsRotationLatPD = new PropertyDescriptor("graticule.labels.rotation.lat", Double.class);
        labelsRotationLatPD.setDefaultValue((Object)0.0);
        labelsRotationLatPD.setDisplayName("Rotation (Latitude)");
        labelsRotationLatPD.setDescription("Rotate latitude labels (0 degrees = perpendicular)");
        labelsRotationLatPD.setDefaultConverter();
        labelsRotationLatPD.setValueRange(new ValueRange(0.0, 90.0));
        this.addPropertyDescriptor(labelsRotationLatPD);
        PropertyDescriptor labelsRotationLonPD = new PropertyDescriptor("graticule.labels.rotation.lon", Double.class);
        labelsRotationLonPD.setDefaultValue((Object)45.0);
        labelsRotationLonPD.setDisplayName("Rotation (Longitude)");
        labelsRotationLonPD.setDescription("Rotate longitude labels (0 degrees = perpendicular)");
        labelsRotationLonPD.setDefaultConverter();
        labelsRotationLonPD.setValueRange(new ValueRange(0.0, 90.0));
        this.addPropertyDescriptor(labelsRotationLonPD);
        PropertyDescriptor labelsFontPD = new PropertyDescriptor("graticule.labels.font.name", String.class);
        labelsFontPD.setDefaultValue((Object)"SanSerif");
        labelsFontPD.setDisplayName("Font");
        labelsFontPD.setDescription("Set the text font of the labels");
        labelsFontPD.setValueSet(new ValueSet(GraticuleLayerType.PROPERTY_LABELS_FONT_VALUE_SET));
        labelsFontPD.setDefaultConverter();
        this.addPropertyDescriptor(labelsFontPD);
        PropertyDescriptor labelSizePD = new PropertyDescriptor("graticule.labels.size", Integer.class);
        labelSizePD.setDefaultValue((Object)12);
        labelSizePD.setDisplayName("Size");
        labelSizePD.setDescription("Set size of the label text");
        labelSizePD.setValueRange(new ValueRange(6.0, 70.0));
        labelSizePD.setDefaultConverter();
        this.addPropertyDescriptor(labelSizePD);
        PropertyDescriptor labelColorPD = new PropertyDescriptor("graticule.labels.color", Color.class);
        labelColorPD.setDefaultValue((Object)GraticuleLayerType.PROPERTY_LABELS_COLOR_DEFAULT);
        labelColorPD.setDisplayName("Color");
        labelColorPD.setDescription("Set color of the label text");
        labelColorPD.setDefaultConverter();
        this.addPropertyDescriptor(labelColorPD);
        this.addSectionBreak("graticule.gridlines.section", "Gridlines", "Configuration options for the gridlines");
        PropertyDescriptor gridlinesShowPD = new PropertyDescriptor("graticule.gridlines.show", Boolean.class);
        gridlinesShowPD.setDefaultValue((Object)true);
        gridlinesShowPD.setDisplayName("Show");
        gridlinesShowPD.setDescription("Display gridlines");
        gridlinesShowPD.setDefaultConverter();
        this.addPropertyDescriptor(gridlinesShowPD);
        PropertyDescriptor girdlinesWidthPD = new PropertyDescriptor("graticule.gridlines.width", Double.class);
        girdlinesWidthPD.setDefaultValue((Object)0.8);
        girdlinesWidthPD.setDisplayName("Width");
        girdlinesWidthPD.setDescription("Set width of gridlines");
        girdlinesWidthPD.setDefaultConverter();
        this.addPropertyDescriptor(girdlinesWidthPD);
        PropertyDescriptor gridlinesDashedPD = new PropertyDescriptor("graticule.gridlines.dashed.phase", Double.class);
        gridlinesDashedPD.setDefaultValue((Object)3.0);
        gridlinesDashedPD.setDisplayName("Dash Length");
        gridlinesDashedPD.setDescription("Set dash length of gridlines or solid gridlines (0=SOLID)");
        gridlinesDashedPD.setDefaultConverter();
        this.addPropertyDescriptor(gridlinesDashedPD);
        PropertyDescriptor gridlinesTransparencyPD = new PropertyDescriptor("graticule.gridlines.transparency", Double.class);
        gridlinesTransparencyPD.setDefaultValue((Object)0.6);
        gridlinesTransparencyPD.setValueRange(new ValueRange(0.0, 1.0));
        gridlinesTransparencyPD.setDisplayName("Transparency");
        gridlinesTransparencyPD.setDescription("Set transparency of gridlines");
        gridlinesTransparencyPD.setDefaultConverter();
        this.addPropertyDescriptor(gridlinesTransparencyPD);
        PropertyDescriptor gridlinesColorPD = new PropertyDescriptor("graticule.gridlines.color", Color.class);
        gridlinesColorPD.setDefaultValue((Object)GraticuleLayerType.PROPERTY_GRIDLINES_COLOR_DEFAULT);
        gridlinesColorPD.setDisplayName("Color");
        gridlinesColorPD.setDescription("Set color of gridlines");
        gridlinesColorPD.setDefaultConverter();
        this.addPropertyDescriptor(gridlinesColorPD);
        this.addSectionBreak("graticule.border.section", "Border", "Configuration options for adding a border around the data image");
        PropertyDescriptor borderShowPD = new PropertyDescriptor("graticule.border.show", Boolean.class);
        borderShowPD.setDefaultValue((Object)true);
        borderShowPD.setDisplayName("Show");
        borderShowPD.setDescription("Display a border around the data image");
        borderShowPD.setDefaultConverter();
        this.addPropertyDescriptor(borderShowPD);
        PropertyDescriptor borderWidthPD = new PropertyDescriptor("graticule.border.width", Double.class);
        borderWidthPD.setDefaultValue((Object)1.2);
        borderWidthPD.setDisplayName("Width");
        borderWidthPD.setDescription("Width of border line");
        borderWidthPD.setDefaultConverter();
        this.addPropertyDescriptor(borderWidthPD);
        PropertyDescriptor borderColorPD = new PropertyDescriptor("graticule.border.color", Color.class);
        borderColorPD.setDefaultValue((Object)GraticuleLayerType.PROPERTY_BORDER_COLOR_DEFAULT);
        borderColorPD.setDisplayName("Color");
        borderColorPD.setDescription("Color of border line");
        borderColorPD.setDefaultConverter();
        this.addPropertyDescriptor(borderColorPD);
        this.addSectionBreak("graticule.tickmarks.section", "Tickmarks", "Configuration options for adding tickmarks around the data image");
        PropertyDescriptor tickmarksShowPD = new PropertyDescriptor("graticule.tickmarks.show", Boolean.class);
        tickmarksShowPD.setDefaultValue((Object)true);
        tickmarksShowPD.setDisplayName("Show");
        tickmarksShowPD.setDescription("Display tickmarks");
        tickmarksShowPD.setDefaultConverter();
        this.addPropertyDescriptor(tickmarksShowPD);
        PropertyDescriptor tickmarksInsidePD = new PropertyDescriptor("graticule.tickmarks.inside", Boolean.class);
        tickmarksInsidePD.setDefaultValue((Object)false);
        tickmarksInsidePD.setDisplayName("Put Inside");
        tickmarksInsidePD.setDescription("Put tickmarks on inside of data image");
        tickmarksInsidePD.setDefaultConverter();
        this.addPropertyDescriptor(tickmarksInsidePD);
        PropertyDescriptor tickmarksLengthPD = new PropertyDescriptor("graticule.tickmarks.length", Double.class);
        tickmarksLengthPD.setDefaultValue((Object)3.0);
        tickmarksLengthPD.setDisplayName("Length");
        tickmarksLengthPD.setDescription("Set length of tickmarks");
        tickmarksLengthPD.setDefaultConverter();
        this.addPropertyDescriptor(tickmarksLengthPD);
        PropertyDescriptor tickmarksColorPD = new PropertyDescriptor("graticule.tickmarks.color", Color.class);
        tickmarksColorPD.setDefaultValue((Object)GraticuleLayerType.PROPERTY_TICKMARKS_COLOR_DEFAULT);
        tickmarksColorPD.setDisplayName("Color");
        tickmarksColorPD.setDescription("Set color of the tickmarks");
        tickmarksColorPD.setDefaultConverter();
        this.addPropertyDescriptor(tickmarksColorPD);
        this.addSectionBreak("graticule.corner.labels.section", "Corner Labels", "Configuration options for labels placed at the corners of the image");
        PropertyDescriptor cornerLabelsNorthPD = new PropertyDescriptor("graticule.corner.labels.north", Boolean.class);
        cornerLabelsNorthPD.setDefaultValue((Object)false);
        cornerLabelsNorthPD.setDisplayName("North");
        cornerLabelsNorthPD.setDescription("Display north corner labels");
        cornerLabelsNorthPD.setDefaultConverter();
        this.addPropertyDescriptor(cornerLabelsNorthPD);
        PropertyDescriptor cornerLabelsSouthPD = new PropertyDescriptor("graticule.corner.labels.south", Boolean.class);
        cornerLabelsSouthPD.setDefaultValue((Object)false);
        cornerLabelsSouthPD.setDisplayName("South");
        cornerLabelsSouthPD.setDescription("Display south corner labels");
        cornerLabelsSouthPD.setDefaultConverter();
        this.addPropertyDescriptor(cornerLabelsSouthPD);
        PropertyDescriptor cornerLabelsWestPD = new PropertyDescriptor("graticule.corner.labels.west", Boolean.class);
        cornerLabelsWestPD.setDefaultValue((Object)false);
        cornerLabelsWestPD.setDisplayName("West");
        cornerLabelsWestPD.setDescription("Display west corner labels");
        cornerLabelsWestPD.setDefaultConverter();
        this.addPropertyDescriptor(cornerLabelsWestPD);
        PropertyDescriptor cornerLabelsEastPD = new PropertyDescriptor("graticule.corner.labels.east", Boolean.class);
        cornerLabelsEastPD.setDefaultValue((Object)false);
        cornerLabelsEastPD.setDisplayName("East");
        cornerLabelsEastPD.setDescription("Display east corner labels");
        cornerLabelsEastPD.setDefaultConverter();
        this.addPropertyDescriptor(cornerLabelsEastPD);
        this.addSectionBreak("graticule.labels.backdrop.section", "Inside Labels Backdrop", "Configuration options for backdrop of labels placed on the inside of the image");
        PropertyDescriptor innerLabelsBgTransparencyPD = new PropertyDescriptor("graticule.text.bg.transparency", Double.class);
        innerLabelsBgTransparencyPD.setDefaultValue((Object)0.3);
        innerLabelsBgTransparencyPD.setValueRange(new ValueRange(0.0, 1.0));
        innerLabelsBgTransparencyPD.setDisplayName("Transparency");
        innerLabelsBgTransparencyPD.setDescription("Set transparency of the backdrop of the inside labels");
        innerLabelsBgTransparencyPD.setDefaultConverter();
        this.addPropertyDescriptor(innerLabelsBgTransparencyPD);
        PropertyDescriptor innerLabelsBgColorPD = new PropertyDescriptor("graticule.text.bg.color", Color.class);
        innerLabelsBgColorPD.setDefaultValue((Object)GraticuleLayerType.PROPERTY_INSIDE_LABELS_BG_COLOR_DEFAULT);
        innerLabelsBgColorPD.setDisplayName("Color");
        innerLabelsBgColorPD.setDescription("Set color of the backdrop of the inside labels");
        innerLabelsBgColorPD.setDefaultConverter();
        this.addPropertyDescriptor(innerLabelsBgColorPD);
        BindingContext bindingContext = this.getBindingContext();
        boolean lineEnabled = (Boolean)bindingContext.getPropertySet().getValue("graticule.gridlines.show");
        bindingContext.bindEnabledState("graticule.gridlines.width", lineEnabled, "graticule.gridlines.show", (Object)lineEnabled);
        bindingContext.bindEnabledState("graticule.gridlines.color", lineEnabled, "graticule.gridlines.show", (Object)lineEnabled);
        bindingContext.bindEnabledState("graticule.gridlines.transparency", lineEnabled, "graticule.gridlines.show", (Object)lineEnabled);
        bindingContext.bindEnabledState("graticule.gridlines.dashed.phase", lineEnabled, "graticule.gridlines.show", (Object)lineEnabled);
        bindingContext.bindEnabledState("graticule.gridlines.width", lineEnabled, "graticule.gridlines.show", (Object)lineEnabled);
        boolean borderEnabled = (Boolean)bindingContext.getPropertySet().getValue("graticule.border.show");
        bindingContext.bindEnabledState("graticule.border.color", borderEnabled, "graticule.border.show", (Object)borderEnabled);
        bindingContext.bindEnabledState("graticule.border.width", borderEnabled, "graticule.border.show", (Object)borderEnabled);
        boolean textInsideEnabled = (Boolean)bindingContext.getPropertySet().getValue("graticule.labels.inside");
        bindingContext.bindEnabledState("graticule.text.bg.transparency", textInsideEnabled, "graticule.labels.inside", (Object)textInsideEnabled);
        bindingContext.bindEnabledState("graticule.text.bg.color", textInsideEnabled, "graticule.labels.inside", (Object)textInsideEnabled);
        bindingContext.bindEnabledState("graticule.labels.rotation.lat", !textInsideEnabled, "graticule.labels.inside", (Object)textInsideEnabled);
        bindingContext.bindEnabledState("graticule.labels.rotation.lon", !textInsideEnabled, "graticule.labels.inside", (Object)textInsideEnabled);
        bindingContext.bindEnabledState("graticule.corner.labels.north", !textInsideEnabled, "graticule.labels.inside", (Object)textInsideEnabled);
        bindingContext.bindEnabledState("graticule.corner.labels.south", !textInsideEnabled, "graticule.labels.inside", (Object)textInsideEnabled);
        bindingContext.bindEnabledState("graticule.corner.labels.west", !textInsideEnabled, "graticule.labels.inside", (Object)textInsideEnabled);
        bindingContext.bindEnabledState("graticule.corner.labels.east", !textInsideEnabled, "graticule.labels.inside", (Object)textInsideEnabled);
        boolean tickMarkEnabled = (Boolean)bindingContext.getPropertySet().getValue("graticule.tickmarks.show");
        bindingContext.bindEnabledState("graticule.tickmarks.inside", tickMarkEnabled, "graticule.tickmarks.show", (Object)tickMarkEnabled);
        bindingContext.bindEnabledState("graticule.tickmarks.length", tickMarkEnabled, "graticule.tickmarks.show", (Object)tickMarkEnabled);
        bindingContext.bindEnabledState("graticule.tickmarks.color", tickMarkEnabled, "graticule.tickmarks.show", (Object)tickMarkEnabled);
    }

    private void addSectionBreak(String name, String label, String toolTip) {
        PropertyDescriptor descriptor = new PropertyDescriptor(name, Boolean.class);
        descriptor.setDisplayName(label);
        descriptor.setDescription(toolTip);
        this.addPropertyDescriptor(descriptor);
    }
}

