/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager;

import com.bc.ceres.glayer.Layer;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.UIUtils;

class MoveLayerLeftAction
extends AbstractAction {
    MoveLayerLeftAction() {
        super("Move Layer Left", UIUtils.loadImageIcon((String)"icons/Left24.gif"));
        this.putValue("ActionCommandKey", this.getClass().getName());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Layer selectedLayer = SnapApp.getDefault().getSelectedProductSceneView().getSelectedLayer();
        Layer rootLayer = SnapApp.getDefault().getSelectedProductSceneView().getRootLayer();
        if (selectedLayer != null && rootLayer != selectedLayer) {
            this.moveLeft(selectedLayer);
        }
    }

    void moveLeft(Layer layer) {
        if (this.canMove(layer)) {
            Layer parentLayer = layer.getParent();
            Layer parentsParentLayer = parentLayer.getParent();
            parentLayer.getChildren().remove(layer);
            int parentIndex = parentsParentLayer.getChildIndex(parentLayer.getId());
            if (parentIndex < parentsParentLayer.getChildren().size() - 1) {
                parentsParentLayer.getChildren().add(parentIndex + 1, layer);
            } else {
                parentsParentLayer.getChildren().add(layer);
            }
        }
    }

    public boolean canMove(Layer layer) {
        Layer parentLayer = layer.getParent();
        Layer parentsParentLayer = parentLayer.getParent();
        return parentsParentLayer != null;
    }
}

