/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerListener;
import com.bc.ceres.glayer.support.AbstractLayerListener;
import com.bc.ceres.glayer.support.LayerUtils;
import com.bc.ceres.swing.TreeCellExtender;
import com.jidesoft.swing.CheckBoxTree;
import com.jidesoft.swing.CheckBoxTreeSelectionModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.esa.snap.rcp.layermanager.AbstractLayerForm;
import org.esa.snap.rcp.layermanager.Bundle;
import org.esa.snap.rcp.layermanager.LayerManager;
import org.esa.snap.rcp.layermanager.LayerTreeModel;
import org.esa.snap.rcp.layermanager.LayerTreeTransferHandler;
import org.esa.snap.rcp.layermanager.MoveLayerDownAction;
import org.esa.snap.rcp.layermanager.MoveLayerLeftAction;
import org.esa.snap.rcp.layermanager.MoveLayerRightAction;
import org.esa.snap.rcp.layermanager.MoveLayerUpAction;
import org.esa.snap.rcp.layermanager.OpenLayerEditorAction;
import org.esa.snap.rcp.layermanager.RemoveLayerAction;
import org.esa.snap.rcp.layermanager.ZoomToLayerAction;
import org.esa.snap.rcp.layermanager.layersrc.SelectLayerSourceAssistantPage;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.assistant.AssistantPage;
import org.esa.snap.ui.help.HelpDisplayer;
import org.esa.snap.ui.layer.LayerSourceAssistantPane;
import org.esa.snap.ui.layer.LayerSourceDescriptor;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.product.VectorDataLayer;
import org.esa.snap.ui.tool.ToolButtonFactory;

class LayerManagerForm
implements AbstractLayerForm {
    private final ProductSceneView view;
    private final ToolTopComponent parentComponent;
    private CheckBoxTree layerTree;
    private JSlider transparencySlider;
    private JSlider swipeSlider;
    private JPanel control;
    private boolean adjusting;
    private LayerTreeModel layerTreeModel;
    private JLabel transparencyLabel;
    private JLabel swipeLabel;
    private RemoveLayerAction removeLayerAction;
    private MoveLayerUpAction moveLayerUpAction;
    private MoveLayerDownAction moveLayerDownAction;
    private MoveLayerLeftAction moveLayerLeftAction;
    private MoveLayerRightAction moveLayerRightAction;
    private OpenLayerEditorAction openLayerEditorAction;
    private ZoomToLayerAction zoomToLayerAction;
    private TransparencyChangeListener transparencyChangeListener;
    private SwipeChangeListener swipeChangeListener;

    LayerManagerForm(ToolTopComponent parentComponent) {
        this.parentComponent = parentComponent;
        this.view = parentComponent.getSelectedProductSceneView();
        this.transparencyChangeListener = new TransparencyChangeListener();
        this.swipeChangeListener = new SwipeChangeListener();
        this.initUI();
    }

    private void initUI() {
        this.layerTreeModel = new LayerTreeModel(this.view.getRootLayer());
        this.layerTree = this.createCheckBoxTree(this.layerTreeModel);
        this.layerTree.setCellRenderer((TreeCellRenderer)new MyTreeCellRenderer());
        TreeCellExtender.equip((JTree)this.layerTree);
        Hashtable<Integer, JLabel> transparencySliderLabelTable = new Hashtable<Integer, JLabel>();
        transparencySliderLabelTable.put(0, LayerManagerForm.createSliderLabel("0%"));
        transparencySliderLabelTable.put(127, LayerManagerForm.createSliderLabel("50%"));
        transparencySliderLabelTable.put(255, LayerManagerForm.createSliderLabel("100%"));
        this.transparencySlider = new JSlider(0, 255, 0);
        this.transparencySlider.setLabelTable(transparencySliderLabelTable);
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.addChangeListener(new TransparencySliderListener());
        this.transparencyLabel = new JLabel("Transparency:");
        Hashtable<Integer, JLabel> swipeSliderLabelTable = new Hashtable<Integer, JLabel>();
        swipeSliderLabelTable.put(0, LayerManagerForm.createSliderLabel("0%"));
        swipeSliderLabelTable.put(50, LayerManagerForm.createSliderLabel("50%"));
        swipeSliderLabelTable.put(100, LayerManagerForm.createSliderLabel("100%"));
        this.swipeSlider = new JSlider(0, 100, 0);
        this.swipeSlider.setLabelTable(swipeSliderLabelTable);
        this.swipeSlider.setPaintLabels(true);
        this.swipeSlider.addChangeListener(new SwipeSliderListener());
        this.swipeLabel = new JLabel("Swipe:");
        JPanel sliderPanel = GridBagUtils.createPanel();
        GridBagConstraints slidegbc = new GridBagConstraints();
        slidegbc.anchor = 18;
        slidegbc.fill = 2;
        slidegbc.gridy = 0;
        slidegbc.gridx = 0;
        sliderPanel.add((Component)this.transparencyLabel, slidegbc);
        slidegbc.gridx = 1;
        slidegbc.weightx = 2.0;
        sliderPanel.add((Component)this.transparencySlider, slidegbc);
        ++slidegbc.gridy;
        slidegbc.gridx = 0;
        sliderPanel.add((Component)this.swipeLabel, slidegbc);
        slidegbc.gridx = 1;
        slidegbc.weightx = 2.0;
        sliderPanel.add((Component)this.swipeSlider, slidegbc);
        this.getRootLayer().addListener((LayerListener)new RootLayerListener());
        AbstractButton addButton = LayerManagerForm.createToolButton("icons/Plus24.gif");
        addButton.addActionListener(new AddLayerActionListener());
        this.removeLayerAction = new RemoveLayerAction();
        AbstractButton removeButton = ToolButtonFactory.createButton((Action)this.removeLayerAction, (boolean)false);
        this.openLayerEditorAction = new OpenLayerEditorAction();
        AbstractButton openButton = ToolButtonFactory.createButton((Action)this.openLayerEditorAction, (boolean)false);
        this.zoomToLayerAction = new ZoomToLayerAction();
        AbstractButton zoomButton = ToolButtonFactory.createButton((Action)this.zoomToLayerAction, (boolean)false);
        this.moveLayerUpAction = new MoveLayerUpAction();
        AbstractButton upButton = ToolButtonFactory.createButton((Action)this.moveLayerUpAction, (boolean)false);
        this.moveLayerDownAction = new MoveLayerDownAction();
        AbstractButton downButton = ToolButtonFactory.createButton((Action)this.moveLayerDownAction, (boolean)false);
        this.moveLayerLeftAction = new MoveLayerLeftAction();
        AbstractButton leftButton = ToolButtonFactory.createButton((Action)this.moveLayerLeftAction, (boolean)false);
        this.moveLayerRightAction = new MoveLayerRightAction();
        AbstractButton rightButton = ToolButtonFactory.createButton((Action)this.moveLayerRightAction, (boolean)false);
        AbstractButton helpButton = LayerManagerForm.createToolButton("icons/Help22.png");
        helpButton.setToolTipText("Help.");
        helpButton.setName("helpButton");
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpDisplayer.show((String)Bundle.CTL_LayerManagerTopComponent_HelpId());
            }
        });
        JPanel actionBar = GridBagUtils.createPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets.top = 2;
        gbc.gridy = 0;
        actionBar.add((Component)addButton, gbc);
        ++gbc.gridy;
        actionBar.add((Component)removeButton, gbc);
        ++gbc.gridy;
        actionBar.add((Component)openButton, gbc);
        ++gbc.gridy;
        actionBar.add((Component)zoomButton, gbc);
        ++gbc.gridy;
        actionBar.add((Component)upButton, gbc);
        ++gbc.gridy;
        actionBar.add((Component)downButton, gbc);
        ++gbc.gridy;
        actionBar.add((Component)leftButton, gbc);
        ++gbc.gridy;
        actionBar.add((Component)rightButton, gbc);
        ++gbc.gridy;
        gbc.insets.bottom = 0;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        actionBar.add((Component)new JLabel(" "), gbc);
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.gridy = 10;
        gbc.anchor = 13;
        actionBar.add((Component)helpButton, gbc);
        JPanel layerPanel = new JPanel(new BorderLayout(4, 4));
        layerPanel.add((Component)new JScrollPane((Component)this.layerTree), "Center");
        layerPanel.add((Component)sliderPanel, "South");
        this.control = new JPanel(new BorderLayout(4, 4));
        this.control.add((Component)layerPanel, "Center");
        this.control.add((Component)actionBar, "East");
        this.initLayerTreeVisibility(this.view.getRootLayer());
        this.updateFormControl();
    }

    private static JLabel createSliderLabel(String text) {
        JLabel label = new JLabel(text);
        Font oldFont = label.getFont();
        Font newFont = oldFont.deriveFont(oldFont.getSize2D() * 0.85f);
        label.setFont(newFont);
        return label;
    }

    public Layer getRootLayer() {
        return this.view.getRootLayer();
    }

    @Override
    public JComponent getFormControl() {
        return this.control;
    }

    @Override
    public void updateFormControl() {
        Layer selectedLayer = this.getSelectedLayer();
        this.updateLayerStyleUI(selectedLayer);
        this.updateLayerTreeSelection(selectedLayer);
        boolean isLayerSelected = selectedLayer != null;
        this.removeLayerAction.setEnabled(isLayerSelected && !LayerManagerForm.isLayerProtected(selectedLayer));
        this.openLayerEditorAction.setEnabled(isLayerSelected);
        this.moveLayerUpAction.setEnabled(isLayerSelected && this.moveLayerUpAction.canMove(selectedLayer));
        this.moveLayerDownAction.setEnabled(isLayerSelected && this.moveLayerDownAction.canMove(selectedLayer));
        this.moveLayerLeftAction.setEnabled(isLayerSelected && this.moveLayerLeftAction.canMove(selectedLayer));
        this.moveLayerRightAction.setEnabled(isLayerSelected && this.moveLayerRightAction.canMove(selectedLayer));
        this.zoomToLayerAction.setEnabled(isLayerSelected);
    }

    public static boolean isLayerProtected(Layer layer) {
        return LayerManagerForm.isLayerProtectedImpl(layer) || LayerManagerForm.isChildLayerProtected(layer);
    }

    private Layer getSelectedLayer() {
        return this.view.getSelectedLayer();
    }

    private static boolean isLayerProtectedImpl(Layer layer) {
        return layer.getId().equals("org.esa.snap.layers.baseImage");
    }

    private static boolean isChildLayerProtected(Layer selectedLayer) {
        Layer[] children;
        for (Layer childLayer : children = selectedLayer.getChildren().toArray(new Layer[selectedLayer.getChildren().size()])) {
            if (!LayerManagerForm.isLayerProtectedImpl(childLayer) && !LayerManagerForm.isChildLayerProtected(childLayer)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLayerNameEditable(Layer layer) {
        return !(layer instanceof VectorDataLayer) && !layer.getConfiguration().isPropertyDefined("mask");
    }

    private static Layer getLayer(TreePath path) {
        if (path == null) {
            return null;
        }
        return (Layer)path.getLastPathComponent();
    }

    private void initLayerTreeVisibility(Layer layer) {
        this.updateLayerTreeVisibility(layer);
        for (Layer childLayer : layer.getChildren()) {
            this.initLayerTreeVisibility(childLayer);
        }
    }

    private void updateLayerTreeVisibility(Layer layer) {
        CheckBoxTreeSelectionModel checkBoxTreeSelectionModel = this.layerTree.getCheckBoxTreeSelectionModel();
        Object[] layerPath = LayerUtils.getLayerPath((Layer)this.layerTreeModel.getRootLayer(), (Layer)layer);
        if (layerPath.length > 0) {
            if (layer.isVisible()) {
                checkBoxTreeSelectionModel.addSelectionPath(new TreePath(layerPath));
            } else {
                checkBoxTreeSelectionModel.removeSelectionPath(new TreePath(layerPath));
            }
            List children = layer.getChildren();
            if (!children.isEmpty()) {
                for (Layer child : children) {
                    this.updateLayerTreeVisibility(child);
                }
            }
        }
    }

    private void updateLayerTreeSelection(Layer selectedLayer) {
        if (selectedLayer != null) {
            Object[] layerPath = LayerUtils.getLayerPath((Layer)this.layerTreeModel.getRootLayer(), (Layer)selectedLayer);
            if (layerPath.length > 0) {
                this.layerTree.setSelectionPath(new TreePath(layerPath));
            } else {
                this.layerTree.clearSelection();
            }
        } else {
            this.layerTree.clearSelection();
        }
    }

    private void updateLayerStyleUI(Layer layer) {
        int n;
        this.transparencyLabel.setEnabled(layer != null);
        this.transparencySlider.setEnabled(layer != null);
        if (layer != null) {
            double transparency = layer.getTransparency();
            n = (int)Math.round(255.0 * transparency);
            this.transparencySlider.setValue(n);
        }
        this.swipeLabel.setEnabled(layer != null);
        this.swipeSlider.setEnabled(layer != null);
        if (layer != null) {
            double swipe = layer.getSwipePercent();
            n = (int)Math.round(100.0 * swipe);
            this.swipeSlider.setValue(n);
        }
    }

    private CheckBoxTree createCheckBoxTree(LayerTreeModel treeModel) {
        CheckBoxTree checkBoxTree = new CheckBoxTree(treeModel){

            public boolean isPathEditable(TreePath path) {
                Layer layer = LayerManagerForm.getLayer(path);
                if (layer != null) {
                    return LayerManagerForm.isLayerNameEditable(layer);
                }
                return false;
            }
        };
        checkBoxTree.setRootVisible(false);
        checkBoxTree.setShowsRootHandles(true);
        checkBoxTree.setDigIn(false);
        checkBoxTree.setEditable(true);
        checkBoxTree.setDragEnabled(true);
        checkBoxTree.setDropMode(DropMode.ON_OR_INSERT);
        checkBoxTree.setTransferHandler((TransferHandler)new LayerTreeTransferHandler(this.view, (JTree)checkBoxTree));
        checkBoxTree.getSelectionModel().addTreeSelectionListener(new LayerSelectionListener());
        CheckBoxTreeSelectionModel checkBoxSelectionModel = checkBoxTree.getCheckBoxTreeSelectionModel();
        checkBoxSelectionModel.addTreeSelectionListener((TreeSelectionListener)new CheckBoxTreeSelectionListener());
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)checkBoxTree.getActualCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        return checkBoxTree;
    }

    private void installTransparencyChangeListener(Layer selectedLayer) {
        selectedLayer.addListener((LayerListener)this.transparencyChangeListener);
    }

    private void removeTransparencyChangeListener(Layer selectedLayer) {
        selectedLayer.removeListener((LayerListener)this.transparencyChangeListener);
    }

    private void installSwipeChangeListener(Layer selectedLayer) {
        selectedLayer.addListener((LayerListener)this.swipeChangeListener);
    }

    private void removeSwipeChangeListener(Layer selectedLayer) {
        selectedLayer.removeListener((LayerListener)this.swipeChangeListener);
    }

    public static AbstractButton createToolButton(String iconPath) {
        return ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)iconPath), (boolean)false);
    }

    private class CheckBoxTreeSelectionListener
    implements TreeSelectionListener {
        private CheckBoxTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            TreePath path;
            Layer layer;
            if (!LayerManagerForm.this.adjusting && (layer = LayerManagerForm.getLayer(path = event.getPath())).getParent() != null) {
                boolean pathSelected = ((TreeSelectionModel)event.getSource()).isPathSelected(path);
                layer.setVisible(pathSelected);
            }
        }
    }

    private class LayerSelectionListener
    implements TreeSelectionListener {
        private Layer selectedLayer;

        private LayerSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            if (this.selectedLayer != null) {
                LayerManagerForm.this.removeTransparencyChangeListener(this.selectedLayer);
                LayerManagerForm.this.removeSwipeChangeListener(this.selectedLayer);
            }
            this.selectedLayer = LayerManagerForm.getLayer(event.getNewLeadSelectionPath());
            if (this.selectedLayer != null) {
                LayerManagerForm.this.installTransparencyChangeListener(this.selectedLayer);
                LayerManagerForm.this.installSwipeChangeListener(this.selectedLayer);
            }
            if (LayerManagerForm.this.parentComponent.getSelectedProductSceneView() != null) {
                LayerManagerForm.this.parentComponent.getSelectedProductSceneView().setSelectedLayer(this.selectedLayer);
            }
        }
    }

    private class SwipeChangeListener
    extends AbstractLayerListener {
        private SwipeChangeListener() {
        }

        public void handleLayerPropertyChanged(Layer layer, PropertyChangeEvent event) {
            if ("swipePercent".equals(event.getPropertyName())) {
                LayerManagerForm.this.updateLayerStyleUI(layer);
            }
        }
    }

    private class TransparencyChangeListener
    extends AbstractLayerListener {
        private TransparencyChangeListener() {
        }

        public void handleLayerPropertyChanged(Layer layer, PropertyChangeEvent event) {
            if ("transparency".equals(event.getPropertyName())) {
                LayerManagerForm.this.updateLayerStyleUI(layer);
            }
        }
    }

    private static class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Layer layer = (Layer)value;
            if ("org.esa.snap.layers.baseImage".equals(layer.getId())) {
                label.setText(String.format("<html><b>%s</b></html>", layer.getName()));
            }
            return label;
        }
    }

    private class AddLayerActionListener
    implements ActionListener {
        private Rectangle screenBounds;

        private AddLayerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LayerSourceAssistantPane pane = new LayerSourceAssistantPane(SwingUtilities.getWindowAncestor(LayerManagerForm.this.control), "Add Layer");
            Map<String, LayerSourceDescriptor> layerSourceDescriptors1 = LayerManager.getDefault().getLayerSourceDescriptors();
            LayerSourceDescriptor[] layerSourceDescriptors2 = layerSourceDescriptors1.values().toArray(new LayerSourceDescriptor[layerSourceDescriptors1.size()]);
            pane.show((AssistantPage)new SelectLayerSourceAssistantPage(layerSourceDescriptors2), this.screenBounds);
            this.screenBounds = pane.getWindow().getBounds();
        }
    }

    private class SwipeSliderListener
    implements ChangeListener {
        private SwipeSliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TreePath path = LayerManagerForm.this.layerTree.getSelectionPath();
            if (path != null) {
                Layer layer = LayerManagerForm.getLayer(path);
                LayerManagerForm.this.adjusting = true;
                layer.setSwipePercent((double)LayerManagerForm.this.swipeSlider.getValue() / 100.0);
                LayerManagerForm.this.adjusting = false;
            }
        }
    }

    private class TransparencySliderListener
    implements ChangeListener {
        private TransparencySliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TreePath path = LayerManagerForm.this.layerTree.getSelectionPath();
            if (path != null) {
                Layer layer = LayerManagerForm.getLayer(path);
                LayerManagerForm.this.adjusting = true;
                layer.setTransparency((double)LayerManagerForm.this.transparencySlider.getValue() / 255.0);
                LayerManagerForm.this.adjusting = false;
            }
        }
    }

    private class RootLayerListener
    extends AbstractLayerListener {
        private RootLayerListener() {
        }

        public void handleLayerPropertyChanged(Layer layer, PropertyChangeEvent event) {
            if ("visible".equals(event.getPropertyName())) {
                LayerManagerForm.this.updateLayerTreeVisibility(layer);
            }
        }

        public void handleLayersAdded(Layer parentLayer, Layer[] childLayers) {
            for (Layer layer : childLayers) {
                LayerManagerForm.this.updateLayerTreeVisibility(layer);
                LayerManagerForm.this.updateLayerTreeSelection(layer);
            }
        }
    }
}

