/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.imgfilter;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ConvolutionFilterBand;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.GeneralFilterBand;
import org.esa.snap.core.datamodel.Kernel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.window.OpenImageViewAction;
import org.esa.snap.rcp.imgfilter.Bundle;
import org.esa.snap.rcp.imgfilter.CreateFilteredBandDialog;
import org.esa.snap.rcp.imgfilter.model.Filter;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class FilteredBandAction
extends AbstractAction
implements LookupListener,
ContextAwareAction {
    private Lookup lookup;
    private Lookup.Result<RasterDataNode> result;

    public FilteredBandAction() {
        this(Utilities.actionsGlobalContext());
    }

    public FilteredBandAction(Lookup lookup) {
        super(Bundle.CTL_FilteredBandAction_MenuText());
        this.lookup = lookup;
        this.result = lookup.lookupResult(RasterDataNode.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.updateEnableState((RasterDataNode)this.lookup.lookup(RasterDataNode.class));
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new FilteredBandAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.updateEnableState((RasterDataNode)this.lookup.lookup(RasterDataNode.class));
    }

    private void updateEnableState(RasterDataNode node) {
        this.setEnabled(node != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.createFilteredBand();
    }

    static GeneralFilterBand.OpType getOpType(Filter.Operation operation) {
        if (operation == Filter.Operation.OPEN) {
            return GeneralFilterBand.OpType.OPENING;
        }
        if (operation == Filter.Operation.CLOSE) {
            return GeneralFilterBand.OpType.CLOSING;
        }
        if (operation == Filter.Operation.ERODE) {
            return GeneralFilterBand.OpType.EROSION;
        }
        if (operation == Filter.Operation.DILATE) {
            return GeneralFilterBand.OpType.DILATION;
        }
        if (operation == Filter.Operation.MIN) {
            return GeneralFilterBand.OpType.MIN;
        }
        if (operation == Filter.Operation.MAX) {
            return GeneralFilterBand.OpType.MAX;
        }
        if (operation == Filter.Operation.MEAN) {
            return GeneralFilterBand.OpType.MEAN;
        }
        if (operation == Filter.Operation.MEDIAN) {
            return GeneralFilterBand.OpType.MEDIAN;
        }
        if (operation == Filter.Operation.STDDEV) {
            return GeneralFilterBand.OpType.STDDEV;
        }
        throw new IllegalArgumentException("illegal operation: " + operation);
    }

    private void createFilteredBand() {
        RasterDataNode node = (RasterDataNode)this.lookup.lookup(RasterDataNode.class);
        CreateFilteredBandDialog.DialogData dialogData = this.promptForFilter();
        if (dialogData == null) {
            return;
        }
        FilterBand filterBand = FilteredBandAction.getFilterBand(node, dialogData.getBandName(), dialogData.getFilter(), dialogData.getIterationCount());
        OpenImageViewAction.openImageView((RasterDataNode)filterBand);
    }

    private static FilterBand getFilterBand(RasterDataNode sourceRaster, String bandName, Filter filter, int iterationCount) {
        ConvolutionFilterBand targetBand;
        Product targetProduct = sourceRaster.getProduct();
        if (filter.getOperation() == Filter.Operation.CONVOLVE) {
            targetBand = new ConvolutionFilterBand(bandName, sourceRaster, FilteredBandAction.getKernel(filter), iterationCount);
            if (sourceRaster instanceof Band) {
                ProductUtils.copySpectralBandProperties((Band)((Band)sourceRaster), (Band)targetBand);
            }
        } else {
            GeneralFilterBand.OpType opType = FilteredBandAction.getOpType(filter.getOperation());
            targetBand = new GeneralFilterBand(bandName, sourceRaster, opType, FilteredBandAction.getKernel(filter), iterationCount);
            if (sourceRaster instanceof Band) {
                ProductUtils.copySpectralBandProperties((Band)((Band)sourceRaster), (Band)targetBand);
            }
        }
        targetBand.setDescription(String.format("Filter '%s' (=%s) applied to '%s'", new Object[]{filter.getName(), filter.getOperation(), sourceRaster.getName()}));
        if (sourceRaster instanceof Band) {
            ProductUtils.copySpectralBandProperties((Band)((Band)sourceRaster), (Band)targetBand);
        }
        targetProduct.addBand((Band)targetBand);
        ProductUtils.copyImageGeometry((RasterDataNode)sourceRaster, (RasterDataNode)targetBand, (boolean)false);
        targetBand.fireProductNodeDataChanged();
        return targetBand;
    }

    private static Kernel getKernel(Filter filter) {
        return new Kernel(filter.getKernelWidth(), filter.getKernelHeight(), filter.getKernelOffsetX(), filter.getKernelOffsetY(), 1.0 / filter.getKernelQuotient(), filter.getKernelElements());
    }

    private CreateFilteredBandDialog.DialogData promptForFilter() {
        ProductNode selectedNode = SnapApp.getDefault().getSelectedProductNode(SnapApp.SelectionSourceHint.EXPLORER);
        Product product = selectedNode.getProduct();
        CreateFilteredBandDialog dialog = new CreateFilteredBandDialog(product, selectedNode.getName(), "createFilteredBand");
        if (dialog.show() == 1) {
            return dialog.getDialogData();
        }
        return null;
    }
}

