/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.imgfilter;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.imgfilter.Bundle;
import org.esa.snap.rcp.imgfilter.FilterEditor;
import org.esa.snap.rcp.imgfilter.FilterKernelForm;
import org.esa.snap.rcp.imgfilter.FilterPropertiesForm;
import org.esa.snap.rcp.imgfilter.model.Filter;
import org.esa.snap.rcp.util.Dialogs;

public class FilterWindow
implements FilterEditor {
    private Window parentWindow;
    private JDialog dialog;
    private FilterKernelForm kernelForm;
    private Filter filter;
    private FilterPropertiesForm propertiesForm;

    public FilterWindow(Window parentWindow) {
        this.parentWindow = parentWindow;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
        if (this.kernelForm != null) {
            this.kernelForm.setFilter(filter);
        }
        if (this.propertiesForm != null) {
            this.propertiesForm.setFilter(filter);
        }
    }

    @Override
    public void show() {
        if (this.dialog == null) {
            this.kernelForm = new FilterKernelForm(this.filter);
            this.propertiesForm = new FilterPropertiesForm(this.filter);
            this.dialog = new JDialog(this.parentWindow, Bundle.LBL_FilterWindow_Title(), Dialog.ModalityType.MODELESS);
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.addTab(Bundle.LBL_FilterWindow_Kernel(), this.kernelForm);
            tabbedPane.addTab(Bundle.LBL_FilterWindow_Properties(), this.propertiesForm);
            this.dialog.setContentPane(tabbedPane);
            final Preferences filterWindowPrefs = SnapApp.getDefault().getPreferences().node("filterWindow");
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    filterWindowPrefs.putInt("x", e.getWindow().getX());
                    filterWindowPrefs.putInt("y", e.getWindow().getY());
                    filterWindowPrefs.putInt("width", e.getWindow().getWidth());
                    filterWindowPrefs.putInt("height", e.getWindow().getHeight());
                }
            });
            Dimension preferredSize = this.dialog.getPreferredSize();
            int x = filterWindowPrefs.getInt("x", 100);
            int y = filterWindowPrefs.getInt("y", 100);
            int w = filterWindowPrefs.getInt("width", preferredSize.width);
            int h = filterWindowPrefs.getInt("height", preferredSize.height);
            this.dialog.setBounds(x, y, w, h);
            Dialogs.showInformation(Bundle.LBL_FilterWindow_Title(), Bundle.TXT_FilterWindow_Hint(), "filterWindow.moreOptions");
        }
        this.dialog.setVisible(true);
    }

    @Override
    public void hide() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }
}

