/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.imgfilter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.esa.snap.rcp.imgfilter.model.Filter;
import org.esa.snap.rcp.imgfilter.model.FilterSet;

class FilterTreeModel
implements TreeModel,
FilterSet.Listener {
    private final Root root;
    private final ArrayList<TreeModelListener> listeners;
    private final FilterSet filterSet;

    public FilterTreeModel(FilterSet filterSet) {
        this.filterSet = filterSet;
        this.filterSet.addListener(this);
        this.root = new Root();
        this.listeners = new ArrayList();
        this.createTreeNodes();
    }

    public void addFilter(Filter filter, TreePath selectionPath) {
        Object[] path;
        if (selectionPath != null && (path = selectionPath.getPath()).length >= 2) {
            Group group = (Group)path[1];
            filter.getTags().add(group.name);
        }
        this.filterSet.addFilter(filter);
    }

    public void removeFilter(Filter filter) {
        this.filterSet.removeFilter(filter);
    }

    public TreePath getFilterPath(Filter filter) {
        for (Group group : this.root.groups) {
            for (Filter filter1 : group.filters) {
                if (filter1 != filter) continue;
                return new TreePath(new Object[]{this.root, group, filter});
            }
        }
        return null;
    }

    @Override
    public void filterAdded(FilterSet filterSet, Filter filter) {
        this.insertTreeNodes(filter);
    }

    @Override
    public void filterRemoved(FilterSet filterSet, Filter filter) {
        this.removeTreeNodes(filter);
    }

    @Override
    public void filterChanged(FilterSet filterSet, Filter filter, String propertyName) {
        if ("tags".equals(propertyName)) {
            this.createTreeNodes();
            this.fireTreeStructureChanged();
        } else {
            this.fireTreeNodesChanged(filter);
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            return this.root.groups.get(index);
        }
        if (parent instanceof Group) {
            return ((Group)parent).filters.get(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.root) {
            return this.root.groups.size();
        }
        if (parent instanceof Group) {
            return ((Group)parent).filters.size();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.root) {
            return this.root.groups.indexOf(child);
        }
        if (parent instanceof Group) {
            return ((Group)parent).filters.indexOf(child);
        }
        return -1;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof Filter;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object newValue) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    private synchronized void insertTreeNodes(Filter filter) {
        HashSet<String> remainingTags = new HashSet<String>(filter.getTags());
        if (filter.getTags().isEmpty() || filter.getTags().contains(this.root.any.name)) {
            Group group = this.root.any;
            if (!this.root.groups.contains(group)) {
                this._addGroup(group);
            }
            this._addFilter(group, filter);
            remainingTags.remove(group.name);
            if (remainingTags.isEmpty()) {
                return;
            }
        }
        for (Group group : this.root.groups) {
            if (!filter.getTags().contains(group.name) && (!filter.getTags().isEmpty() || group != this.root.any)) continue;
            this._addFilter(group, filter);
            remainingTags.remove(group.name);
        }
        for (String remainingTag : remainingTags) {
            Group group = new Group(remainingTag);
            this._addGroup(group);
            this._addFilter(group, filter);
        }
    }

    private void _addGroup(Group group) {
        this.root.groups.add(group);
        this.fireTreeNodeInserted(this.root.groups.size() - 1, group);
    }

    private void _addFilter(Group group, Filter filter) {
        group.filters.add(filter);
        this.fireTreeNodeInserted(group, group.filters.size() - 1, filter);
    }

    private synchronized void removeTreeNodes(Filter filter) {
        int groupIndex = 0;
        while (groupIndex < this.root.groups.size()) {
            Group group = this.root.groups.get(groupIndex);
            int filterIndex = group.filters.indexOf(filter);
            if (filterIndex >= 0) {
                group.filters.remove(filterIndex);
                if (group.filters.isEmpty() && group != this.root.any) {
                    this.root.groups.remove(groupIndex);
                    this.fireTreeNodeRemoved(groupIndex, group);
                    continue;
                }
                this.fireTreeNodeRemoved(group, filterIndex, filter);
                ++groupIndex;
                continue;
            }
            ++groupIndex;
        }
    }

    private void fireTreeNodeInserted(int groupIndex, Group group) {
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, FilterTreeModel.getPath(this.root), new int[]{groupIndex}, new Object[]{group}));
    }

    private void fireTreeNodeInserted(Group group, int filterIndex, Filter filter) {
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, FilterTreeModel.getPath(this.root, group), new int[]{filterIndex}, new Object[]{filter}));
    }

    private void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesInserted(treeModelEvent);
        }
    }

    private void fireTreeNodeRemoved(int groupIndex, Group group) {
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, FilterTreeModel.getPath(this.root), new int[]{groupIndex}, new Object[]{group}));
    }

    private void fireTreeNodeRemoved(Group group, int filterIndex, Filter filter) {
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, FilterTreeModel.getPath(this.root, group), new int[]{filterIndex}, new Object[]{filter}));
    }

    private void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesRemoved(treeModelEvent);
        }
    }

    private void fireTreeNodesChanged(Filter filter) {
        for (Group group : this.root.groups) {
            for (Filter filter1 : group.filters) {
                if (filter1 != filter) continue;
                this.fireTreeNodeChanged(group, filter);
            }
        }
    }

    private void fireTreeNodeChanged(Group group, Filter filter) {
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, FilterTreeModel.getPath(this.root, group, filter)));
    }

    private void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesChanged(treeModelEvent);
        }
    }

    public void fireTreeStructureChanged() {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, FilterTreeModel.getPath(this.root));
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(treeModelEvent);
        }
    }

    static Object[] getPath(Object ... path) {
        return path;
    }

    private void createTreeNodes() {
        this.root.any.filters.clear();
        this.root.groups.clear();
        List<Filter> filters = this.filterSet.getFilters();
        for (Filter filter : filters) {
            this.insertTreeNodes(filter);
        }
    }

    public static class Group
    implements Comparable<Group> {
        final String name;
        final String nameLC;
        final List<Filter> filters;

        private Group(String name) {
            this.name = name;
            this.nameLC = name.toLowerCase();
            this.filters = new ArrayList<Filter>();
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return this.name.equalsIgnoreCase(group.name);
        }

        public int hashCode() {
            return this.nameLC.hashCode();
        }

        @Override
        public int compareTo(Group group) {
            return this.name.compareToIgnoreCase(group.name);
        }
    }

    public static class Root {
        final Group any = new Group("Any");
        final List<Group> groups = new ArrayList<Group>();

        private Root() {
        }

        public String toString() {
            return "Root";
        }
    }
}

