/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.imgfilter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.esa.snap.rcp.imgfilter.FilterEditor;
import org.esa.snap.rcp.imgfilter.FilterTreeModel;
import org.esa.snap.rcp.imgfilter.model.Filter;
import org.esa.snap.rcp.imgfilter.model.FilterSet;
import org.esa.snap.rcp.imgfilter.model.FilterSetStore;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.tango.TangoIcons;

public class FilterSetForm
extends JPanel {
    private FilterSet filterSet;
    private JButton addButton;
    private JButton removeButton;
    private JButton editButton;
    private JTree filterTree;
    private FilterSetStore filterSetStore;
    private FilterEditor filterEditor;
    private transient List<Listener> listeners;
    private JButton saveButton;
    private boolean modified;

    public FilterSetForm(FilterSet filterSet, FilterSetStore filterSetStore, FilterEditor filterEditor) {
        super(new BorderLayout(4, 4));
        this.filterSetStore = filterSetStore;
        this.filterEditor = filterEditor;
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.listeners = new ArrayList<Listener>();
        this.filterSet = filterSet;
        this.filterSet.addListener(new FilterSet.Listener(){

            @Override
            public void filterAdded(FilterSet filterSet, Filter filter) {
                FilterSetForm.this.setModified(true);
            }

            @Override
            public void filterRemoved(FilterSet filterSet, Filter filter) {
                FilterSetForm.this.setModified(true);
            }

            @Override
            public void filterChanged(FilterSet filterSet, Filter filter, String propertyName) {
                FilterSetForm.this.setModified(true);
            }
        });
        this.initUI();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        if (this.modified != modified) {
            this.modified = modified;
            this.updateState();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
        this.filterSet.addListener(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
        this.filterSet.removeListener(listener);
    }

    public Filter getSelectedFilterModel() {
        TreePath selectionPath = this.filterTree.getSelectionPath();
        if (selectionPath != null) {
            return this.getFilterForSelectionPath(selectionPath);
        }
        return null;
    }

    private void initUI() {
        this.addButton = new JButton(TangoIcons.actions_list_add((TangoIcons.Res)TangoIcons.Res.R22));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filter filter = Filter.create(5, new String[0]);
                filter.setEditable(true);
                FilterTreeModel model = (FilterTreeModel)FilterSetForm.this.filterTree.getModel();
                model.addFilter(filter, FilterSetForm.this.filterTree.getSelectionPath());
                TreePath filterPath = model.getFilterPath(filter);
                FilterSetForm.this.filterTree.setSelectionPath(filterPath);
            }
        });
        this.addButton.setToolTipText("Add user-defined filter");
        this.removeButton = new JButton(TangoIcons.actions_list_remove((TangoIcons.Res)TangoIcons.Res.R22));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((FilterTreeModel)FilterSetForm.this.filterTree.getModel()).removeFilter((Filter)FilterSetForm.this.filterTree.getSelectionPath().getLastPathComponent());
            }
        });
        this.removeButton.setToolTipText("Remove user-defined filter");
        this.editButton = new JButton(TangoIcons.actions_document_properties((TangoIcons.Res)TangoIcons.Res.R22));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filter filter = (Filter)FilterSetForm.this.filterTree.getSelectionPath().getLastPathComponent();
                FilterSetForm.this.filterEditor.setFilter(filter);
                FilterSetForm.this.filterEditor.show();
            }
        });
        this.editButton.setToolTipText("Show or edit properties of selected filter");
        this.saveButton = new JButton(TangoIcons.actions_document_save((TangoIcons.Res)TangoIcons.Res.R22));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FilterSetForm.this.filterSetStore.storeFilterSetModel(FilterSetForm.this.filterSet);
                    FilterSetForm.this.setModified(false);
                }
                catch (IOException ioe) {
                    Dialogs.showError("Save", "Failed to save:\n" + ioe.getMessage());
                }
            }
        });
        this.saveButton.setToolTipText("Store the selected user-defined filter");
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        toolBar.setBorderPainted(false);
        toolBar.add(this.addButton);
        toolBar.add(this.removeButton);
        toolBar.add(this.editButton);
        toolBar.add(this.saveButton);
        this.filterTree = new JTree(this.filterSet != null ? new FilterTreeModel(this.filterSet) : null);
        this.filterTree.setRootVisible(false);
        this.filterTree.setShowsRootHandles(true);
        this.filterTree.getSelectionModel().setSelectionMode(1);
        this.filterTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FilterSetForm.this.updateState();
                TreePath selectionPath = FilterSetForm.this.filterTree.getSelectionPath();
                System.out.println("TreeSelectionListener.valueChanged: selectionPath = " + selectionPath);
                Filter selectedFilter = FilterSetForm.this.getFilterForSelectionPath(selectionPath);
                if (selectedFilter != null) {
                    FilterSetForm.this.filterEditor.setFilter(selectedFilter);
                    FilterSetForm.this.fireFilterSelected(selectedFilter);
                } else {
                    Filter displayedFilter = FilterSetForm.this.filterEditor.getFilter();
                    if (!FilterSetForm.this.filterSet.containsFilter(displayedFilter)) {
                        FilterSetForm.this.filterEditor.setFilter(null);
                    }
                }
            }
        });
        this.filterTree.setCellRenderer(new MyDefaultTreeCellRenderer());
        this.filterTree.putClientProperty("JTree.lineStyle", "Angled");
        this.filterTree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                Filter filter = FilterSetForm.this.filterEditor.getFilter();
                if (filter != null) {
                    FilterTreeModel model = (FilterTreeModel)FilterSetForm.this.filterTree.getModel();
                    TreePath filterPath = model.getFilterPath(filter);
                    FilterSetForm.this.filterTree.expandPath(filterPath);
                    FilterSetForm.this.filterTree.setSelectionPath(filterPath);
                }
            }
        });
        this.expandAllTreeNodes();
        this.add((Component)new JScrollPane(this.filterTree), "Center");
        this.add((Component)toolBar, "East");
        this.updateState();
    }

    private Filter getFilterForSelectionPath(TreePath selectionPath) {
        Object lastPathComponent;
        if (selectionPath != null && (lastPathComponent = selectionPath.getLastPathComponent()) instanceof Filter) {
            return (Filter)lastPathComponent;
        }
        return null;
    }

    private void installTreeDragAndDrop() {
        this.filterTree.setDragEnabled(true);
        this.filterTree.setDropMode(DropMode.INSERT);
        this.filterTree.setDropTarget(new DropTarget(this.filterTree, 2, new DropTargetAdapter(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                System.out.println("dragEnter: dtde = " + dtde);
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                System.out.println("dragOver: dtde = " + dtde);
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
                System.out.println("dropActionChanged: dtde = " + dtde);
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
                System.out.println("dragExit: dte = " + dte);
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                System.out.println("drop: dtde = " + dtde);
            }
        }));
    }

    private void updateState() {
        TreePath selectionPath = this.filterTree.getSelectionPath();
        boolean filterModelSelected = selectionPath != null && selectionPath.getLastPathComponent() instanceof Filter;
        this.addButton.setEnabled(this.filterSet.isEditable());
        this.removeButton.setEnabled(filterModelSelected && this.filterSet.isEditable());
        this.editButton.setEnabled(filterModelSelected);
        this.saveButton.setEnabled(this.filterSet.isEditable() && this.isModified());
    }

    private void expandAllTreeNodes() {
        FilterTreeModel model = (FilterTreeModel)this.filterTree.getModel();
        int childCount = model.getChildCount(model.getRoot());
        for (int i = 0; i < childCount; ++i) {
            Object child = model.getChild(model.getRoot(), i);
            TreePath treePath = new TreePath(new Object[]{model.getRoot(), child});
            this.filterTree.expandRow(this.filterTree.getRowForPath(treePath));
        }
    }

    void fireFilterSelected(Filter filter) {
        for (Listener listener : this.listeners) {
            listener.filterSelected(this.filterSet, filter);
        }
    }

    public static interface Listener
    extends FilterSet.Listener {
        public void filterSelected(FilterSet var1, Filter var2);
    }

    private static class MyDefaultTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final Icon seIcon = new ImageIcon(FilterSetForm.class.getResource("se.png"));
        private static final Icon kernelIcon = new ImageIcon(FilterSetForm.class.getResource("kernel.png"));
        private Font plainFont;
        private Font boldFont;

        private MyDefaultTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (this.plainFont == null) {
                this.plainFont = c.getFont().deriveFont(0);
                this.boldFont = c.getFont().deriveFont(1);
            }
            c.setFont(leaf ? this.plainFont : this.boldFont);
            if (value instanceof Filter) {
                Filter filter = (Filter)value;
                c.setIcon(filter.getOperation() == Filter.Operation.CONVOLVE ? kernelIcon : seIcon);
            } else {
                c.setIcon(null);
            }
            return c;
        }
    }
}

