/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.imgfilter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.esa.snap.rcp.imgfilter.FilterKernelCanvas;
import org.esa.snap.rcp.imgfilter.model.Filter;

public class FilterKernelForm
extends JPanel
implements Filter.Listener {
    private Filter filter;
    private CanvasMouseListener canvasMouseListener;
    private FilterKernelCanvas kernelCanvas;
    private JSpinner kernelWidthSpinner;
    private JSpinner kernelHeightSpinner;
    private JComboBox<Number> fillValueCombo;
    private double fillValue;
    private final DefaultComboBoxModel<Number> structuringFillValueModel = new DefaultComboBoxModel<Number>(new Number[]{0, 1});
    private final DefaultComboBoxModel<Number> kernelFillValueModel = new DefaultComboBoxModel<Number>(new Number[]{-5.0, -4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0});

    public FilterKernelForm(Filter filter) {
        super(new BorderLayout(4, 4));
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.filter = null;
        this.fillValue = 0.0;
        this.setFilter(filter);
    }

    public double getFillValue() {
        return this.fillValue;
    }

    public void setFillValue(double fillValue) {
        double fillValueOld = this.fillValue;
        this.fillValue = fillValue;
        this.firePropertyChange("fillValue", fillValueOld, fillValue);
    }

    @Override
    public void filterChanged(Filter filter, String propertyName) {
        if (this.filter != filter) {
            return;
        }
        boolean structureElement = filter.getOperation() != Filter.Operation.CONVOLVE;
        this.fillValueCombo.setModel(structureElement ? this.structuringFillValueModel : this.kernelFillValueModel);
        int kernelWidth = filter.getKernelWidth();
        int kernelHeight = filter.getKernelHeight();
        if (this.kernelWidthSpinner != null && ((Number)this.kernelWidthSpinner.getValue()).intValue() != kernelWidth) {
            this.kernelWidthSpinner.setValue(kernelWidth);
        }
        if (this.kernelHeightSpinner != null && ((Number)this.kernelHeightSpinner.getValue()).intValue() != kernelHeight) {
            this.kernelHeightSpinner.setValue(kernelHeight);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(320, 320);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        Filter filterOld = this.filter;
        if (filterOld != filter) {
            if (this.filter != null) {
                this.filter.removeListener(this);
            }
            this.filter = filter;
            this.initUI();
            if (this.filter != null) {
                this.filter.addListener(this);
            }
            this.firePropertyChange("filter", filterOld, this.filter);
        }
    }

    private void initUI() {
        this.removeAll();
        if (this.kernelCanvas != null && this.canvasMouseListener != null) {
            this.kernelCanvas.removeMouseListener(this.canvasMouseListener);
            this.kernelCanvas.removeMouseMotionListener(this.canvasMouseListener);
            this.kernelCanvas = null;
        }
        this.fillValueCombo = null;
        this.kernelHeightSpinner = null;
        this.kernelWidthSpinner = null;
        if (this.filter == null) {
            this.invalidate();
            this.revalidate();
            this.repaint();
            return;
        }
        this.kernelCanvas = new FilterKernelCanvas(this.filter);
        if (this.canvasMouseListener == null) {
            this.canvasMouseListener = new CanvasMouseListener();
        }
        this.kernelCanvas.addMouseListener(this.canvasMouseListener);
        if (this.filter.isEditable()) {
            this.kernelCanvas.addMouseMotionListener(this.canvasMouseListener);
        }
        if (this.filter.isEditable()) {
            boolean structureElement;
            boolean bl = structureElement = this.filter.getOperation() != Filter.Operation.CONVOLVE;
            if (structureElement) {
                this.fillValueCombo = new JComboBox<Number>(this.structuringFillValueModel);
                ((JTextField)this.fillValueCombo.getEditor().getEditorComponent()).setColumns(1);
                this.fillValueCombo.setEditable(false);
                this.fillValueCombo.setSelectedItem((int)this.getFillValue());
            } else {
                this.fillValueCombo = new JComboBox<Number>(this.kernelFillValueModel);
                ((JTextField)this.fillValueCombo.getEditor().getEditorComponent()).setColumns(3);
                this.fillValueCombo.setEditable(true);
                this.fillValueCombo.setSelectedItem(this.getFillValue());
            }
            this.fillValueCombo.addItemListener(e -> this.setFillValue(((Number)this.fillValueCombo.getSelectedItem()).doubleValue()));
            this.fillValueCombo.setToolTipText("Value that will be used to set a kernel element when clicking into the matrix");
            this.kernelWidthSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
            this.kernelWidthSpinner.setValue(this.filter.getKernelHeight());
            this.kernelWidthSpinner.addChangeListener(e -> {
                Integer kernelWidth = (Integer)this.kernelWidthSpinner.getValue();
                this.filter.setKernelSize(kernelWidth, this.filter.getKernelHeight());
            });
            this.kernelWidthSpinner.setToolTipText("Width of the kernel (number of matrix columns)");
            this.kernelHeightSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
            this.kernelHeightSpinner.setValue(this.filter.getKernelWidth());
            this.kernelHeightSpinner.addChangeListener(e -> {
                Integer kernelHeight = (Integer)this.kernelHeightSpinner.getValue();
                this.filter.setKernelSize(this.filter.getKernelWidth(), kernelHeight);
            });
            this.kernelHeightSpinner.setToolTipText("Height of the kernel (number of matrix rows)");
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.setRollover(true);
            toolBar.add(new JLabel("Fill:"));
            toolBar.add(this.fillValueCombo);
            toolBar.add(Box.createHorizontalStrut(32));
            toolBar.add(new JLabel(" W:"));
            toolBar.add(this.kernelWidthSpinner);
            toolBar.add(new JLabel(" H:"));
            toolBar.add(this.kernelHeightSpinner);
            this.add((Component)this.kernelCanvas, "Center");
            this.add((Component)toolBar, "South");
        } else {
            this.add((Component)this.kernelCanvas, "Center");
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    protected JPopupMenu createPopupMenu(FilterKernelCanvas kernelCanvas) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem copyItem = new JMenuItem("Copy");
        copyItem.addActionListener(e -> {
            Clipboard systemClip = Toolkit.getDefaultToolkit().getSystemClipboard();
            systemClip.setContents(new StringSelection(kernelCanvas.getFilter().getKernelElementsAsText()), null);
        });
        popupMenu.add(copyItem);
        if (!this.filter.isEditable()) {
            return popupMenu;
        }
        JMenuItem pasteItem = new JMenuItem("Paste");
        pasteItem.setEnabled(this.isPastePossible());
        pasteItem.addActionListener(e -> {
            Clipboard systemClip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transfer = systemClip.getContents(null);
            try {
                String data = (String)transfer.getTransferData(DataFlavor.stringFlavor);
                kernelCanvas.getFilter().setKernelElementsFromText(data);
                kernelCanvas.getFilter().adjustKernelQuotient();
            }
            catch (Error | RuntimeException e1) {
                e1.printStackTrace();
                throw e1;
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        });
        popupMenu.add(pasteItem);
        JMenuItem clearItem = new JMenuItem("Clear");
        clearItem.addActionListener(e -> kernelCanvas.getFilter().fillRectangle(0.0));
        popupMenu.add(clearItem);
        popupMenu.addSeparator();
        double fillValue = this.getFillValue();
        String fillValueText = fillValue == (double)((int)fillValue) ? String.valueOf((int)fillValue) : String.valueOf(fillValue);
        JMenuItem fillRectangleItem = new JMenuItem(String.format("Fill Rectangle by <%s>", fillValueText));
        fillRectangleItem.addActionListener(e -> {
            kernelCanvas.getFilter().fillRectangle(fillValue);
            kernelCanvas.getFilter().adjustKernelQuotient();
        });
        popupMenu.add(fillRectangleItem);
        JMenuItem fillEllipseItem = new JMenuItem(String.format("Fill Ellipse by <%s>", fillValueText));
        fillEllipseItem.addActionListener(e -> {
            kernelCanvas.getFilter().fillEllipse(fillValue);
            kernelCanvas.getFilter().adjustKernelQuotient();
        });
        popupMenu.add(fillEllipseItem);
        JMenuItem fillGaussItem = new JMenuItem("Fill Gaussian");
        fillGaussItem.addActionListener(e -> {
            kernelCanvas.getFilter().fillGaussian();
            kernelCanvas.getFilter().adjustKernelQuotient();
        });
        popupMenu.add(fillGaussItem);
        JMenuItem fillLaplaceItem = new JMenuItem("Fill Laplacian");
        fillLaplaceItem.addActionListener(e -> {
            kernelCanvas.getFilter().fillLaplacian();
            kernelCanvas.getFilter().adjustKernelQuotient();
        });
        popupMenu.add(fillLaplaceItem);
        JMenuItem fillRandomItem = new JMenuItem("Fill Random");
        fillRandomItem.addActionListener(e -> {
            kernelCanvas.getFilter().fillRandom();
            kernelCanvas.getFilter().adjustKernelQuotient();
        });
        popupMenu.add(fillRandomItem);
        return popupMenu;
    }

    private boolean isPastePossible() {
        boolean enabled = false;
        Clipboard systemClip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transfer = systemClip.getContents(null);
        if (transfer.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String data = (String)transfer.getTransferData(DataFlavor.stringFlavor);
                enabled = Filter.isKernelDataText(data);
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        return enabled;
    }

    private class CanvasMouseListener
    extends MouseAdapter {
        private CanvasMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            FilterKernelCanvas kernelCanvas = (FilterKernelCanvas)e.getComponent();
            if (e.isPopupTrigger()) {
                this.showPopup(e, kernelCanvas);
            } else {
                kernelCanvas.getFilter().adjustKernelQuotient();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            FilterKernelCanvas kernelCanvas = (FilterKernelCanvas)e.getComponent();
            if (e.isPopupTrigger()) {
                this.showPopup(e, kernelCanvas);
            } else if (e.getButton() == 1 && kernelCanvas.getFilter().isEditable()) {
                this.setElement(kernelCanvas, e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            boolean button1;
            boolean bl = button1 = (e.getModifiersEx() & 0x400) != 0;
            if (button1 && FilterKernelForm.this.kernelCanvas.getFilter().isEditable()) {
                FilterKernelCanvas kernelCanvas = (FilterKernelCanvas)e.getComponent();
                this.setElement(kernelCanvas, e);
            }
        }

        private void showPopup(MouseEvent e, FilterKernelCanvas kernelCanvas) {
            e.consume();
            JPopupMenu popupMenu = FilterKernelForm.this.createPopupMenu(kernelCanvas);
            popupMenu.show(kernelCanvas, e.getX(), e.getY());
        }

        private void setElement(FilterKernelCanvas kernelCanvas, MouseEvent e) {
            int index = kernelCanvas.getKernelElementIndex(e.getX(), e.getY());
            if (index >= 0) {
                kernelCanvas.getFilter().setKernelElement(index, FilterKernelForm.this.getFillValue());
            }
        }
    }
}

