/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.imgfilter;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.imgfilter.FilterSetFileStore;
import org.esa.snap.rcp.imgfilter.FilterSetForm;
import org.esa.snap.rcp.imgfilter.FilterSetsForm;
import org.esa.snap.rcp.imgfilter.FilterWindow;
import org.esa.snap.rcp.imgfilter.model.Filter;
import org.esa.snap.rcp.imgfilter.model.FilterSet;
import org.esa.snap.rcp.imgfilter.model.StandardFilters;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.ModalDialog;

public class CreateFilteredBandDialog
extends ModalDialog
implements FilterSetForm.Listener {
    public static final String TITLE = "Create Filtered Band";
    private final Product product;
    private final FilterSetsForm filterSetsForm;
    private final FilterSetFileStore filterSetStore;
    private List<FilterSet> userFilterSets;

    public CreateFilteredBandDialog(Product product, String sourceBandName, String helpId) {
        super((Window)SnapApp.getDefault().getMainFrame(), TITLE, 161, helpId);
        this.product = product;
        FilterSet systemFilterSet = new FilterSet("System", false);
        systemFilterSet.addFilter("Detect Lines", StandardFilters.LINE_DETECTION_FILTERS);
        systemFilterSet.addFilter("Detect Gradients (Emboss)", StandardFilters.GRADIENT_DETECTION_FILTERS);
        systemFilterSet.addFilter("Smooth and Blurr", StandardFilters.SMOOTHING_FILTERS);
        systemFilterSet.addFilter("Sharpen", StandardFilters.SHARPENING_FILTERS);
        systemFilterSet.addFilter("Enhance Discontinuities", StandardFilters.LAPLACIAN_FILTERS);
        systemFilterSet.addFilter("Non-Linear Filters", StandardFilters.NON_LINEAR_FILTERS);
        systemFilterSet.addFilter("Morphological Filters", StandardFilters.MORPHOLOGICAL_FILTERS);
        this.filterSetStore = new FilterSetFileStore(this.getFiltersDir());
        try {
            this.userFilterSets = this.filterSetStore.loadFilterSetModels();
        }
        catch (IOException e) {
            this.userFilterSets = new ArrayList<FilterSet>();
            Dialogs.showError(TITLE, "Failed to load filter sets:\n" + e.getMessage());
            SystemUtils.LOG.log(Level.WARNING, "Failed to load filter sets", e);
        }
        ArrayList<FilterSet> filterSets = new ArrayList<FilterSet>();
        filterSets.add(systemFilterSet);
        if (this.userFilterSets.isEmpty()) {
            this.userFilterSets.add(new FilterSet("User", true));
        }
        filterSets.addAll(this.userFilterSets);
        this.filterSetsForm = new FilterSetsForm(sourceBandName, this, this.filterSetStore, new FilterWindow(this.getJDialog()), filterSets.toArray(new FilterSet[filterSets.size()]));
        this.setContent(this.filterSetsForm);
    }

    protected void onOK() {
        super.onOK();
        for (FilterSet userFilterSet : this.userFilterSets) {
            userFilterSet.setEditable(true);
            try {
                this.filterSetStore.storeFilterSetModel(userFilterSet);
            }
            catch (IOException e) {
                Dialogs.showError(TITLE, "Failed to store filter sets:\n" + e.getMessage());
            }
        }
    }

    public DialogData getDialogData() {
        return new DialogData(this.filterSetsForm.getSelectedFilter(), this.filterSetsForm.getTargetBandName(), this.filterSetsForm.getIterationCount());
    }

    protected boolean verifyUserInput() {
        String message = null;
        String targetBandName = this.filterSetsForm.getTargetBandName();
        if (targetBandName.equals("")) {
            message = "Please enter a name for the new filtered band.";
        } else if (!ProductNode.isValidNodeName((String)targetBandName)) {
            message = MessageFormat.format("The band name ''{0}'' appears not to be valid.\nPlease choose a different band name.", targetBandName);
        } else if (this.product.containsBand(targetBandName)) {
            message = MessageFormat.format("The selected product already contains a band named ''{0}''.\nPlease choose a different band name.", targetBandName);
        } else if (this.filterSetsForm.getSelectedFilter() == null) {
            message = "Please select an image filter.";
        }
        if (message != null) {
            Dialogs.showError(TITLE, message);
            return false;
        }
        return true;
    }

    @Override
    public void filterSelected(FilterSet filterSet, Filter filter) {
    }

    @Override
    public void filterAdded(FilterSet filterSet, Filter filter) {
    }

    @Override
    public void filterRemoved(FilterSet filterSet, Filter filter) {
    }

    @Override
    public void filterChanged(FilterSet filterSet, Filter filter, String propertyName) {
    }

    private File getFiltersDir() {
        return new File(SystemUtils.getAuxDataPath().toFile(), "image_filters");
    }

    public static class DialogData {
        private final Filter filter;
        private final String bandName;
        private final int iterationCount;

        private DialogData(Filter filter, String bandName, int iterationCount) {
            this.filter = filter;
            this.bandName = bandName;
            this.iterationCount = iterationCount;
        }

        public String getBandName() {
            return this.bandName;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public int getIterationCount() {
            return this.iterationCount;
        }
    }
}

