/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.developer;

import com.sun.media.jai.util.CacheDiagnostics;
import com.sun.media.jai.util.SunTileCache;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.CachedTile;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileCache;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import org.esa.snap.core.image.RasterDataNodeOpImage;
import org.esa.snap.core.image.SingleBandedOpImage;
import org.esa.snap.core.image.VirtualBandOpImage;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.chart.util.UnitType;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class TileCacheMonitor {
    private JTabbedPane tabbedPane;
    private static final String CACHE_INFO_TAB = "Cache Info";
    private static final String CACHE_CHART_TAB = "Cache Chart";
    private static final String IMAGES_TAB = "Images in Cache";
    private TimeSeriesCollection[] datasets;
    private TileCacheTableModel tableModel;
    private JTextArea textarea;

    public JPanel createPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        CombinedDomainXYPlot plot = new CombinedDomainXYPlot((ValueAxis)new DateAxis("Time"));
        this.datasets = new TimeSeriesCollection[4];
        this.datasets[0] = TileCacheMonitor.addSubPlot(plot, "#Tiles");
        this.datasets[1] = TileCacheMonitor.addSubPlot(plot, "#Hits");
        this.datasets[2] = TileCacheMonitor.addSubPlot(plot, "#Misses");
        this.datasets[3] = TileCacheMonitor.addSubPlot(plot, "Mem (kB)");
        JFreeChart chart = new JFreeChart((Plot)plot);
        LegendTitle legend = (LegendTitle)chart.getSubtitle(0);
        legend.setPosition(RectangleEdge.RIGHT);
        legend.setMargin(new RectangleInsets(UnitType.ABSOLUTE, 0.0, 4.0, 0.0, 4.0));
        chart.setBorderPaint((Paint)Color.black);
        chart.setBorderVisible(true);
        chart.setBackgroundPaint((Paint)Color.white);
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(4.0, 4.0, 4.0, 4.0));
        ValueAxis axis = plot.getDomainAxis();
        axis.setAutoRange(true);
        axis.setFixedAutoRange(60000.0);
        this.textarea = new JTextArea();
        this.tableModel = new TileCacheTableModel();
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 470));
        chartPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(CACHE_INFO_TAB, new JScrollPane(this.textarea));
        this.tabbedPane.add(CACHE_CHART_TAB, (Component)chartPanel);
        this.tabbedPane.add(IMAGES_TAB, new JScrollPane(new JTable(this.tableModel)));
        this.tabbedPane.setSelectedIndex(0);
        mainPanel.add(this.tabbedPane);
        return mainPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateState() {
        TileCache tileCache = JAI.getDefaultInstance().getTileCache();
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex == 1) {
            if (tileCache instanceof CacheDiagnostics) {
                CacheDiagnostics cacheDiagnostics = (CacheDiagnostics)tileCache;
                cacheDiagnostics.enableDiagnostics();
                Millisecond t = new Millisecond();
                this.update(0, t, cacheDiagnostics.getCacheTileCount());
                this.update(1, t, cacheDiagnostics.getCacheHitCount());
                this.update(2, t, cacheDiagnostics.getCacheMissCount());
                this.update(3, t, cacheDiagnostics.getCacheMemoryUsed() / 1024L);
            }
        } else if (selectedIndex == 2) {
            if (tileCache instanceof SunTileCache) {
                SunTileCache stc;
                SunTileCache t = stc = (SunTileCache)tileCache;
                synchronized (t) {
                    Hashtable cachedObject = (Hashtable)stc.getCachedObject();
                    Collection<CachedTile> tiles = cachedObject.values();
                    this.updateTableModel(tiles);
                }
            }
        } else if (selectedIndex == 0) {
            StringBuilder sb = new StringBuilder();
            if (tileCache != null) {
                sb.append("tileCache.memoryCapacity: \t");
                sb.append(tileCache.getMemoryCapacity() / 0x100000L);
                sb.append(" MB\n");
                sb.append("tileCache.memoryThreshold: \t");
                sb.append(tileCache.getMemoryThreshold());
                sb.append("\n");
                sb.append("tileCache.tileComparator: \t");
                sb.append(tileCache.getTileComparator());
                sb.append("\n");
                sb.append("tileCache.class: \t");
                sb.append(tileCache.getClass().getName());
                sb.append("\n");
            }
            if (tileCache instanceof SunTileCache) {
                SunTileCache sunTileCache = (SunTileCache)tileCache;
                sb.append("sunTileCache.cacheMemoryUsed: \t");
                sb.append(sunTileCache.getCacheMemoryUsed() / 0x100000L);
                sb.append(" MB\n");
                sb.append("sunTileCache.cacheHitCount: \t");
                sb.append(sunTileCache.getCacheHitCount());
                sb.append("\n");
                sb.append("sunTileCache.cacheMissCount: \t");
                sb.append(sunTileCache.getCacheMissCount());
                sb.append("\n");
                sb.append("sunTileCache.cacheTileCount: \t");
                sb.append(sunTileCache.getCacheTileCount());
                sb.append("\n");
            }
            this.textarea.setText(sb.toString());
        }
    }

    private void updateTableModel(Collection<CachedTile> tiles) {
        this.tableModel.reset();
        for (CachedTile sct : tiles) {
            RenderedImage owner = sct.getOwner();
            if (owner == null || !(owner instanceof PlanarImage)) continue;
            PlanarImage image = (PlanarImage)owner;
            Object imageID = image.getImageID();
            CachedTileInfo cachedTileInfo = null;
            for (CachedTileInfo info : this.tableModel.data) {
                if (!info.uid.equals(imageID)) continue;
                cachedTileInfo = info;
                break;
            }
            if (cachedTileInfo == null) {
                cachedTileInfo = new CachedTileInfo();
                cachedTileInfo.uid = imageID;
                cachedTileInfo.imageName = this.getImageName((RenderedImage)image);
                cachedTileInfo.level = this.getImageLevel((RenderedImage)image);
                cachedTileInfo.comment = this.getImageComment((RenderedImage)image);
                this.tableModel.data.add(cachedTileInfo);
            }
            ++cachedTileInfo.numTiles;
            cachedTileInfo.size += sct.getTileSize();
        }
        this.tableModel.cleanUp();
        this.tableModel.fireTableDataChanged();
    }

    private String getImageName(RenderedImage image) {
        return image.getClass().getSimpleName();
    }

    private int getImageLevel(RenderedImage image) {
        if (image instanceof SingleBandedOpImage) {
            SingleBandedOpImage sboi = (SingleBandedOpImage)image;
            return sboi.getLevel();
        }
        return -1;
    }

    private String getImageComment(RenderedImage image) {
        if (image instanceof RasterDataNodeOpImage) {
            RasterDataNodeOpImage rdnoi = (RasterDataNodeOpImage)image;
            return rdnoi.getRasterDataNode().getName();
        }
        if (image instanceof VirtualBandOpImage) {
            VirtualBandOpImage vboi = (VirtualBandOpImage)image;
            return vboi.getExpression();
        }
        String s = image.toString();
        int p1 = s.indexOf(91);
        int p2 = s.indexOf(93, p1 + 1);
        if (p1 > 0 && p2 > p1) {
            return s.substring(p1 + 1, p2 - 1);
        }
        return s;
    }

    private void dumpImageTree(Collection<CachedTile> tiles) {
        HashMap<RenderedImage, Integer> ownerMap = new HashMap<RenderedImage, Integer>(100);
        HashMap<RenderedImage, Long> sizeMap = new HashMap<RenderedImage, Long>(100);
        for (CachedTile sct : tiles) {
            RenderedImage owner = sct.getOwner();
            if (owner == null) continue;
            Integer count = (Integer)ownerMap.get(owner);
            if (count == null) {
                ownerMap.put(owner, 1);
            } else {
                ownerMap.put(owner, count + 1);
            }
            Long size = (Long)sizeMap.get(owner);
            if (size == null) {
                sizeMap.put(owner, sct.getTileSize());
                continue;
            }
            sizeMap.put(owner, size + sct.getTileSize());
        }
        HashSet<RenderedImage> rootEntries = new HashSet<RenderedImage>(ownerMap.keySet());
        for (RenderedImage image : ownerMap.keySet()) {
            Vector<RenderedImage> sources = image.getSources();
            this.eleminateSources(sources, rootEntries);
        }
        for (RenderedImage image : rootEntries) {
            this.printImage(image, (Integer)ownerMap.get(image), (Long)sizeMap.get(image));
            this.printSources("", image.getSources(), ownerMap, sizeMap);
        }
        System.out.println("======================================");
    }

    private void eleminateSources(Vector<RenderedImage> sources, Set<RenderedImage> rootEntries) {
        if (sources != null) {
            for (RenderedImage renderedImage : sources) {
                if (rootEntries.contains(renderedImage)) {
                    rootEntries.remove(renderedImage);
                }
                this.eleminateSources(renderedImage.getSources(), rootEntries);
            }
        }
    }

    private void printSources(String prefix, Vector<RenderedImage> sources, Map<RenderedImage, Integer> ownerMap, Map<RenderedImage, Long> sizeMap) {
        if (sources != null) {
            for (RenderedImage image : sources) {
                System.out.print(prefix + "->");
                if (ownerMap.containsKey(image)) {
                    this.printImage(image, ownerMap.get(image), sizeMap.get(image));
                } else {
                    this.printImage(image, 0, 0L);
                }
                this.printSources("--" + prefix, image.getSources(), ownerMap, sizeMap);
            }
        }
    }

    private void printImage(RenderedImage image, int numTiles, Long size) {
        int level;
        System.out.print("(" + this.getImageName(image) + ")  ");
        if (numTiles > 0) {
            System.out.print("#tiles=" + numTiles + "  ");
            System.out.printf("size=%8.2fMB  ", (double)size.longValue() / 1048576.0);
        }
        if ((level = this.getImageLevel(image)) >= 0) {
            System.out.print("level=" + level + "  ");
        }
        System.out.print(this.getImageComment(image));
        System.out.println();
    }

    private static TimeSeriesCollection addSubPlot(CombinedDomainXYPlot plot, String label) {
        TimeSeriesCollection seriesCollection = new TimeSeriesCollection(new TimeSeries((Comparable)((Object)label)));
        NumberAxis rangeAxis = new NumberAxis();
        rangeAxis.setAutoRangeIncludesZero(false);
        XYPlot subplot = new XYPlot((XYDataset)seriesCollection, null, (ValueAxis)rangeAxis, (XYItemRenderer)new StandardXYItemRenderer());
        subplot.setBackgroundPaint((Paint)Color.lightGray);
        subplot.setDomainGridlinePaint((Paint)Color.white);
        subplot.setRangeGridlinePaint((Paint)Color.white);
        plot.add(subplot);
        return seriesCollection;
    }

    private void update(int i, Millisecond t, double value) {
        this.datasets[i].getSeries(0).add((RegularTimePeriod)t, value);
    }

    private static class TileCacheTableModel
    extends AbstractTableModel {
        private static final String[] COLUM_NAMES = new String[]{"Image", "#Tiles", "Size (kB)", "Level", "Comment"};
        private static final Class[] COLUM_CLASSES = new Class[]{String.class, Integer.class, Long.class, Integer.class, String.class};
        List<CachedTileInfo> data = new ArrayList<CachedTileInfo>(50);

        private TileCacheTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return COLUM_NAMES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUM_NAMES[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return COLUM_CLASSES[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            CachedTileInfo cachedTileInfo = this.data.get(row);
            switch (column) {
                case 0: {
                    return cachedTileInfo.imageName;
                }
                case 1: {
                    return cachedTileInfo.numTiles;
                }
                case 2: {
                    return cachedTileInfo.size / 1024L;
                }
                case 3: {
                    return cachedTileInfo.level;
                }
                case 4: {
                    return cachedTileInfo.comment;
                }
            }
            return null;
        }

        public void reset() {
            for (CachedTileInfo tileInfo : this.data) {
                tileInfo.numTiles = 0;
                tileInfo.size = 0L;
            }
        }

        public void cleanUp() {
            Iterator<CachedTileInfo> iterator = this.data.iterator();
            while (iterator.hasNext()) {
                CachedTileInfo tileInfo = iterator.next();
                if (tileInfo.numTiles != 0) continue;
                iterator.remove();
            }
        }

        public void addRow(CachedTileInfo tileInfo) {
            this.data.add(tileInfo);
        }
    }

    private static class CachedTileInfo {
        Object uid;
        String imageName;
        int level;
        int numTiles;
        long size;
        String comment;

        private CachedTileInfo() {
        }
    }
}

