/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import org.esa.snap.rcp.colormanip.NumberPlainDocument;

class SliderPanel
extends JPanel {
    private final ChangeListener localChangeListener;
    private final JSlider slider;
    private final JTextField input;
    private final ChangeListener sliderChangeListener;
    private final JLabel titleLabel;
    private int previousValue;

    SliderPanel(String title, ChangeListener sliderChangeListener) {
        super(new BorderLayout());
        BasicSliderUI ui;
        int maximumNumber = 100;
        this.sliderChangeListener = sliderChangeListener;
        this.previousValue = 0;
        this.titleLabel = new JLabel(title, 2);
        this.titleLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.slider = new JSlider(0, -maximumNumber, maximumNumber, this.previousValue);
        this.slider.setFocusable(false);
        this.slider.setMajorTickSpacing(maximumNumber);
        this.slider.setMinorTickSpacing(0);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        MouseListener[] listeners = this.slider.getMouseListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.slider.removeMouseListener(listeners[i]);
        }
        BasicSliderUI basicSliderUI = ui = (BasicSliderUI)this.slider.getUI();
        Objects.requireNonNull(basicSliderUI);
        BasicSliderUI.TrackListener trackListener = new BasicSliderUI.TrackListener(basicSliderUI){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SliderPanel.this.slider.isEnabled()) {
                    Point mousePoint = event.getPoint();
                    int value = ui.valueForXPosition(mousePoint.x);
                    SliderPanel.this.slider.setValue(value);
                }
            }

            @Override
            public boolean shouldScroll(int direction) {
                return false;
            }
        };
        this.slider.addMouseListener(trackListener);
        this.localChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                SliderPanel.this.sliderValueChanged(event);
            }
        };
        this.slider.addChangeListener(this.localChangeListener);
        this.input = new JTextField(5);
        this.input.setDocument(new NumberPlainDocument(this.slider.getMinimum(), this.slider.getMaximum()));
        this.input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    int number = Integer.parseInt(SliderPanel.this.input.getText());
                    SliderPanel.this.slider.setValue(number);
                }
            }
        });
        this.refreshInputValue();
        JPanel panelInput = new JPanel(new FlowLayout());
        panelInput.add(this.input);
        this.add((Component)this.titleLabel, "West");
        this.add((Component)this.slider, "Center");
        this.add((Component)panelInput, "East");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.titleLabel.setEnabled(enabled);
        this.slider.setEnabled(enabled);
        this.input.setEnabled(enabled);
    }

    public int getTitlePreferredWidth() {
        return this.titleLabel.getPreferredSize().width;
    }

    public void setTitlePreferredWidth(int preferredWidth) {
        Dimension size = this.titleLabel.getPreferredSize();
        size.width = preferredWidth;
        this.titleLabel.setPreferredSize(size);
    }

    public int getSliderMaximumValue() {
        return this.slider.getMaximum();
    }

    public int getSliderValue() {
        return this.slider.getValue();
    }

    public void setSliderValue(int sliderValue) {
        this.slider.removeChangeListener(this.localChangeListener);
        this.previousValue = sliderValue;
        this.slider.setValue(this.previousValue);
        this.refreshInputValue();
        this.slider.addChangeListener(this.localChangeListener);
    }

    private void refreshInputValue() {
        String value = Integer.toString(this.slider.getValue());
        this.input.setText(value);
    }

    private void sliderValueChanged(ChangeEvent event) {
        int currentSliderValue = this.slider.getValue();
        if (!this.slider.getValueIsAdjusting() && currentSliderValue != this.previousValue) {
            this.previousValue = currentSliderValue;
            this.refreshInputValue();
            this.sliderChangeListener.stateChanged(event);
        }
    }
}

