/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import com.bc.ceres.core.runtime.internal.Platform;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import org.esa.snap.core.datamodel.ColorSchemeInfo;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.ColorSchemeManager;
import org.esa.snap.rcp.colormanip.ColorUtils;
import org.esa.snap.rcp.colormanip.ImageInfoEditor2;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.openide.util.ImageUtilities;

class ImageInfoEditorSupport {
    final AbstractButton autoStretch1SigmaButton;
    final AbstractButton autoStretch2SigmaButton;
    final AbstractButton autoStretch3SigmaButton;
    final AbstractButton autoStretch95Button;
    final AbstractButton autoStretch100Button;
    final AbstractButton zoomInVButton;
    final AbstractButton zoomOutVButton;
    final AbstractButton zoomInHButton;
    final AbstractButton zoomOutHButton;
    final AbstractButton showExtraInfoButton;
    final AbstractButton setRGBminmax;
    final AbstractButton zoomHorizontalButton;
    final AbstractButton zoomVerticalButton;
    final ImageInfoEditor2 imageInfoEditor;
    ColorManipulationForm form;
    final Boolean[] horizontalZoomButtonEnabled = new Boolean[]{true};

    protected ImageInfoEditorSupport(ImageInfoEditor2 imageInfoEditor, boolean zoomDefault) {
        this.imageInfoEditor = imageInfoEditor;
        this.form = imageInfoEditor.getParentForm();
        this.autoStretch1SigmaButton = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/Auto1SigmaPercent24.gif");
        this.autoStretch1SigmaButton.setName("AutoStretch1SigmaButton");
        this.autoStretch1SigmaButton.setToolTipText("Auto-adjust to 1 sigma (68.27%) of all pixels");
        this.autoStretch1SigmaButton.addActionListener(this.form.wrapWithAutoApplyActionListener(e -> this.compute1SigmaPercent()));
        this.autoStretch2SigmaButton = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/Auto2SigmaPercent24.gif");
        this.autoStretch2SigmaButton.setName("AutoStretch2SigmaButton");
        this.autoStretch2SigmaButton.setToolTipText("Auto-adjust to 2 sigma (95.45%) of all pixels");
        this.autoStretch2SigmaButton.addActionListener(this.form.wrapWithAutoApplyActionListener(e -> this.compute2SigmaPercent()));
        this.autoStretch3SigmaButton = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/Auto3SigmaPercent24.gif");
        this.autoStretch3SigmaButton.setName("AutoStretch3SigmaButton");
        this.autoStretch3SigmaButton.setToolTipText("Auto-adjust to 3 sigma (99.73%) of all pixels");
        this.autoStretch3SigmaButton.addActionListener(this.form.wrapWithAutoApplyActionListener(e -> this.compute3SigmaPercent()));
        this.autoStretch95Button = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/Auto95Percent24.gif");
        this.autoStretch95Button.setName("AutoStretch95Button");
        this.autoStretch95Button.setToolTipText("Auto-adjust to 95% of all pixels");
        this.autoStretch95Button.addActionListener(this.form.wrapWithAutoApplyActionListener(e -> this.compute95Percent()));
        this.autoStretch100Button = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/Auto100Percent24.gif");
        this.autoStretch100Button.setName("AutoStretch100Button");
        this.autoStretch100Button.setToolTipText("Auto-adjust to 100% of all pixels");
        this.autoStretch100Button.addActionListener(this.form.wrapWithAutoApplyActionListener(e -> this.compute100Percent()));
        this.setRGBminmax = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/AutoPresetRange24.png");
        this.setRGBminmax.setName("setRGBminmax");
        String optionsLocation = this.getOptionsLocation();
        this.setRGBminmax.setToolTipText("<html>Set channel range with pre-set values (see " + optionsLocation + ")</html>");
        this.setRGBminmax.addActionListener(this.form.wrapWithAutoApplyActionListener(e -> this.setRGBminmax()));
        this.zoomInVButton = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/ZoomIn24V.gif");
        this.zoomInVButton.setName("zoomInVButton");
        this.zoomInVButton.setToolTipText("Stretch histogram vertically");
        this.zoomInVButton.addActionListener(e -> imageInfoEditor.computeZoomInVertical());
        this.zoomOutVButton = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/ZoomOut24V.gif");
        this.zoomOutVButton.setName("zoomOutVButton");
        this.zoomOutVButton.setToolTipText("Shrink histogram vertically");
        this.zoomOutVButton.addActionListener(e -> imageInfoEditor.computeZoomOutVertical());
        this.zoomInHButton = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/ZoomIn24H.gif");
        this.zoomInHButton.setName("zoomInHButton");
        this.zoomInHButton.setToolTipText("Stretch histogram horizontally");
        this.zoomInHButton.addActionListener(e -> imageInfoEditor.computeZoomInToSliderLimits());
        this.zoomOutHButton = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/ZoomOut24H.gif");
        this.zoomOutHButton.setName("zoomOutHButton");
        this.zoomOutHButton.setToolTipText("Shrink histogram horizontally");
        this.zoomOutHButton.addActionListener(e -> imageInfoEditor.computeZoomOutToFullHistogramm());
        this.zoomHorizontalButton = ImageInfoEditorSupport.createToggleButton("org/esa/snap/rcp/icons/ZoomHorizontal24.gif");
        this.zoomHorizontalButton.setName("zoomHorizontalButton");
        this.zoomHorizontalButton.setToolTipText("Expand and shrink histogram horizontally");
        this.zoomHorizontalButton.setSelected(zoomDefault);
        this.zoomHorizontalButton.addActionListener(e -> this.handleHorizontalZoomButton());
        this.zoomVerticalButton = ImageInfoEditorSupport.createToggleButton("org/esa/snap/rcp/icons/ZoomVertical24.gif");
        this.zoomVerticalButton.setName("zoomVerticalButton");
        this.zoomVerticalButton.setToolTipText("Expand and shrink histogram vertically");
        this.zoomVerticalButton.addActionListener(e -> this.handleVerticalZoom());
        this.showExtraInfoButton = ImageInfoEditorSupport.createToggleButton("org/esa/snap/rcp/icons/Information24.gif");
        this.showExtraInfoButton.setName("ShowExtraInfoButton");
        this.showExtraInfoButton.setToolTipText("Show extra information");
        this.showExtraInfoButton.setSelected(imageInfoEditor.getShowExtraInfo());
        this.showExtraInfoButton.addActionListener(e -> imageInfoEditor.setShowExtraInfo(this.showExtraInfoButton.isSelected()));
    }

    private void resetSchemeSelector() {
        ColorSchemeInfo colorSchemeNoneInfo = ColorSchemeManager.getDefault().getNoneColorSchemeInfo();
        this.form.getFormModel().getProductSceneView().getImageInfo().setColorSchemeInfo(colorSchemeNoneInfo);
        this.form.getFormModel().getModifiedImageInfo().setColorSchemeInfo(colorSchemeNoneInfo);
    }

    public void handleVerticalZoom() {
        if (this.zoomVerticalButton.isSelected()) {
            this.imageInfoEditor.computeZoomInVertical();
        } else {
            this.imageInfoEditor.computeZoomOutVertical();
        }
    }

    public void setHorizontalZoomButtonAndCompute(boolean zoomToHistLimits) {
        if (zoomToHistLimits != this.zoomHorizontalButton.isSelected()) {
            boolean tmp = this.horizontalZoomButtonEnabled[0];
            this.horizontalZoomButtonEnabled[0] = false;
            this.zoomHorizontalButton.setSelected(zoomToHistLimits);
            this.horizontalZoomButtonEnabled[0] = tmp;
        }
        this.computeHorizontalZoom(zoomToHistLimits);
    }

    private void computeHorizontalZoom(boolean zoomToHistLimits) {
        if (zoomToHistLimits) {
            this.imageInfoEditor.computeZoomInToSliderLimits();
        } else {
            this.imageInfoEditor.computeZoomOutToFullHistogramm();
        }
    }

    public void handleHorizontalZoomButton() {
        if (this.horizontalZoomButtonEnabled[0].booleanValue()) {
            this.form.getFormModel().getProductSceneView().getImageInfo().setZoomToHistLimits(Boolean.valueOf(this.zoomHorizontalButton.isSelected()));
            this.form.getFormModel().getModifiedImageInfo().setZoomToHistLimits(Boolean.valueOf(this.zoomHorizontalButton.isSelected()));
            this.computeHorizontalZoom(this.zoomHorizontalButton.isSelected());
        }
    }

    private String getOptionsLocation() {
        String optionsLocation = "Tools/Options";
        Platform currentPlatform = Platform.getCurrentPlatform();
        if (currentPlatform != null && currentPlatform.getId() == Platform.ID.macosx) {
            optionsLocation = "App Menu/Preferences";
        }
        return optionsLocation;
    }

    private void compute1SigmaPercent() {
        this.computePercent(68.27);
    }

    private void compute2SigmaPercent() {
        this.computePercent(95.45);
    }

    private void compute3SigmaPercent() {
        this.computePercent(99.73);
    }

    private void compute95Percent() {
        this.computePercent(95.0);
    }

    private void computePercent(double threshold) {
        this.resetSchemeSelector();
        if (!this.imageInfoEditor.computePercent(this.form.getFormModel().getProductSceneView().getImageInfo().isLogScaled(), threshold)) {
            ColorUtils.showErrorDialog("INPUT ERROR!!: Cannot set slider value below zero with log scaling");
        }
    }

    private void setRGBminmax() {
        PropertyMap configuration = this.form.getFormModel().getProductSceneView().getSceneImage().getConfiguration();
        double rgbMin = configuration.getPropertyDouble("color.manipulation.rgb.options.button.min", Double.valueOf(0.0));
        double rgbMax = configuration.getPropertyDouble("color.manipulation.rgb.optionsbutton.min", Double.valueOf(1.0));
        this.imageInfoEditor.setRGBminmax(rgbMin, rgbMax);
    }

    private void compute100Percent() {
        this.resetSchemeSelector();
        if (!this.imageInfoEditor.compute100Percent(this.form.getFormModel().getProductSceneView().getImageInfo().isLogScaled())) {
            ColorUtils.showErrorDialog("INPUT ERROR!!: Cannot set slider value below zero with log scaling");
        }
    }

    public static AbstractButton createToggleButton(String s) {
        return ToolButtonFactory.createButton((Icon)ImageUtilities.loadImageIcon((String)s, (boolean)false), (boolean)true);
    }

    public static AbstractButton createButton(String s) {
        return ToolButtonFactory.createButton((Icon)ImageUtilities.loadImageIcon((String)s, (boolean)false), (boolean)false);
    }
}

