/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.ActionLabel;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.snap.core.datamodel.ColorSchemeInfo;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Scaling;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.ColorSchemeManager;
import org.esa.snap.rcp.colormanip.ColorUtils;
import org.esa.snap.ui.ImageInfoEditor;
import org.esa.snap.ui.ImageInfoEditorModel;
import org.esa.snap.ui.UIUtils;

class ImageInfoEditor2
extends ImageInfoEditor {
    private final ColorManipulationForm parentForm;
    private boolean showExtraInfo;

    ImageInfoEditor2(ColorManipulationForm parentForm) {
        this.parentForm = parentForm;
        this.setLayout(new BorderLayout());
        PropertyMap configuration = parentForm.getFormModel().getProductSceneView().getSceneImage().getConfiguration();
        boolean showExtraInformation = configuration.getPropertyBool("color.manipulation.slider.options.extra.info", Boolean.valueOf(true));
        this.setShowExtraInfo(showExtraInformation);
        this.addPropertyChangeListener("model", new ModelChangeHandler());
    }

    public boolean getShowExtraInfo() {
        return this.showExtraInfo;
    }

    public ColorManipulationForm getParentForm() {
        return this.parentForm;
    }

    public void setShowExtraInfo(boolean showExtraInfo) {
        boolean oldValue = this.showExtraInfo;
        if (oldValue != showExtraInfo) {
            this.showExtraInfo = showExtraInfo;
            this.updateStxOverlayComponent();
            this.firePropertyChange("showExtraInfo", oldValue, this.showExtraInfo);
        }
    }

    private void updateStxOverlayComponent() {
        this.removeAll();
        this.add(this.createStxOverlayComponent(), "North");
        this.revalidate();
        this.repaint();
    }

    private JPanel createStxOverlayComponent() {
        JPanel stxOverlayComponent = new JPanel(new FlowLayout(2));
        stxOverlayComponent.setOpaque(false);
        ImageInfoEditorModel model = this.getModel();
        if (!this.showExtraInfo || model == null) {
            return stxOverlayComponent;
        }
        stxOverlayComponent.setBorder(new EmptyBorder(4, 0, 0, 8));
        JComponent labels = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        labels.setBorder(new EmptyBorder(0, 2, 0, 2));
        labels.setLayout(new GridLayout(-1, 1));
        labels.setBackground(new Color(255, 255, 255, 127));
        stxOverlayComponent.add(labels);
        labels.add(new JLabel("Name: " + model.getParameterName()));
        labels.add(new JLabel("Unit: " + model.getParameterUnit()));
        Stx stx = model.getSampleStx();
        if (stx == null) {
            return stxOverlayComponent;
        }
        labels.add(new JLabel("Min: " + this.getValueForDisplay(model.getMinSample())));
        labels.add(new JLabel("Max: " + this.getValueForDisplay(model.getMaxSample())));
        if (stx.getResolutionLevel() > 0 && model.getSampleScaling() == Scaling.IDENTITY) {
            ActionLabel label = new ActionLabel("Rough statistics!");
            label.setToolTipText("Click to compute accurate statistics.");
            label.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageInfoEditor2.this.askUser();
                }
            });
            labels.add((Component)label);
        }
        return stxOverlayComponent;
    }

    private String getValueForDisplay(double value) {
        if (!Double.isNaN(value)) {
            if (value < 0.001 && value > -0.001 && value != 0.0) {
                return new DecimalFormat("0.##E0").format(value);
            }
            value = MathUtils.round((double)value, (double)1000.0);
        }
        return "" + value;
    }

    void askUser() {
        int i = JOptionPane.showConfirmDialog((Component)((Object)this), "Compute accurate statistics?\nNote that this action may take some time.", "Question", 0);
        if (i == 0) {
            StxComputer sw = new StxComputer();
            ((SwingWorker)((Object)sw)).execute();
        }
    }

    public void updateShowExtraInformationFromPreferences() {
        PropertyMap configuration = this.parentForm.getFormModel().getProductSceneView().getSceneImage().getConfiguration();
        boolean showExtraInformation = configuration.getPropertyBool("color.manipulation.slider.options.extra.info", Boolean.valueOf(true));
        this.setShowExtraInfo(showExtraInformation);
    }

    protected void applyChanges() {
        this.resetColorSchemeSelector();
        this.updateShowExtraInformationFromPreferences();
        this.parentForm.applyChanges();
    }

    protected boolean checkLogCompatibility(double value, String componentName, boolean isLogScaled) {
        return ColorUtils.checkLogCompatibility(value, componentName, isLogScaled);
    }

    protected boolean checkSliderRangeCompatibility(double value, double min, double max) {
        return ColorUtils.checkSliderRangeCompatibility(value, min, max);
    }

    private void resetColorSchemeSelector() {
        ColorSchemeInfo colorSchemeNoneInfo = ColorSchemeManager.getDefault().getNoneColorSchemeInfo();
        this.parentForm.getFormModel().getProductSceneView().getImageInfo().setColorSchemeInfo(colorSchemeNoneInfo);
        this.parentForm.getFormModel().getModifiedImageInfo().setColorSchemeInfo(colorSchemeNoneInfo);
    }

    private class StxComputer
    extends ProgressMonitorSwingWorker {
        private StxComputer() {
            super((Component)((Object)ImageInfoEditor2.this), "Computing statistics");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground(ProgressMonitor pm) throws Exception {
            UIUtils.setRootFrameWaitCursor((Component)((Object)ImageInfoEditor2.this));
            if (ImageInfoEditor2.this.parentForm.getFormModel().isValid()) {
                RasterDataNode[] rasters = ImageInfoEditor2.this.parentForm.getFormModel().getRasters();
                try {
                    pm.beginTask("Computing statistics", rasters.length);
                    for (RasterDataNode raster : rasters) {
                        raster.getStx(true, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                    }
                }
                finally {
                    pm.done();
                }
            }
            return null;
        }

        protected void done() {
            UIUtils.setRootFrameDefaultCursor((Component)((Object)ImageInfoEditor2.this));
        }
    }

    private class ModelChangeHandler
    implements PropertyChangeListener,
    ChangeListener {
        private ModelChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ImageInfoEditor2.this.updateStxOverlayComponent();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"model".equals(evt.getPropertyName())) {
                return;
            }
            ImageInfoEditorModel oldModel = (ImageInfoEditorModel)evt.getOldValue();
            ImageInfoEditorModel newModel = (ImageInfoEditorModel)evt.getNewValue();
            if (oldModel != null) {
                oldModel.removeChangeListener((ChangeListener)this);
            }
            if (newModel != null) {
                newModel.addChangeListener((ChangeListener)this);
            }
            ImageInfoEditor2.this.updateStxOverlayComponent();
        }
    }
}

