/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import com.bc.ceres.core.Assert;
import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.rcp.colormanip.ColorFormModel;
import org.esa.snap.rcp.colormanip.ColorManipulationChildForm;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.MoreOptionsForm;
import org.esa.snap.ui.color.ColorTableCellEditor;
import org.esa.snap.ui.color.ColorTableCellRenderer;

public class Discrete1BandTabularForm
implements ColorManipulationChildForm {
    private static final String[] COLUMN_NAMES = new String[]{"Label", "Colour", "Value", "Frequency", "Description"};
    private static final Class<?>[] COLUMN_TYPES = new Class[]{String.class, Color.class, String.class, Double.class, String.class};
    private final ColorManipulationForm parentForm;
    private JComponent contentPanel;
    private ImageInfoTableModel tableModel;
    private MoreOptionsForm moreOptionsForm;

    public Discrete1BandTabularForm(ColorManipulationForm parentForm) {
        this.parentForm = parentForm;
        this.tableModel = new ImageInfoTableModel();
        this.moreOptionsForm = new MoreOptionsForm(this, false);
        JTable table = new JTable(this.tableModel);
        table.setRowSorter(new TableRowSorter<ImageInfoTableModel>(this.tableModel));
        table.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorTableCellRenderer());
        table.setDefaultEditor(Color.class, (TableCellEditor)new ColorTableCellEditor());
        table.getTableHeader().setReorderingAllowed(false);
        table.getColumnModel().getColumn(1).setPreferredWidth(140);
        table.getColumnModel().getColumn(3).setCellRenderer(new PercentageRenderer());
        table.setAutoResizeMode(0);
        JScrollPane tableScrollPane = new JScrollPane(table);
        tableScrollPane.getViewport().setPreferredSize(table.getPreferredSize());
        this.contentPanel = tableScrollPane;
    }

    @Override
    public ColorManipulationForm getParentForm() {
        return this.parentForm;
    }

    @Override
    public void handleFormShown(ColorFormModel formModel) {
        this.updateFormModel(formModel);
    }

    @Override
    public void handleFormHidden(ColorFormModel formModel) {
    }

    @Override
    public void updateFormModel(ColorFormModel formModel) {
        this.parentForm.getStx(formModel.getRaster());
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public void resetFormModel(ColorFormModel formModel) {
        this.updateFormModel(formModel);
    }

    @Override
    public void handleRasterPropertyChange(ProductNodeEvent event, RasterDataNode raster) {
    }

    @Override
    public AbstractButton[] getToolButtons() {
        return new AbstractButton[0];
    }

    @Override
    public Component getContentPanel() {
        return this.contentPanel;
    }

    @Override
    public RasterDataNode[] getRasters() {
        return this.parentForm.getFormModel().getRasters();
    }

    @Override
    public MoreOptionsForm getMoreOptionsForm() {
        return this.moreOptionsForm;
    }

    private class ImageInfoTableModel
    extends AbstractTableModel {
        private ImageInfoTableModel() {
        }

        public ImageInfo getImageInfo() {
            return Discrete1BandTabularForm.this.parentForm.getFormModel().getModifiedImageInfo();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return COLUMN_TYPES[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public int getRowCount() {
            if (this.getImageInfo() == null) {
                return 0;
            }
            return this.getImageInfo().getColorPaletteDef().getNumPoints();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.getImageInfo() == null) {
                return null;
            }
            ColorPaletteDef.Point point = this.getImageInfo().getColorPaletteDef().getPointAt(rowIndex);
            if (columnIndex == 0) {
                return point.getLabel();
            }
            if (columnIndex == 1) {
                Color color = point.getColor();
                return color.equals(ImageInfo.NO_COLOR) ? null : color;
            }
            if (columnIndex == 2) {
                return Double.isNaN(point.getSample()) ? "Uncoded" : Integer.valueOf((int)point.getSample());
            }
            if (columnIndex == 3) {
                String[] indexNames;
                Band band;
                IndexCoding indexCoding;
                RasterDataNode raster = Discrete1BandTabularForm.this.parentForm.getFormModel().getRaster();
                Stx stx = raster.getStx();
                Assert.notNull((Object)stx, (String)"stx");
                int[] frequencies = stx.getHistogramBins();
                Assert.notNull((Object)frequencies, (String)"frequencies");
                if (raster instanceof Band && (indexCoding = (band = (Band)raster).getIndexCoding()) != null && rowIndex < (indexNames = indexCoding.getIndexNames()).length) {
                    int indexValue = indexCoding.getAttributeIndex(indexCoding.getIndex(indexNames[rowIndex]));
                    double frequency = frequencies[indexValue];
                    return frequency / (double)stx.getSampleCount();
                }
                return 0.0;
            }
            if (columnIndex == 4) {
                Band band;
                IndexCoding indexCoding;
                RasterDataNode raster = Discrete1BandTabularForm.this.parentForm.getFormModel().getRaster();
                if (raster instanceof Band && (indexCoding = (band = (Band)raster).getIndexCoding()) != null && rowIndex < indexCoding.getSampleCount()) {
                    String text = indexCoding.getAttributeAt(rowIndex).getDescription();
                    return text != null ? text : "";
                }
                return "";
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (this.getImageInfo() == null) {
                return;
            }
            ColorPaletteDef.Point point = this.getImageInfo().getColorPaletteDef().getPointAt(rowIndex);
            if (columnIndex == 0) {
                point.setLabel((String)aValue);
                this.fireTableCellUpdated(rowIndex, columnIndex);
                Discrete1BandTabularForm.this.parentForm.applyChanges();
            } else if (columnIndex == 1) {
                Color color = (Color)aValue;
                point.setColor(color == null ? ImageInfo.NO_COLOR : color);
                this.fireTableCellUpdated(rowIndex, columnIndex);
                Discrete1BandTabularForm.this.parentForm.applyChanges();
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 || columnIndex == 1;
        }
    }

    private static class PercentageRenderer
    extends DefaultTableCellRenderer {
        private final NumberFormat formatter;

        public PercentageRenderer() {
            this.setHorizontalAlignment(4);
            this.formatter = NumberFormat.getPercentInstance();
            this.formatter.setMinimumFractionDigits(3);
            this.formatter.setMaximumFractionDigits(3);
        }

        @Override
        public void setValue(Object value) {
            this.setText(this.formatter.format(value));
        }
    }
}

