/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.colormanip.ColorFormModel;
import org.esa.snap.rcp.colormanip.ColorManipulationChildForm;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.Continuous1BandBasicForm;
import org.esa.snap.rcp.colormanip.Continuous1BandGraphicalForm;
import org.esa.snap.rcp.colormanip.Continuous1BandTabularForm;
import org.esa.snap.rcp.colormanip.Continuous3BandGraphicalForm;
import org.esa.snap.rcp.colormanip.EmptyImageInfoForm;
import org.esa.snap.rcp.colormanip.MoreOptionsForm;

public class Continuous1BandSwitcherForm
implements ColorManipulationChildForm {
    private final ColorManipulationForm parentForm;
    private JPanel contentPanel;
    private ColorManipulationChildForm childForm;
    private JRadioButton graphicalButton;
    private Continuous1BandGraphicalForm graphicalPaletteEditorForm;
    private JRadioButton tabularButton;
    private Continuous1BandTabularForm tabularPaletteEditorForm;
    private JRadioButton basicButton;
    private Continuous1BandBasicForm basicPaletteEditorForm;
    public Boolean[] basicSwitcherIsActive = new Boolean[]{false};

    public Continuous1BandSwitcherForm(ColorManipulationForm parentForm) {
        this.parentForm = parentForm;
        this.childForm = new EmptyImageInfoForm(parentForm);
        this.basicButton = new JRadioButton("Basic");
        this.graphicalButton = new JRadioButton("Sliders");
        this.tabularButton = new JRadioButton("Table");
        ButtonGroup editorGroup = new ButtonGroup();
        editorGroup.add(this.basicButton);
        editorGroup.add(this.graphicalButton);
        editorGroup.add(this.tabularButton);
        this.basicButton.setSelected(true);
        SwitcherActionListener switcherActionListener = new SwitcherActionListener();
        this.basicButton.addActionListener(switcherActionListener);
        this.graphicalButton.addActionListener(switcherActionListener);
        this.tabularButton.addActionListener(switcherActionListener);
        JPanel editorSwitcherPanel = new JPanel(new FlowLayout(0, 2, 2));
        editorSwitcherPanel.add(new JLabel("Editor:"));
        editorSwitcherPanel.add(this.basicButton);
        editorSwitcherPanel.add(this.graphicalButton);
        editorSwitcherPanel.add(this.tabularButton);
        JPanel northPanel = new JPanel(new BorderLayout(2, 2));
        northPanel.add((Component)editorSwitcherPanel, "West");
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.add((Component)northPanel, "North");
    }

    @Override
    public ColorManipulationForm getParentForm() {
        return this.parentForm;
    }

    @Override
    public void handleFormShown(ColorFormModel formModel) {
        this.switchForm();
    }

    @Override
    public void handleFormHidden(ColorFormModel formModel) {
        this.childForm.handleFormHidden(formModel);
    }

    @Override
    public void updateFormModel(ColorFormModel formModel) {
        this.childForm.updateFormModel(formModel);
    }

    @Override
    public void resetFormModel(ColorFormModel formModel) {
        this.childForm.resetFormModel(formModel);
    }

    @Override
    public void handleRasterPropertyChange(ProductNodeEvent event, RasterDataNode raster) {
        this.childForm.handleRasterPropertyChange(event, raster);
    }

    @Override
    public MoreOptionsForm getMoreOptionsForm() {
        return this.childForm.getMoreOptionsForm();
    }

    @Override
    public RasterDataNode[] getRasters() {
        return this.childForm.getRasters();
    }

    private void switchForm() {
        ColorManipulationChildForm newForm;
        ColorManipulationChildForm oldForm = this.childForm;
        if (this.tabularButton.isSelected()) {
            if (this.tabularPaletteEditorForm == null) {
                this.tabularPaletteEditorForm = new Continuous1BandTabularForm(this.parentForm);
            }
            newForm = this.tabularPaletteEditorForm;
        } else if (this.basicButton.isSelected()) {
            if (this.basicPaletteEditorForm == null) {
                this.basicPaletteEditorForm = new Continuous1BandBasicForm(this.parentForm, this.basicSwitcherIsActive);
            }
            newForm = this.basicPaletteEditorForm;
        } else {
            if (this.graphicalPaletteEditorForm == null) {
                this.graphicalPaletteEditorForm = new Continuous1BandGraphicalForm(this.parentForm);
            }
            newForm = this.graphicalPaletteEditorForm;
        }
        if (oldForm != newForm) {
            oldForm.handleFormHidden(this.parentForm.getFormModel());
            this.childForm = newForm;
            this.childForm.handleFormShown(this.parentForm.getFormModel());
            this.contentPanel.remove(oldForm.getContentPanel());
            this.contentPanel.add(this.childForm.getContentPanel(), "Center");
            boolean installAllButtons = !(newForm instanceof Continuous1BandGraphicalForm) && !(newForm instanceof Continuous3BandGraphicalForm);
            this.parentForm.installToolButtons(installAllButtons);
            this.parentForm.installMoreOptions();
            this.parentForm.revalidateToolViewPaneControl();
        } else {
            this.childForm.updateFormModel(this.parentForm.getFormModel());
        }
    }

    @Override
    public AbstractButton[] getToolButtons() {
        return this.childForm.getToolButtons();
    }

    @Override
    public Component getContentPanel() {
        return this.contentPanel;
    }

    private class SwitcherActionListener
    implements ActionListener {
        private SwitcherActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Continuous1BandSwitcherForm.this.basicSwitcherIsActive[0] = true;
            Continuous1BandSwitcherForm.this.switchForm();
            Continuous1BandSwitcherForm.this.basicSwitcherIsActive[0] = false;
        }
    }
}

