/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ColorSchemeInfo;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Scaling;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.StxFactory;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.rcp.colormanip.ColorFormModel;
import org.esa.snap.rcp.colormanip.ColorManipulationChildForm;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.ColorSchemeManager;
import org.esa.snap.rcp.colormanip.ColorUtils;
import org.esa.snap.rcp.colormanip.DiscreteCheckBox;
import org.esa.snap.rcp.colormanip.ImageInfoEditor2;
import org.esa.snap.rcp.colormanip.ImageInfoEditorModel1B;
import org.esa.snap.rcp.colormanip.ImageInfoEditorSupport;
import org.esa.snap.rcp.colormanip.LogDisplay;
import org.esa.snap.rcp.colormanip.MoreOptionsForm;
import org.esa.snap.ui.ImageInfoEditorModel;

public class Continuous1BandGraphicalForm
implements ColorManipulationChildForm {
    public static final Scaling POW10_SCALING = new Pow10Scaling();
    private final ColorManipulationForm parentForm;
    private final ImageInfoEditor2 imageInfoEditor;
    private final ImageInfoEditorSupport imageInfoEditorSupport;
    private final JPanel contentPanel;
    private final AbstractButton logDisplayButton;
    private final AbstractButton evenDistButton;
    private final MoreOptionsForm moreOptionsForm;
    private final DiscreteCheckBox discreteCheckBox;
    final Boolean[] listenToLogDisplayButtonEnabled = new Boolean[]{true};
    private boolean zoomToHistLimits;
    private ProductNode currProductNode;

    Continuous1BandGraphicalForm(ColorManipulationForm parentForm) {
        this.parentForm = parentForm;
        this.currProductNode = parentForm.getFormModel().getProductSceneView().getProductNode();
        PropertyMap configuration = parentForm.getFormModel().getProductSceneView().getSceneImage().getConfiguration();
        this.zoomToHistLimits = configuration.getPropertyBool("color.manipulation.slider.options.zoom.in", Boolean.valueOf(true));
        parentForm.getFormModel().getProductSceneView().getImageInfo().setZoomToHistLimits(Boolean.valueOf(this.zoomToHistLimits));
        parentForm.getFormModel().getModifiedImageInfo().setZoomToHistLimits(Boolean.valueOf(this.zoomToHistLimits));
        this.imageInfoEditor = new ImageInfoEditor2(parentForm);
        this.imageInfoEditorSupport = new ImageInfoEditorSupport(this.imageInfoEditor, this.zoomToHistLimits);
        this.contentPanel = new JPanel(new BorderLayout(2, 2));
        this.contentPanel.add((Component)((Object)this.imageInfoEditor), "Center");
        this.moreOptionsForm = new MoreOptionsForm(this, parentForm.getFormModel().canUseHistogramMatching());
        this.discreteCheckBox = new DiscreteCheckBox(parentForm);
        this.moreOptionsForm.addRow(this.discreteCheckBox);
        parentForm.getFormModel().modifyMoreOptionsForm(this.moreOptionsForm);
        this.logDisplayButton = LogDisplay.createButton();
        this.logDisplayButton.addActionListener(e -> {
            if (this.listenToLogDisplayButtonEnabled[0].booleanValue()) {
                this.listenToLogDisplayButtonEnabled[0] = false;
                this.logDisplayButton.setSelected(!this.logDisplayButton.isSelected());
                this.applyChangesLogToggle();
                this.listenToLogDisplayButtonEnabled[0] = true;
            }
        });
        this.evenDistButton = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/EvenDistribution24.gif");
        this.evenDistButton.setName("evenDistButton");
        this.evenDistButton.setToolTipText("Distribute sliders evenly between first and last slider");
        this.evenDistButton.addActionListener(parentForm.wrapWithAutoApplyActionListener(e -> this.distributeSlidersEvenly()));
    }

    @Override
    public Component getContentPanel() {
        return this.contentPanel;
    }

    @Override
    public ColorManipulationForm getParentForm() {
        return this.parentForm;
    }

    @Override
    public void handleFormShown(ColorFormModel formModel) {
        this.updateFormModel(formModel);
    }

    @Override
    public void handleFormHidden(ColorFormModel formModel) {
        if (this.imageInfoEditor.getModel() != null) {
            this.imageInfoEditor.setModel(null);
        }
    }

    @Override
    public void updateFormModel(ColorFormModel formModel) {
        ImageInfoEditorModel oldModel = this.imageInfoEditor.getModel();
        ImageInfo imageInfo = this.parentForm.getFormModel().getModifiedImageInfo();
        ImageInfoEditorModel1B newModel = new ImageInfoEditorModel1B(imageInfo);
        this.imageInfoEditor.setModel((ImageInfoEditorModel)newModel);
        RasterDataNode raster = formModel.getRaster();
        this.setLogarithmicDisplay(raster, newModel.getImageInfo().isLogScaled());
        if (oldModel != null) {
            newModel.setHistogramViewGain(oldModel.getHistogramViewGain());
            newModel.setMinHistogramViewSample(oldModel.getMinHistogramViewSample());
            newModel.setMaxHistogramViewSample(oldModel.getMaxHistogramViewSample());
        }
        if (this.parentForm.getFormModel().getProductSceneView().getImageInfo().getZoomToHistLimits() == null) {
            PropertyMap configuration = this.parentForm.getFormModel().getProductSceneView().getSceneImage().getConfiguration();
            this.zoomToHistLimits = configuration.getPropertyBool("color.manipulation.slider.options.zoom.in", Boolean.valueOf(true));
            this.parentForm.getFormModel().getProductSceneView().getImageInfo().setZoomToHistLimits(Boolean.valueOf(this.zoomToHistLimits));
            this.parentForm.getFormModel().getModifiedImageInfo().setZoomToHistLimits(Boolean.valueOf(this.zoomToHistLimits));
        } else {
            this.zoomToHistLimits = this.parentForm.getFormModel().getProductSceneView().getImageInfo().getZoomToHistLimits();
        }
        this.imageInfoEditorSupport.setHorizontalZoomButtonAndCompute(this.zoomToHistLimits);
        this.imageInfoEditor.updateShowExtraInformationFromPreferences();
        this.discreteCheckBox.setDiscreteColorsMode(imageInfo.getColorPaletteDef().isDiscrete());
        this.logDisplayButton.setSelected(newModel.getImageInfo().isLogScaled());
        this.imageInfoEditor.setLogScaled(newModel.getImageInfo().isLogScaled());
        this.parentForm.revalidateToolViewPaneControl();
    }

    @Override
    public void resetFormModel(ColorFormModel formModel) {
        this.updateFormModel(formModel);
        this.parentForm.revalidateToolViewPaneControl();
    }

    @Override
    public void handleRasterPropertyChange(ProductNodeEvent event, RasterDataNode raster) {
        ImageInfoEditorModel model = this.imageInfoEditor.getModel();
        if (model != null) {
            if (event.getPropertyName().equals("stx")) {
                this.updateFormModel(this.parentForm.getFormModel());
            } else {
                this.setLogarithmicDisplay(raster, model.getImageInfo().isLogScaled());
            }
        }
    }

    @Override
    public RasterDataNode[] getRasters() {
        return this.parentForm.getFormModel().getRasters();
    }

    @Override
    public MoreOptionsForm getMoreOptionsForm() {
        return this.moreOptionsForm;
    }

    private void setLogarithmicDisplay(RasterDataNode raster, boolean logarithmicDisplay) {
        ImageInfoEditorModel model = this.imageInfoEditor.getModel();
        if (logarithmicDisplay) {
            StxFactory stxFactory = new StxFactory();
            Stx stx = stxFactory.withHistogramBinCount(Integer.valueOf(raster.getStx().getHistogramBinCount())).withLogHistogram(logarithmicDisplay).withResolutionLevel(Integer.valueOf(raster.getSourceImage().getModel().getLevelCount() - 1)).create(raster, ProgressMonitor.NULL);
            model.setDisplayProperties(raster.getName(), raster.getUnit(), stx, POW10_SCALING);
        } else {
            model.setDisplayProperties(raster.getName(), raster.getUnit(), raster.getStx(), Scaling.IDENTITY);
        }
        model.getImageInfo().setLogScaled(logarithmicDisplay);
    }

    private void distributeSlidersEvenly() {
        this.resetSchemeSelector();
        this.imageInfoEditor.distributeSlidersEvenly();
    }

    private void resetSchemeSelector() {
        ColorSchemeInfo colorSchemeNoneInfo = ColorSchemeManager.getDefault().getNoneColorSchemeInfo();
        this.parentForm.getFormModel().getProductSceneView().getImageInfo().setColorSchemeInfo(colorSchemeNoneInfo);
        this.parentForm.getFormModel().getModifiedImageInfo().setColorSchemeInfo(colorSchemeNoneInfo);
    }

    @Override
    public AbstractButton[] getToolButtons() {
        PropertyMap configuration = this.parentForm.getFormModel().getProductSceneView().getSceneImage().getConfiguration();
        boolean range100 = configuration.getPropertyBool("color.manipulation.button.enablement.100.button", Boolean.valueOf(true));
        boolean range95 = configuration.getPropertyBool("color.manipulation.button.enablement.95.button", Boolean.valueOf(false));
        boolean range1Sigma = configuration.getPropertyBool("color.manipulation.button.enablement.1.sigma.button", Boolean.valueOf(false));
        boolean range2Sigma = configuration.getPropertyBool("color.manipulation.button.enablement.2.sigma.button", Boolean.valueOf(true));
        boolean range3Sigma = configuration.getPropertyBool("color.manipulation.button.enablement.3.sigma.button", Boolean.valueOf(true));
        boolean showZoomVerticalButtons = configuration.getPropertyBool("color.manipulation.button.enablement.zoom.vertical.buttons", Boolean.valueOf(true));
        boolean showExtraInformationButtons = configuration.getPropertyBool("color.manipulation.button.enablement.extra.info.button", Boolean.valueOf(true));
        ArrayList<AbstractButton> abstractButtonArrayList = new ArrayList<AbstractButton>();
        abstractButtonArrayList.add(this.logDisplayButton);
        if (range1Sigma) {
            abstractButtonArrayList.add(this.imageInfoEditorSupport.autoStretch1SigmaButton);
        }
        if (range2Sigma) {
            abstractButtonArrayList.add(this.imageInfoEditorSupport.autoStretch2SigmaButton);
        }
        if (range3Sigma) {
            abstractButtonArrayList.add(this.imageInfoEditorSupport.autoStretch3SigmaButton);
        }
        if (range95) {
            abstractButtonArrayList.add(this.imageInfoEditorSupport.autoStretch95Button);
        }
        if (range100) {
            abstractButtonArrayList.add(this.imageInfoEditorSupport.autoStretch100Button);
        }
        abstractButtonArrayList.add(this.evenDistButton);
        if (showZoomVerticalButtons) {
            abstractButtonArrayList.add(this.imageInfoEditorSupport.zoomInVButton);
            abstractButtonArrayList.add(this.imageInfoEditorSupport.zoomOutVButton);
        }
        abstractButtonArrayList.add(this.imageInfoEditorSupport.zoomHorizontalButton);
        if (showExtraInformationButtons) {
            abstractButtonArrayList.add(this.imageInfoEditorSupport.showExtraInfoButton);
        }
        AbstractButton[] abstractButtonArray = new AbstractButton[abstractButtonArrayList.size()];
        int i = 0;
        Iterator iterator = abstractButtonArrayList.iterator();
        while (iterator.hasNext()) {
            AbstractButton abstractButton;
            abstractButtonArray[i] = abstractButton = (AbstractButton)iterator.next();
            ++i;
        }
        return abstractButtonArray;
    }

    static void setDisplayProperties(ImageInfoEditorModel model, RasterDataNode raster) {
        model.setDisplayProperties(raster.getName(), raster.getUnit(), raster.getStx(), raster.isLog10Scaled() ? POW10_SCALING : Scaling.IDENTITY);
    }

    private void applyChangesLogToggle() {
        ImageInfo currentInfo = this.parentForm.getFormModel().getModifiedImageInfo();
        ColorPaletteDef currentCPD = currentInfo.getColorPaletteDef();
        boolean isSourceLogScaled = currentInfo.isLogScaled();
        boolean isTargetLogScaled = !currentInfo.isLogScaled();
        double min = currentCPD.getMinDisplaySample();
        double max = currentCPD.getMaxDisplaySample();
        ColorPaletteDef cpd = currentCPD;
        boolean autoDistribute = true;
        if (ColorUtils.checkRangeCompatibility(min, max, isTargetLogScaled)) {
            this.resetSchemeSelector();
            currentInfo.setColorPaletteDef(cpd, min, max, autoDistribute, isSourceLogScaled, isTargetLogScaled);
            currentInfo.setLogScaled(isTargetLogScaled);
            this.imageInfoEditor.setLogScaled(currentInfo.isLogScaled());
            this.parentForm.applyChanges();
        }
    }

    private static class Pow10Scaling
    implements Scaling {
        private final Scaling log10Scaling = new Log10Scaling();

        private Pow10Scaling() {
        }

        public double scale(double value) {
            return this.log10Scaling.scaleInverse(value);
        }

        public double scaleInverse(double value) {
            return this.log10Scaling.scale(value);
        }
    }

    private static class Log10Scaling
    implements Scaling {
        private Log10Scaling() {
        }

        public final double scale(double value) {
            return value > 1.0E-9 ? Math.log10(value) : -9.0;
        }

        public final double scaleInverse(double value) {
            return value < -9.0 ? 1.0E-9 : Math.pow(10.0, value);
        }
    }
}

