/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.runtime.internal.Platform;
import com.bc.ceres.swing.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.NumberFormatter;
import org.esa.snap.core.datamodel.ColorManipulationDefaults;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ColorSchemeInfo;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.math.Histogram;
import org.esa.snap.core.util.math.Range;
import org.esa.snap.rcp.colormanip.ColorFormModel;
import org.esa.snap.rcp.colormanip.ColorManipulationChildForm;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.ColorPaletteChooser;
import org.esa.snap.rcp.colormanip.ColorPaletteManager;
import org.esa.snap.rcp.colormanip.ColorSchemeManager;
import org.esa.snap.rcp.colormanip.ColorSchemeUtils;
import org.esa.snap.rcp.colormanip.ColorUtils;
import org.esa.snap.rcp.colormanip.DiscreteCheckBox;
import org.esa.snap.rcp.colormanip.LogDisplay;
import org.esa.snap.rcp.colormanip.MoreOptionsForm;

public class Continuous1BandBasicForm
implements ColorManipulationChildForm {
    private final ColorManipulationForm parentForm;
    private final JPanel contentPanel;
    private final AbstractButton logDisplayButton;
    private final JLabel schemeInfoLabel;
    private final MoreOptionsForm moreOptionsForm;
    private final ColorPaletteChooser colorPaletteChooser;
    private final JFormattedTextField minField;
    private final JFormattedTextField maxField;
    private final JButton fromFile;
    private final JButton fromData;
    private final DiscreteCheckBox discreteCheckBox;
    private final JCheckBox loadWithCPDFileValuesCheckBox;
    private final ColorSchemeManager colorSchemeManager;
    private final JLabel colorSchemeJLabel;
    private final JButton paletteInversionButton;
    final Boolean[] minTextFieldListenerEnabled = new Boolean[]{Boolean.TRUE};
    final Boolean[] maxTextFieldListenerEnabled = new Boolean[]{Boolean.TRUE};
    final Boolean[] logButtonListenerEnabled = new Boolean[]{true};
    final Boolean[] basicSwitcherIsActive;
    PropertyMap configuration = null;
    private boolean shouldFireChooserEvent;
    private boolean hidden = false;

    Continuous1BandBasicForm(ColorManipulationForm parentForm, Boolean[] basicSwitcherIsActive) {
        ColorPaletteManager.getDefault().loadAvailableColorPalettes(parentForm.getIODir().toFile());
        this.parentForm = parentForm;
        this.basicSwitcherIsActive = basicSwitcherIsActive;
        if (parentForm.getFormModel().getProductSceneView() != null && parentForm.getFormModel().getProductSceneView().getSceneImage() != null) {
            this.configuration = parentForm.getFormModel().getProductSceneView().getSceneImage().getConfiguration();
        }
        this.colorSchemeJLabel = new JLabel("");
        this.schemeInfoLabel = new JLabel("");
        this.colorSchemeManager = ColorSchemeManager.getDefault();
        this.loadWithCPDFileValuesCheckBox = new JCheckBox("Load exact values", false);
        this.loadWithCPDFileValuesCheckBox.setToolTipText("When loading a new cpd file, use its actual values and overwrite user min/max values");
        this.paletteInversionButton = new JButton("Reverse");
        this.paletteInversionButton.setToolTipText("Reverse (invert) palette");
        this.paletteInversionButton.addActionListener(e -> this.applyChanges(RangeKey.InvertPalette));
        this.paletteInversionButton.setEnabled(true);
        this.paletteInversionButton.setFocusable(false);
        this.colorPaletteChooser = new ColorPaletteChooser();
        this.colorPaletteChooser.setFocusable(false);
        this.minField = this.getNumberTextField(1.0E-7);
        this.maxField = this.getNumberTextField(1.0000001);
        this.fromFile = new JButton("From Palette");
        this.fromData = new JButton("From Data");
        TableLayout layout = new TableLayout();
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setTableWeightY(Double.valueOf(1.0));
        layout.setTablePadding(2, 2);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableAnchor(TableLayout.Anchor.NORTH);
        layout.setCellPadding(0, 0, new Insets(8, 2, 2, 2));
        layout.setCellPadding(1, 0, new Insets(8, 2, 2, 2));
        layout.setCellPadding(2, 0, new Insets(8, 2, 2, 2));
        layout.setCellPadding(3, 0, new Insets(13, 2, 5, 2));
        JPanel editorPanel = new JPanel((LayoutManager)layout);
        JPanel schemePanel = this.getSchemePanel("Scheme");
        editorPanel.add(schemePanel);
        JPanel palettePanel = this.getPalettePanel("Palette");
        editorPanel.add(palettePanel);
        JPanel rangePanel = this.getRangePanel("Range");
        editorPanel.add(rangePanel);
        this.shouldFireChooserEvent = false;
        this.colorPaletteChooser.addActionListener(this.createListener(RangeKey.FromPaletteChooser));
        this.minField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ColorManipulationDefaults.debug((String)"minField: FocusListener: focusGained");
            }

            @Override
            public void focusLost(FocusEvent e) {
                ColorManipulationDefaults.debug((String)"minField: FocusListener: focusLost");
                Continuous1BandBasicForm.this.handleMinTextfield();
            }
        });
        this.minField.addActionListener(e -> {
            ColorManipulationDefaults.debug((String)"minField: ActionListener: actionPerformed");
            this.handleMinTextfield();
        });
        this.maxField.addActionListener(e -> {
            ColorManipulationDefaults.debug((String)"maxField: ActionListener: actionPerformed");
            this.handleMaxTextfield();
        });
        this.maxField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ColorManipulationDefaults.debug((String)"maxField: FocusListener: focusGained");
            }

            @Override
            public void focusLost(FocusEvent e) {
                ColorManipulationDefaults.debug((String)"maxField: FocusListener: focusLost");
                Continuous1BandBasicForm.this.handleMaxTextfield();
            }
        });
        this.fromFile.addActionListener(e -> {
            ColorManipulationDefaults.debug((String)"Inside fromFile.addActionListener");
            if (this.shouldFireChooserEvent) {
                ColorManipulationDefaults.debug((String)"Inside fromFile.addActionListener 2");
                this.applyChanges(RangeKey.FromCpdFile);
            }
        });
        this.fromData.addActionListener(e -> {
            ColorManipulationDefaults.debug((String)"Inside fromData.addActionListener");
            if (this.shouldFireChooserEvent) {
                ColorManipulationDefaults.debug((String)"Inside fromData.addActionListener 2");
                this.applyChanges(RangeKey.FromData);
            }
        });
        this.fromData.setFocusable(false);
        this.fromFile.setFocusable(false);
        this.fromData.setToolTipText("Set range from data");
        this.fromFile.setToolTipText("Set range from palette file");
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.add((Component)editorPanel, "North");
        this.moreOptionsForm = new MoreOptionsForm(this, parentForm.getFormModel().canUseHistogramMatching());
        this.discreteCheckBox = new DiscreteCheckBox(parentForm);
        this.moreOptionsForm.addRow(this.discreteCheckBox);
        parentForm.getFormModel().modifyMoreOptionsForm(this.moreOptionsForm);
        this.logDisplayButton = LogDisplay.createButton();
        this.logDisplayButton.addActionListener(e -> {
            if (this.shouldFireChooserEvent && this.logButtonListenerEnabled[0].booleanValue()) {
                this.logButtonListenerEnabled[0] = false;
                this.applyChanges(RangeKey.FromLogButton);
                this.logButtonListenerEnabled[0] = true;
            }
        });
        this.colorSchemeManager.getjComboBox().addActionListener(e -> {
            if (this.colorSchemeManager.isjComboBoxShouldFire()) {
                this.colorSchemeManager.setjComboBoxShouldFire(false);
                ColorManipulationDefaults.debug((String)"Inside standardColorPaletteSchemes listener");
                this.handleColorSchemeSelector();
                this.colorSchemeManager.setjComboBoxShouldFire(true);
            }
        });
        this.shouldFireChooserEvent = true;
    }

    private boolean testMinMaxAgainstCurrentLog(double min, double max) {
        boolean valid = true;
        ImageInfo currentInfo = this.parentForm.getFormModel().getModifiedImageInfo();
        boolean logScaled = currentInfo.isLogScaled();
        if (logScaled && min <= 0.0) {
            valid = false;
            ColorUtils.showErrorDialog("ERROR!: Colour Manipulation: \nMin field cannot be set to less than or equal to zero with log scaling\"");
        } else if (logScaled && max <= 0.0) {
            valid = false;
            ColorUtils.showErrorDialog("ERROR!: Colour Manipulation: \nMax field cannot be set to less than or equal to zero with log scaling\"");
        }
        return valid;
    }

    private void handleMaxTextfield() {
        this.setComponentsActive(false);
        if (this.maxTextFieldListenerEnabled[0].booleanValue() && !this.basicSwitcherIsActive[0].booleanValue()) {
            this.maxTextFieldListenerEnabled[0] = false;
            this.applyChanges(RangeKey.FromMaxField);
            this.maxTextFieldListenerEnabled[0] = true;
        }
        ImageInfo currentInfo = this.parentForm.getFormModel().getModifiedImageInfo();
        this.maxField.setValue(currentInfo.getColorPaletteDef().getMaxDisplaySample());
        this.setComponentsActive(true);
    }

    private void handleMinTextfield() {
        ColorManipulationDefaults.debug((String)"Inside handleMinTextfield 0");
        this.setComponentsActive(false);
        if (this.minTextFieldListenerEnabled[0].booleanValue() && !this.basicSwitcherIsActive[0].booleanValue()) {
            ColorManipulationDefaults.debug((String)"Inside handleMinTextfield 1");
            this.minTextFieldListenerEnabled[0] = false;
            this.applyChanges(RangeKey.FromMinField);
            this.minTextFieldListenerEnabled[0] = true;
        }
        ColorManipulationDefaults.debug((String)"Inside handleMinTextfield 0");
        ImageInfo currentInfo = this.parentForm.getFormModel().getModifiedImageInfo();
        this.minField.setValue(currentInfo.getColorPaletteDef().getMinDisplaySample());
        this.setComponentsActive(true);
        ColorManipulationDefaults.debug((String)"Inside handleMinTextfield 0");
    }

    private void setComponentsActive(boolean active) {
        ColorManipulationDefaults.debug((String)"setComponentsActive");
        this.fromData.setEnabled(active);
        this.fromFile.setEnabled(active);
        this.maxField.setEditable(active);
        this.maxField.setEnabled(active);
        this.maxField.setFocusable(active);
        this.minField.setFocusable(active);
        this.minField.setEditable(active);
        this.minField.setEnabled(active);
    }

    @Override
    public Component getContentPanel() {
        return this.contentPanel;
    }

    @Override
    public ColorManipulationForm getParentForm() {
        return this.parentForm;
    }

    @Override
    public void handleFormShown(ColorFormModel formModel) {
        this.hidden = false;
        this.updateFormModel(formModel);
    }

    @Override
    public void handleFormHidden(ColorFormModel formModel) {
        this.hidden = true;
    }

    @Override
    public void updateFormModel(ColorFormModel formModel) {
        if (!this.hidden) {
            ColorPaletteManager.getDefault().loadAvailableColorPalettes(this.parentForm.getIODir().toFile());
            this.colorPaletteChooser.reloadPalettes();
        }
        ImageInfo imageInfo = formModel.getOriginalImageInfo();
        ColorPaletteDef cpd = imageInfo.getColorPaletteDef();
        boolean logScaled = imageInfo.isLogScaled();
        boolean discrete = cpd.isDiscrete();
        this.colorPaletteChooser.setLog10Display(logScaled);
        this.colorPaletteChooser.setDiscreteDisplay(discrete);
        this.shouldFireChooserEvent = false;
        this.colorPaletteChooser.setSelectedColorPaletteDefinition(cpd);
        this.discreteCheckBox.setDiscreteColorsMode(discrete);
        if (logScaled != this.logDisplayButton.isSelected()) {
            this.logDisplayButton.setSelected(logScaled);
        }
        PropertyMap configuration = this.parentForm.getFormModel().getProductSceneView().getSceneImage().getConfiguration();
        boolean schemeApply = configuration.getPropertyBool("color.manipulation.scheme.auto.apply", Boolean.valueOf(false));
        String schemeLogScaling = configuration.getPropertyString("color.manipulation.scheme.log", "From Scheme");
        String schemeRange = configuration.getPropertyString("color.manipulation.scheme.range", "From Scheme");
        String schemeCpd = configuration.getPropertyString("color.manipulation.scheme.palette", "From Scheme STANDARD");
        this.schemeInfoLabel.setText("<html>*Modified scheme");
        String optionsLocation = this.getOptionsLocation();
        this.schemeInfoLabel.setToolTipText("Not using exact scheme default: see " + optionsLocation);
        boolean visible = false;
        ColorSchemeManager colorPaletteSchemes = ColorSchemeManager.getDefault();
        colorPaletteSchemes.setSelected(imageInfo.getColorSchemeInfo());
        if (!(!colorPaletteSchemes.isSchemeSet() || !schemeApply || "From Scheme STANDARD".equals(schemeCpd) && "From Scheme".equals(schemeRange) && "From Scheme".equals(schemeLogScaling))) {
            visible = true;
        }
        this.schemeInfoLabel.setVisible(visible);
        colorPaletteSchemes.checkPreferences(configuration);
        this.parentForm.revalidateToolViewPaneControl();
        if (cpd.getMinDisplaySample() != ((Double)this.minField.getValue()).doubleValue()) {
            this.minField.setValue(cpd.getMinDisplaySample());
        }
        if (cpd.getMaxDisplaySample() != ((Double)this.maxField.getValue()).doubleValue()) {
            this.maxField.setValue(cpd.getMaxDisplaySample());
        }
        this.shouldFireChooserEvent = true;
    }

    private String getOptionsLocation() {
        String optionsLocation = "Tools/Options";
        Platform currentPlatform = Platform.getCurrentPlatform();
        if (currentPlatform != null && currentPlatform.getId() == Platform.ID.macosx) {
            optionsLocation = "App Menu/Preferences";
        }
        return optionsLocation;
    }

    @Override
    public void resetFormModel(ColorFormModel formModel) {
        this.updateFormModel(formModel);
        this.parentForm.revalidateToolViewPaneControl();
    }

    @Override
    public void handleRasterPropertyChange(ProductNodeEvent event, RasterDataNode raster) {
        if (event.getPropertyName().equals("stx")) {
            this.updateFormModel(this.parentForm.getFormModel());
        }
    }

    @Override
    public RasterDataNode[] getRasters() {
        return this.parentForm.getFormModel().getRasters();
    }

    @Override
    public MoreOptionsForm getMoreOptionsForm() {
        return this.moreOptionsForm;
    }

    @Override
    public AbstractButton[] getToolButtons() {
        return new AbstractButton[]{this.logDisplayButton};
    }

    private ActionListener createListener(RangeKey key) {
        return e -> this.applyChanges(key);
    }

    private JFormattedTextField getNumberTextField(double value) {
        NumberFormatter formatter = new NumberFormatter(new DecimalFormat("0.0############"));
        formatter.setValueClass(Double.class);
        JFormattedTextField numberField = new JFormattedTextField(formatter);
        numberField.setValue(value);
        numberField.setPreferredSize(numberField.getPreferredSize());
        return numberField;
    }

    private void applyChanges(RangeKey key) {
        ColorManipulationDefaults.debug((String)("applyChanges: Start: key=" + key.toString()));
        if (this.shouldFireChooserEvent) {
            boolean valid = true;
            boolean valueChange = false;
            ColorPaletteDef selectedCPD = this.colorPaletteChooser.getSelectedColorPaletteDefinition();
            ImageInfo currentInfo = this.parentForm.getFormModel().getModifiedImageInfo();
            ColorPaletteDef currentCPD = currentInfo.getColorPaletteDef();
            ColorPaletteDef selectedCpdDeepCopy = selectedCPD.createDeepCopy();
            selectedCpdDeepCopy.setDiscrete(currentCPD.isDiscrete());
            ColorPaletteDef sourceCpd = currentCPD;
            boolean sourceLogScaled = currentInfo.isLogScaled();
            double targetMin = currentCPD.getMinDisplaySample();
            double targetMax = currentCPD.getMaxDisplaySample();
            boolean targetLogScaled = currentInfo.isLogScaled();
            boolean targetAutoDistribute = true;
            ColorManipulationDefaults.debug((String)("applyChanges: 2: key=" + key));
            if (key == RangeKey.FromCpdFile || key == RangeKey.FromData) {
                ColorManipulationDefaults.debug((String)("applyChanges: targetMin=" + targetMin));
                ColorManipulationDefaults.debug((String)("applyChanges: currentInfo.getColorPaletteDef().getMinDisplaySample=" + currentInfo.getColorPaletteDef().getMinDisplaySample()));
                ColorManipulationDefaults.debug((String)("applyChanges: targetMax=" + targetMax));
                ColorManipulationDefaults.debug((String)("applyChanges: currentInfo.getColorPaletteDef().getMaxDisplaySample=" + currentInfo.getColorPaletteDef().getMaxDisplaySample()));
                this.shouldFireChooserEvent = false;
                this.minField.setValue(targetMin);
                this.maxField.setValue(targetMax);
                this.shouldFireChooserEvent = true;
                ColorManipulationDefaults.debug((String)("applyChanges: targetMin=" + targetMin));
                ColorManipulationDefaults.debug((String)("applyChanges: currentInfo.getColorPaletteDef().getMinDisplaySample=" + currentInfo.getColorPaletteDef().getMinDisplaySample()));
                ColorManipulationDefaults.debug((String)("applyChanges: targetMax=" + targetMax));
                ColorManipulationDefaults.debug((String)("applyChanges: currentInfo.getColorPaletteDef().getMaxDisplaySample=" + currentInfo.getColorPaletteDef().getMaxDisplaySample()));
            } else {
                String dialogErrorMsg = null;
                boolean minMaxValid = true;
                try {
                    targetMin = this.getMinFieldValue();
                }
                catch (NumberFormatException e) {
                    minMaxValid = false;
                    dialogErrorMsg = e.getMessage();
                }
                if (minMaxValid) {
                    try {
                        targetMax = this.getMaxFieldValue();
                    }
                    catch (NumberFormatException e) {
                        minMaxValid = false;
                        dialogErrorMsg = e.getMessage();
                    }
                }
                if (minMaxValid && !(minMaxValid = this.checkMinMax(targetMin, targetMax))) {
                    dialogErrorMsg = "Max must be greater than Min.  Resetting value.";
                }
                if (minMaxValid && key != RangeKey.FromLogButton && !(minMaxValid = this.checkLogScalingAgainstMinMax(targetMin, targetMax, this.logDisplayButton.isSelected(), false))) {
                    dialogErrorMsg = "Min/Max cannot be non-positive value.  Resetting Min/Max";
                }
                ColorManipulationDefaults.debug((String)("applyChanges: 3: key=" + key));
                if (!minMaxValid) {
                    targetMin = currentInfo.getColorPaletteDef().getMinDisplaySample();
                    targetMax = currentInfo.getColorPaletteDef().getMaxDisplaySample();
                    this.shouldFireChooserEvent = false;
                    this.minField.setValue(targetMin);
                    this.maxField.setValue(targetMax);
                    this.shouldFireChooserEvent = true;
                    if (dialogErrorMsg == null || dialogErrorMsg.length() <= 1) {
                        dialogErrorMsg = "Min/Max formatting error.  Resetting Min/Max";
                    }
                    ColorUtils.showErrorDialog("ERROR!: Colour Manipulation: " + dialogErrorMsg);
                }
                ColorManipulationDefaults.debug((String)("applyChanges: targetMin=" + targetMin));
                ColorManipulationDefaults.debug((String)("applyChanges: currentInfo.getColorPaletteDef().getMinDisplaySample=" + currentInfo.getColorPaletteDef().getMinDisplaySample()));
                ColorManipulationDefaults.debug((String)("applyChanges: targetMax=" + targetMax));
                ColorManipulationDefaults.debug((String)("applyChanges: currentInfo.getColorPaletteDef().getMaxDisplaySample=" + currentInfo.getColorPaletteDef().getMaxDisplaySample()));
                valueChange = targetMin != currentInfo.getColorPaletteDef().getMinDisplaySample() || targetMax != currentInfo.getColorPaletteDef().getMaxDisplaySample();
            }
            ColorManipulationDefaults.debug((String)("valueChange: " + valueChange));
            ColorManipulationDefaults.debug((String)("applyChanges: 4: key=" + key));
            switch (key) {
                case FromCpdFile: {
                    ColorManipulationDefaults.debug((String)"Inside FromCpdFile");
                    double tmpMin = currentCPD.getSourceFileMin();
                    double tmpMax = currentCPD.getSourceFileMax();
                    valid = this.testMinMaxAgainstCurrentLog(tmpMin, tmpMax);
                    if (!valid) break;
                    targetMin = tmpMin;
                    targetMax = tmpMax;
                    valueChange = targetMin != currentCPD.getMinDisplaySample() || targetMax != currentCPD.getMaxDisplaySample();
                    break;
                }
                case FromData: {
                    ColorManipulationDefaults.debug((String)"Inside FromData");
                    Stx stx = this.parentForm.getStx(this.parentForm.getFormModel().getRaster());
                    if (stx != null) {
                        PropertyMap configuration;
                        double percentile;
                        Histogram histogram = new Histogram(stx.getHistogramBins(), stx.getMinimum(), stx.getMaximum());
                        Range autoStretchRange = histogram.findRangeForPercent(percentile = (configuration = this.parentForm.getFormModel().getProductSceneView().getSceneImage().getConfiguration()).getPropertyDouble("color.manipulation.range.percentile.value", Double.valueOf(92.0)).doubleValue());
                        if (autoStretchRange != null) {
                            double tmpMax;
                            double tmpMin = autoStretchRange.getMin();
                            valid = this.testMinMaxAgainstCurrentLog(tmpMin, tmpMax = autoStretchRange.getMax());
                            if (!valid) break;
                            targetMin = tmpMin;
                            targetMax = tmpMax;
                            valueChange = targetMin != currentCPD.getMinDisplaySample() || targetMax != currentCPD.getMaxDisplaySample();
                            break;
                        }
                        valid = false;
                        break;
                    }
                    valid = false;
                    break;
                }
                case FromMinField: {
                    ColorManipulationDefaults.debug((String)"Inside FromMinField");
                    break;
                }
                case FromMaxField: {
                    ColorManipulationDefaults.debug((String)"Inside FromMaxField");
                    break;
                }
                case FromLogButton: {
                    ColorManipulationDefaults.debug((String)"Inside FromLogButton");
                    if (this.logDisplayButton.isSelected()) {
                        valid = this.checkLogScalingAgainstMinMax(targetMin, targetMax, this.logDisplayButton.isSelected(), false);
                        if (valid) {
                            this.colorPaletteChooser.setLog10Display(targetLogScaled);
                        } else {
                            this.shouldFireChooserEvent = false;
                            this.logDisplayButton.setSelected(false);
                            this.shouldFireChooserEvent = true;
                            String errorMessage = "Cannot set to log mode with a non-positive Min/Max";
                            ColorUtils.showErrorDialog("ERROR!: Colour Manipulation: \n" + errorMessage);
                        }
                    }
                    if ((targetLogScaled = this.logDisplayButton.isSelected()) == currentInfo.isLogScaled()) {
                        valueChange = false;
                    }
                    valueChange = true;
                    break;
                }
                case InvertPalette: {
                    ColorManipulationDefaults.debug((String)"Inside InvertPalette");
                    valueChange = true;
                    break;
                }
                case FromPaletteChooser: {
                    ColorManipulationDefaults.debug((String)"Inside FromPaletteChooser");
                    sourceLogScaled = selectedCPD.isLogScaled();
                    sourceCpd = selectedCpdDeepCopy;
                    if (this.loadWithCPDFileValuesCheckBox.isSelected()) {
                        targetLogScaled = selectedCPD.isLogScaled();
                        targetMin = selectedCPD.getSourceFileMin();
                        targetMax = selectedCPD.getSourceFileMax();
                        targetAutoDistribute = false;
                        valid = this.checkLogScalingAgainstMinMax(targetMin, targetMax, targetLogScaled, false);
                        if (valid) {
                            valueChange = true;
                            break;
                        }
                        String errorMessage = "Cannot load because CPD contains non-positive Min/Max contains with log mode set.";
                        ColorUtils.showErrorDialog("ERROR!: Colour Manipulation: \n" + errorMessage);
                        break;
                    }
                    valueChange = true;
                    break;
                }
            }
            ColorManipulationDefaults.debug((String)("valueChange: " + valueChange));
            ColorManipulationDefaults.debug((String)("applyChanges: 6: key=" + key));
            this.shouldFireChooserEvent = false;
            this.setComponentsActive(false);
            this.setComponentsActive(true);
            this.shouldFireChooserEvent = true;
            ColorManipulationDefaults.debug((String)("applyChanges: 7: key=" + key));
            if (this.logDisplayButton.isSelected()) {
                ColorManipulationDefaults.debug((String)"logDisplayButton=TRUE");
            } else {
                ColorManipulationDefaults.debug((String)"logDisplayButton=FALSE");
            }
            if (valid && valueChange) {
                ColorManipulationDefaults.debug((String)("applyChanges: 8: key=" + key));
                ColorManipulationDefaults.debug((String)"Is valid");
                if (key == RangeKey.InvertPalette) {
                    ColorManipulationDefaults.debug((String)"Applying currentInfo.setColorPaletteDefInvert");
                    currentInfo.setColorPaletteDefInvert(sourceCpd, targetMin, targetMax);
                } else {
                    ColorManipulationDefaults.debug((String)"Applying currentInfo.setColorPaletteDef");
                    currentInfo.setColorPaletteDef(sourceCpd, targetMin, targetMax, targetAutoDistribute, sourceLogScaled, targetLogScaled);
                }
                this.colorSchemeManager.reset();
                currentInfo.setColorSchemeInfo(this.colorSchemeManager.getNoneColorSchemeInfo());
                this.parentForm.applyChanges();
            }
            ColorManipulationDefaults.debug((String)("applyChanges: Finish: key=" + key));
        }
    }

    private boolean checkMinMax(double min, double max) {
        boolean valid = true;
        if (min == max) {
            valid = false;
        } else if (min > max) {
            valid = false;
        }
        return valid;
    }

    private double getMinFieldValue() throws NumberFormatException {
        if (this.minField.getText().length() > 0) {
            try {
                return Double.parseDouble(this.minField.getText());
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Min textField is not a number\n" + e.getMessage());
            }
        }
        throw new NumberFormatException("Min textfield is empty");
    }

    private double getMaxFieldValue() throws NumberFormatException {
        if (this.maxField.getText().length() > 0) {
            try {
                return Double.parseDouble(this.maxField.getText());
            }
            catch (NumberFormatException e) {
                String errorMessage = e.getMessage();
                throw new NumberFormatException("Max textField is not a number\n" + e.getMessage());
            }
        }
        throw new NumberFormatException("Max textfield is empty");
    }

    private boolean checkLogScalingAgainstMinMax(double min, double max, boolean logScaled, boolean showErrorDialog) {
        boolean valid = true;
        String errorMessage = "";
        if (logScaled) {
            if (min == 0.0) {
                valid = false;
                errorMessage = "Log scaling cannot be applied with min equal to zero";
            } else if (min < 0.0) {
                errorMessage = "Log scaling cannot be applied with min less than zero";
                valid = false;
            } else if (max == 0.0) {
                errorMessage = "Log scaling cannot be applied with max equal to zero";
                valid = false;
            } else if (max < 0.0) {
                errorMessage = "Log scaling cannot be applied with max less than zero";
                valid = false;
            }
        }
        if (!valid && showErrorDialog) {
            ColorUtils.showErrorDialog("ERROR!: Colour Manipulation: \n" + errorMessage);
        }
        return valid;
    }

    private JPanel getSchemePanel(String title) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(title));
        jPanel.setToolTipText("Load a preset color scheme (sets the color-palette, min, max, and log fields)");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        jPanel.add((Component)this.colorSchemeJLabel, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        jPanel.add((Component)ColorSchemeManager.getDefault().getjComboBox(), gbc);
        ++gbc.gridy;
        jPanel.add((Component)this.schemeInfoLabel, gbc);
        return jPanel;
    }

    private JPanel getPalettePanel(String title) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(title));
        jPanel.setToolTipText("");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        jPanel.add((Component)this.colorPaletteChooser, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        JPanel row2Panel = new JPanel(new BorderLayout(0, 0));
        row2Panel.add((Component)this.loadWithCPDFileValuesCheckBox, "West");
        row2Panel.add((Component)this.paletteInversionButton, "East");
        jPanel.add((Component)row2Panel, gbc);
        return jPanel;
    }

    private JPanel getRangePanel(String title) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(title));
        jPanel.setToolTipText("");
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel minPanel = new JPanel(new BorderLayout(0, 0));
        minPanel.add((Component)new JLabel("Min:"), "West");
        minPanel.add((Component)this.minField, "East");
        JPanel maxPanel = new JPanel(new BorderLayout(0, 0));
        maxPanel.add((Component)new JLabel("Max:"), "West");
        maxPanel.add((Component)this.maxField, "East");
        JPanel minMaxPanel = new JPanel(new BorderLayout(0, 0));
        minMaxPanel.add((Component)minPanel, "West");
        minMaxPanel.add((Component)maxPanel, "East");
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        jPanel.add((Component)minMaxPanel, gbc);
        JPanel buttonPanel = new JPanel(new BorderLayout(5, 10));
        buttonPanel.add((Component)this.fromFile, "West");
        buttonPanel.add((Component)this.fromData, "East");
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 4, 4, 4);
        jPanel.add((Component)buttonPanel, gbc);
        return jPanel;
    }

    private ImageInfo createDefaultImageInfo() {
        try {
            return ProductUtils.createImageInfo((RasterDataNode[])this.parentForm.getFormModel().getRasters(), (boolean)false, (ProgressMonitor)ProgressMonitor.NULL);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getContentPanel(), "Failed to create default image settings:\n" + e.getMessage(), "I/O Error", 0);
            return null;
        }
    }

    private void handleColorSchemeSelector() {
        ColorSchemeInfo colorSchemeInfo = (ColorSchemeInfo)this.colorSchemeManager.getjComboBox().getSelectedItem();
        if (colorSchemeInfo != null) {
            if (colorSchemeInfo.isEnabled() && !colorSchemeInfo.isDivider()) {
                if (this.colorSchemeManager.isNoneScheme(colorSchemeInfo)) {
                    ColorSchemeUtils.setImageInfoToGeneralColor(this.configuration, this.createDefaultImageInfo(), this.parentForm.getFormModel().getProductSceneView());
                } else {
                    ColorSchemeUtils.setImageInfoToColorScheme(colorSchemeInfo, this.parentForm.getFormModel().getProductSceneView());
                }
                this.parentForm.getFormModel().setModifiedImageInfo(this.parentForm.getFormModel().getProductSceneView().getImageInfo());
            } else if (!colorSchemeInfo.isDivider()) {
                ColorManipulationDefaults.debug((String)"Add a notification message window");
                String message = this.colorSchemeManager.checkScheme(colorSchemeInfo);
                ColorManipulationDefaults.debug((String)message);
                ColorUtils.showErrorDialog(message);
            }
        }
        this.parentForm.applyChanges();
    }

    private static enum RangeKey {
        FromCpdFile,
        FromData,
        FromMinField,
        FromMaxField,
        FromPaletteChooser,
        FromLogButton,
        InvertPalette,
        Dummy;

    }
}

