/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;

public class ColorUtils {
    private ColorUtils() {
    }

    public static int rgba(int red, int green, int blue) {
        int rgba = 255;
        rgba = (rgba << 8) + red;
        rgba = (rgba << 8) + green;
        rgba = (rgba << 8) + blue;
        return rgba;
    }

    public static int alpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static boolean isNumber(String string) {
        try {
            double d = Double.parseDouble(string);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static boolean isNumber(String string, String componentName, boolean showMessage) {
        try {
            double d = Double.parseDouble(string);
        }
        catch (NumberFormatException nfe) {
            if (showMessage) {
                ColorUtils.showErrorDialog("INPUT ERROR!!: \" + componentName + \"=\" + string + \" is not a number");
            }
            return false;
        }
        return true;
    }

    public static boolean checkRangeCompatibility(String minStr, String maxStr) {
        double max;
        if (!ColorUtils.isNumber(minStr, "Min Textfield", true)) {
            return false;
        }
        if (!ColorUtils.isNumber(maxStr, "Min Textfield", true)) {
            return false;
        }
        double min = Double.parseDouble(minStr);
        return ColorUtils.checkRangeCompatibility(min, max = Double.parseDouble(maxStr));
    }

    public static boolean checkRangeCompatibility(double min, double max) {
        if (min >= max) {
            ColorUtils.showErrorDialog("INPUT ERROR!!: Max must be greater than Min");
            return false;
        }
        return true;
    }

    public static void showErrorDialog(String message) {
        if (message != null && message.trim().length() > 0) {
            if (SnapApp.getDefault() != null) {
                Dialogs.showError(message);
            } else {
                Dialogs.showError("Error", message);
            }
        }
    }

    public static boolean checkRangeCompatibility(double min, double max, boolean isLogScaled) {
        if (!ColorUtils.checkRangeCompatibility(min, max)) {
            return false;
        }
        return ColorUtils.checkLogCompatibility(min, "Min Textfield", isLogScaled);
    }

    public static boolean checkSliderRangeCompatibility(double value, double min, double max) {
        if (value <= min || value >= max) {
            ColorUtils.showErrorDialog("INPUT ERROR!!: Slider outside range of adjacent sliders");
            return false;
        }
        return true;
    }

    public static boolean checkLogCompatibility(double value, String componentName, boolean isLogScaled) {
        if (isLogScaled && value <= 0.0) {
            ColorUtils.showErrorDialog("INPUT ERROR!!: \" + componentName + \" must be greater than zero in log scaling mode");
            return false;
        }
        return true;
    }

    public static boolean checkTableRangeCompatibility(double value, double min, double max) {
        if (value <= min || value >= max) {
            ColorUtils.showErrorDialog("INPUT ERROR!!: Value outside range of adjacent Table Values");
            return false;
        }
        return true;
    }
}

