/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import org.esa.snap.core.datamodel.ColorManipulationDefaults;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ColorSchemeInfo;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.math.Histogram;
import org.esa.snap.core.util.math.Range;
import org.esa.snap.rcp.colormanip.ColorSchemeLookupInfo;
import org.esa.snap.rcp.colormanip.ColorSchemeManager;
import org.esa.snap.ui.product.ProductSceneView;

public class ColorSchemeUtils {
    public static void setImageInfoToDefaultColor(PropertyMap configuration, ImageInfo defaultImageInfo, ProductSceneView productSceneView, boolean resetToDefaults) {
        ColorSchemeInfo colorSchemeInfo;
        boolean imageInfoSet = false;
        ColorSchemeManager colorPaletteSchemes = ColorSchemeManager.getDefault();
        if (configuration != null && configuration.getPropertyBool("color.manipulation.scheme.auto.apply", Boolean.valueOf(false)).booleanValue() && (colorSchemeInfo = ColorSchemeUtils.getColorPaletteInfoByBandNameLookup(productSceneView)) != null && (imageInfoSet = ColorSchemeUtils.setImageInfoToColorScheme(colorSchemeInfo, productSceneView))) {
            colorPaletteSchemes.setSelected(colorSchemeInfo);
        }
        boolean customDefaultScheme = configuration.getPropertyBool("color.manipulation.general.custom", Boolean.valueOf(false));
        if (!imageInfoSet) {
            if (customDefaultScheme) {
                colorPaletteSchemes.reset();
                ColorSchemeUtils.setImageInfoToGeneralColor(configuration, defaultImageInfo, productSceneView);
            } else if (resetToDefaults) {
                productSceneView.setImageInfo(defaultImageInfo);
            }
        }
    }

    public static boolean isRangeFromDataNonScheme(PropertyMap configuration) {
        if (configuration == null) {
            return false;
        }
        String generalRange = configuration.getPropertyString("color.manipulation.general.range", "From Data");
        return generalRange != null && generalRange.equals("From Data");
    }

    public static boolean isGeneralLogScaled(ColorPaletteDef colorPaletteDef, ProductSceneView productSceneView) {
        boolean logScaled = false;
        PropertyMap configuration = productSceneView.getSceneImage().getConfiguration();
        if (configuration == null) {
            return false;
        }
        String logScaledOption = configuration.getPropertyString("color.manipulation.general.log", "FALSE");
        if (logScaledOption != null) {
            switch (logScaledOption) {
                case "TRUE": {
                    logScaled = true;
                    break;
                }
                case "FALSE": {
                    logScaled = false;
                    break;
                }
                case "From Palette File": {
                    if (colorPaletteDef == null) break;
                    logScaled = colorPaletteDef.isLogScaled();
                    break;
                }
                default: {
                    logScaled = false;
                }
            }
        }
        return logScaled;
    }

    public static File getDefaultCpd(PropertyMap configuration) {
        File defaultCpd;
        String filename = null;
        String fileCategory = configuration.getPropertyString("color.manipulation.general.palette", "GRAY SCALE");
        if (fileCategory != null) {
            switch (fileCategory) {
                case "GRAY SCALE": {
                    filename = configuration.getPropertyString("color.manipulation.default.palette.gray.scale", "gray_scale.cpd");
                    break;
                }
                case "STANDARD": {
                    filename = configuration.getPropertyString("color.manipulation.default.palette.standard", "oceancolor_standard.cpd");
                    break;
                }
                case "UNIVERSAL": {
                    filename = configuration.getPropertyString("color.manipulation.default.palette.universal", "universal_bluered.cpd");
                    break;
                }
                case "ANOMALIES": {
                    filename = configuration.getPropertyString("color.manipulation.default.palette.anomalies", "gradient_red_white_blue.cpd");
                    break;
                }
                default: {
                    filename = "gray_scale.cpd";
                }
            }
        }
        File auxDir = ColorSchemeUtils.getColorPalettesAuxDataDir().toFile();
        if (filename != null && (defaultCpd = new File(auxDir, filename)).exists()) {
            return defaultCpd;
        }
        return null;
    }

    public static void setImageInfoToGeneralColor(PropertyMap configuration, ImageInfo defaultImageInfo, ProductSceneView productSceneView) {
        boolean imageInfoSet = false;
        File defaultCpdFile = ColorSchemeUtils.getDefaultCpd(configuration);
        ColorSchemeInfo colorSchemeInfo = ColorSchemeManager.getDefault().getNoneColorSchemeInfo();
        productSceneView.getImageInfo().setColorSchemeInfo(colorSchemeInfo);
        ColorPaletteDef colorPaletteDef = null;
        if (defaultCpdFile.exists()) {
            try {
                colorPaletteDef = ColorPaletteDef.loadColorPaletteDef((File)defaultCpdFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (colorPaletteDef != null) {
            double maxTarget;
            double minTarget;
            if (ColorSchemeUtils.isRangeFromDataNonScheme(configuration)) {
                Stx stx = productSceneView.getRaster().getStx();
                if (stx != null) {
                    double percentile;
                    Histogram histogram = new Histogram(stx.getHistogramBins(), stx.getMinimum(), stx.getMaximum());
                    Range autoStretchRange = histogram.findRangeForPercent(percentile = configuration.getPropertyDouble("color.manipulation.range.percentile.value", Double.valueOf(92.0)).doubleValue());
                    if (autoStretchRange != null) {
                        minTarget = autoStretchRange.getMin();
                        maxTarget = autoStretchRange.getMax();
                    } else {
                        minTarget = stx.getMinimum();
                        maxTarget = stx.getMaximum();
                    }
                } else {
                    minTarget = colorPaletteDef.getMinDisplaySample();
                    maxTarget = colorPaletteDef.getMaxDisplaySample();
                }
            } else {
                minTarget = colorPaletteDef.getMinDisplaySample();
                maxTarget = colorPaletteDef.getMaxDisplaySample();
            }
            boolean logScaledSource = colorPaletteDef.isLogScaled();
            boolean logScaledTarget = ColorSchemeUtils.isGeneralLogScaled(colorPaletteDef, productSceneView);
            if (minTarget <= 0.0) {
                logScaledTarget = false;
            }
            productSceneView.getImageInfo().setColorPaletteDef(colorPaletteDef, minTarget, maxTarget, true, logScaledSource, logScaledTarget);
            productSceneView.getImageInfo().setLogScaled(logScaledTarget);
            imageInfoSet = true;
        }
        if (!imageInfoSet) {
            productSceneView.setImageInfo(defaultImageInfo);
        }
    }

    public static ColorSchemeInfo getColorPaletteInfoByBandNameLookup(ProductSceneView productSceneView) {
        ColorSchemeManager colorSchemeManager = ColorSchemeManager.getDefault();
        if (colorSchemeManager != null) {
            String bandName = productSceneView.getBaseImageLayer().getName().trim();
            bandName = bandName.substring(bandName.indexOf(" ")).trim();
            ArrayList<ColorSchemeLookupInfo> colorSchemeLookupInfos = colorSchemeManager.getColorSchemeLookupInfos();
            for (ColorSchemeLookupInfo colorSchemeLookupInfo : colorSchemeLookupInfos) {
                if (!colorSchemeLookupInfo.isMatch(bandName)) continue;
                return colorSchemeManager.getColorSchemeInfoBySchemeId(colorSchemeLookupInfo.getScheme_id());
            }
        }
        return null;
    }

    public static boolean getLogScaledFromScheme(PropertyMap configuration, ColorSchemeInfo colorSchemeInfo, ColorPaletteDef colorPaletteDef) {
        boolean logScaled = false;
        String schemeLogScaling = configuration.getPropertyString("color.manipulation.scheme.log", "From Scheme");
        if (schemeLogScaling != null) {
            switch (schemeLogScaling) {
                case "TRUE": {
                    logScaled = true;
                    break;
                }
                case "FALSE": {
                    logScaled = false;
                    break;
                }
                case "From Palette File": {
                    if (colorPaletteDef == null) break;
                    logScaled = colorPaletteDef.isLogScaled();
                    break;
                }
                case "From Scheme": {
                    logScaled = colorSchemeInfo.isLogScaled();
                    break;
                }
                default: {
                    logScaled = false;
                }
            }
        }
        return logScaled;
    }

    public static String getCdpFileNameFromSchemeSelection(PropertyMap configuration, ColorSchemeInfo colorSchemeInfo) {
        String schemeCpdOption;
        String cpdFileName = null;
        switch (schemeCpdOption = configuration.getPropertyString("color.manipulation.scheme.palette", "From Scheme STANDARD")) {
            case "From Scheme STANDARD": {
                cpdFileName = colorSchemeInfo.getCpdFilename(false);
                break;
            }
            case "From Scheme UNIVERSAL": {
                cpdFileName = colorSchemeInfo.getCpdFilename(true);
                break;
            }
            case "GRAY SCALE": {
                cpdFileName = configuration.getPropertyString("color.manipulation.default.palette.gray.scale", "gray_scale.cpd");
                break;
            }
            case "STANDARD": {
                cpdFileName = configuration.getPropertyString("color.manipulation.default.palette.standard", "oceancolor_standard.cpd");
                break;
            }
            case "UNIVERSAL": {
                cpdFileName = configuration.getPropertyString("color.manipulation.default.palette.universal", "universal_bluered.cpd");
                break;
            }
            case "ANOMALIES": {
                cpdFileName = configuration.getPropertyString("color.manipulation.default.palette.anomalies", "gradient_red_white_blue.cpd");
                break;
            }
        }
        return cpdFileName;
    }

    public static boolean setImageInfoToColorScheme(ColorSchemeInfo colorSchemeInfo, ProductSceneView productSceneView) {
        double max;
        double min;
        String schemeRange;
        ColorManipulationDefaults.debug((String)"Inside setImageInfoToColorScheme");
        if (colorSchemeInfo == null || productSceneView == null) {
            return false;
        }
        productSceneView.getImageInfo().setColorSchemeInfo(colorSchemeInfo);
        PropertyMap configuration = productSceneView.getSceneImage().getConfiguration();
        String cpdFileName = ColorSchemeUtils.getCdpFileNameFromSchemeSelection(configuration, colorSchemeInfo);
        ColorManipulationDefaults.debug((String)("Inside setImageInfoToColorScheme: cpdFileName=" + cpdFileName));
        ColorPaletteDef colorPaletteDef = null;
        File auxDir = ColorSchemeUtils.getColorPalettesAuxDataDir().toFile();
        if (cpdFileName != null) {
            File cpdFile = new File(auxDir, cpdFileName);
            try {
                colorPaletteDef = cpdFileName.endsWith("cpt") ? ColorPaletteDef.loadCpt((File)cpdFile) : ColorPaletteDef.loadColorPaletteDef((File)cpdFile);
            }
            catch (IOException e) {
                ColorManipulationDefaults.debug((String)"Inside setImageInfoToColorScheme: cpd read exception");
                return false;
            }
        }
        Stx stx = productSceneView.getRaster().getStx();
        switch (schemeRange = configuration.getPropertyString("color.manipulation.scheme.range", "From Scheme")) {
            case "From Scheme": {
                min = colorSchemeInfo.getMinValue();
                if (min == -1.7976931348623157E308) {
                    min = stx.getMinimum();
                }
                if ((max = colorSchemeInfo.getMaxValue()) != -1.7976931348623157E308) break;
                max = stx.getMaximum();
                break;
            }
            case "From Data": {
                min = stx.getMinimum();
                max = stx.getMaximum();
                break;
            }
            case "From Palette File": {
                min = colorPaletteDef.getMinDisplaySample();
                max = colorPaletteDef.getMaxDisplaySample();
                break;
            }
            default: {
                min = stx.getMinimum();
                max = stx.getMaximum();
            }
        }
        boolean logScaled = ColorSchemeUtils.getLogScaledFromScheme(configuration, colorSchemeInfo, colorPaletteDef);
        if (colorPaletteDef != null) {
            productSceneView.getImageInfo().setColorPaletteDef(colorPaletteDef, min, max, true, colorPaletteDef.isLogScaled(), logScaled);
            productSceneView.getImageInfo().setLogScaled(logScaled);
            return true;
        }
        return false;
    }

    public static Path getColorPalettesAuxDataDir() {
        return SystemUtils.getAuxDataPath().resolve("color_palettes");
    }

    public static Path getColorSchemesAuxDataDir() {
        return SystemUtils.getAuxDataPath().resolve("color_schemes");
    }

    public static Path getRgbProfilesAuxDataDir() {
        return SystemUtils.getAuxDataPath().resolve("rgb_profiles");
    }
}

