/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.snap.core.datamodel.ColorManipulationDefaults;
import org.esa.snap.core.datamodel.ColorSchemeInfo;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.rcp.colormanip.ColorSchemeLookupInfo;
import org.esa.snap.rcp.colormanip.ColorSchemeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ColorSchemeManager {
    private ArrayList<ColorSchemeInfo> colorSchemeStoredInfos = new ArrayList();
    private ArrayList<ColorSchemeInfo> colorSchemeOrganizedInfos = new ArrayList();
    private ArrayList<ColorSchemeLookupInfo> colorSchemeLookupInfos = new ArrayList();
    private File colorSchemesFile = null;
    private File colorSchemeLutFile = null;
    private JComboBox jComboBox = null;
    private boolean jComboBoxShouldFire = true;
    private final String COLOR_SCHEME_NONE_LABEL = "-- none --";
    private String jComboBoxNoneEntryName = null;
    private ColorSchemeInfo noneColorSchemeInfo = null;
    private ColorSchemeInfo dividerPrimarySchemes = null;
    private ColorSchemeInfo dividerAdditionalSchemes = null;
    private File colorPaletteAuxDir = null;
    private File colorSchemesAuxDir = null;
    private boolean verbose = true;
    private boolean showDisabled = false;
    private boolean sortComboBox = false;
    private boolean splitComboBox = false;
    private boolean initialized = false;
    private ColorSchemeInfo currentSelection = null;
    static ColorSchemeManager manager = new ColorSchemeManager();

    public static ColorSchemeManager getDefault() {
        return manager;
    }

    public ColorSchemeManager() {
        this.init();
    }

    public void init() {
        if (!this.initialized) {
            this.setjComboBoxShouldFire(false);
            Path getColorSchemesAuxDir = ColorSchemeUtils.getColorSchemesAuxDataDir();
            if (getColorSchemesAuxDir != null) {
                this.colorSchemesAuxDir = getColorSchemesAuxDir.toFile();
                if (!this.colorSchemesAuxDir.exists()) {
                    return;
                }
            } else {
                return;
            }
            Path getColorPalettesAuxDir = ColorSchemeUtils.getColorPalettesAuxDataDir();
            if (getColorPalettesAuxDir != null) {
                this.colorPaletteAuxDir = getColorPalettesAuxDir.toFile();
                if (!this.colorPaletteAuxDir.exists()) {
                    return;
                }
            } else {
                return;
            }
            this.colorSchemesFile = new File(this.colorSchemesAuxDir, "color_palette_schemes.xml");
            this.colorSchemeLutFile = new File(this.colorSchemesAuxDir, "color_palette_scheme_lookup.xml");
            if (this.colorSchemesFile.exists() && this.colorSchemeLutFile.exists()) {
                this.createPrimaryAndAdditionalColorSchemeInfos();
                this.setjComboBoxNoneEntryName("-- none --");
                this.setNoneColorSchemeInfo(new ColorSchemeInfo(this.getjComboBoxNoneEntryName(), false, false, this.getjComboBoxNoneEntryName(), null, null, 0.0, 0.0, false, true, null, null, null, this.colorPaletteAuxDir));
                this.dividerPrimarySchemes = new ColorSchemeInfo("-- Primary Schemes --", true, true, "-- Primary Schemes --", null, null, 0.0, 0.0, false, false, null, null, null, this.colorPaletteAuxDir);
                this.dividerAdditionalSchemes = new ColorSchemeInfo("-- Additional Schemes --", true, true, "-- Additional Schemes --", null, null, 0.0, 0.0, false, false, null, null, null, this.colorPaletteAuxDir);
                this.initComboBox();
                this.initColorSchemeLookup();
                this.reset();
            }
            this.initialized = true;
            this.setjComboBoxShouldFire(true);
        }
    }

    private void addSchemeOrganizedInfos(boolean useAll, boolean primary, boolean sort, final boolean verbose) {
        ArrayList<ColorSchemeInfo> tmpInfos = new ArrayList<ColorSchemeInfo>();
        for (ColorSchemeInfo colorSchemeInfo : this.colorSchemeStoredInfos) {
            if (colorSchemeInfo.isDivider() || !useAll && primary != colorSchemeInfo.isPrimary()) continue;
            tmpInfos.add(colorSchemeInfo);
        }
        if (sort) {
            Collections.sort(tmpInfos, new Comparator<ColorSchemeInfo>(){

                @Override
                public int compare(ColorSchemeInfo s1, ColorSchemeInfo s2) {
                    return s1.toString(verbose).compareToIgnoreCase(s2.toString(verbose));
                }
            });
        }
        for (ColorSchemeInfo colorSchemeInfo : tmpInfos) {
            this.colorSchemeOrganizedInfos.add(colorSchemeInfo);
        }
    }

    private void updateOrganizedColorSchemeInfo(boolean dual, boolean verbose, boolean sort) {
        this.colorSchemeOrganizedInfos.clear();
        this.colorSchemeOrganizedInfos.add(this.getNoneColorSchemeInfo());
        if (dual) {
            this.colorSchemeOrganizedInfos.add(this.dividerPrimarySchemes);
            this.addSchemeOrganizedInfos(false, true, sort, verbose);
            this.colorSchemeOrganizedInfos.add(this.dividerAdditionalSchemes);
            this.addSchemeOrganizedInfos(false, false, sort, verbose);
        } else {
            this.addSchemeOrganizedInfos(true, false, sort, verbose);
        }
    }

    public void checkPreferences(PropertyMap configuration) {
        boolean updateSchemeSelector = false;
        boolean useDisplayName = configuration.getPropertyBool("color.manipulation.scheme.selector.verbose", Boolean.valueOf(false));
        if (this.isVerbose() != useDisplayName) {
            this.setVerbose(useDisplayName);
            updateSchemeSelector = true;
        }
        boolean sortComboBox = configuration.getPropertyBool("color.manipulation.scheme.selector.sort", Boolean.valueOf(true));
        if (this.isSortComboBox() != sortComboBox) {
            this.setSortComboBox(sortComboBox);
            updateSchemeSelector = true;
        }
        boolean splitComboBox = configuration.getPropertyBool("color.manipulation.scheme.selector.split", Boolean.valueOf(true));
        if (this.isSplitComboBox() != splitComboBox) {
            this.setSplitComboBox(splitComboBox);
            updateSchemeSelector = true;
        }
        boolean showDisabled = configuration.getPropertyBool("color.manipulation.scheme.selector.show.disabled", Boolean.valueOf(false));
        if (this.isShowDisabled() != showDisabled) {
            this.setShowDisabled(showDisabled);
            updateSchemeSelector = true;
        }
        if (updateSchemeSelector) {
            this.refreshComboBox();
        }
        ColorSchemeManager.getDefault().validateSelection();
    }

    private boolean isShowDisabled() {
        return this.showDisabled;
    }

    private void setShowDisabled(boolean showDisabled) {
        if (this.showDisabled != showDisabled) {
            this.showDisabled = showDisabled;
        }
    }

    private boolean isSortComboBox() {
        return this.sortComboBox;
    }

    private void setSortComboBox(boolean sortComboBox) {
        if (this.sortComboBox != sortComboBox) {
            this.sortComboBox = sortComboBox;
        }
    }

    private void refreshComboBox() {
        boolean shouldFire = this.isjComboBoxShouldFire();
        this.setjComboBoxShouldFire(false);
        ColorSchemeInfo selectedColorSchemeInfo = (ColorSchemeInfo)this.jComboBox.getSelectedItem();
        if (selectedColorSchemeInfo != null && selectedColorSchemeInfo.isEnabled()) {
            this.setCurrentSelection(selectedColorSchemeInfo);
        }
        this.jComboBox.removeAllItems();
        this.populateComboBox();
        if (this.getCurrentSelection() != null) {
            ColorManipulationDefaults.debug((String)("Setting selected to stored value=" + this.getCurrentSelection()));
            this.setSelected(this.getCurrentSelection());
        }
        this.jComboBox.repaint();
        this.setjComboBoxShouldFire(shouldFire);
    }

    private void validateSelection() {
        ColorSchemeInfo selectedColorSchemeInfo;
        ColorManipulationDefaults.debug((String)"Checking validation");
        if (this.jComboBox != null && (selectedColorSchemeInfo = (ColorSchemeInfo)this.jComboBox.getSelectedItem()) != null && selectedColorSchemeInfo != this.getCurrentSelection()) {
            if (selectedColorSchemeInfo.isEnabled()) {
                ColorManipulationDefaults.debug((String)"Validated Selected");
                this.setCurrentSelection(selectedColorSchemeInfo);
            } else if (this.getCurrentSelection() != null) {
                ColorManipulationDefaults.debug((String)"Setting to prior selection");
                this.setSelected(this.getCurrentSelection());
            }
        }
        ColorManipulationDefaults.debug((String)"Finished Checking validation");
    }

    private void populateComboBox() {
        this.updateOrganizedColorSchemeInfo(this.isSplitComboBox(), this.isVerbose(), this.isSortComboBox());
        String[] toolTipsArray = new String[this.colorSchemeOrganizedInfos.size()];
        Boolean[] enabledArray = new Boolean[this.colorSchemeOrganizedInfos.size()];
        Boolean[] dividerArray = new Boolean[this.colorSchemeOrganizedInfos.size()];
        Boolean[] duplicateArray = new Boolean[this.colorSchemeOrganizedInfos.size()];
        int i = 0;
        for (ColorSchemeInfo colorSchemeInfo : this.colorSchemeOrganizedInfos) {
            if (!colorSchemeInfo.isEnabled() && (colorSchemeInfo.isEnabled() || !this.showDisabled && !colorSchemeInfo.isDivider())) continue;
            toolTipsArray[i] = colorSchemeInfo.getDescription();
            enabledArray[i] = colorSchemeInfo.isEnabled();
            dividerArray[i] = colorSchemeInfo.isDivider();
            duplicateArray[i] = colorSchemeInfo.isDuplicateEntry();
            this.jComboBox.addItem(colorSchemeInfo);
            ++i;
        }
        MyComboBoxRenderer myComboBoxRenderer = new MyComboBoxRenderer();
        myComboBoxRenderer.setTooltipList(toolTipsArray);
        myComboBoxRenderer.setEnabledList(enabledArray);
        myComboBoxRenderer.setDividerList(dividerArray);
        myComboBoxRenderer.setDuplicateList(duplicateArray);
        this.jComboBox.setRenderer(myComboBoxRenderer);
    }

    private void initComboBox() {
        this.jComboBox = new JComboBox();
        this.jComboBox.setEditable(false);
        if (this.colorSchemeLutFile != null) {
            this.jComboBox.setToolTipText("To modify see file: " + this.colorSchemesAuxDir + "/" + this.colorSchemesFile.getName());
        }
        this.jComboBox.setMaximumRowCount(15);
        this.populateComboBox();
    }

    private Document getFileDocument(File file) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse(new FileInputStream(file));
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return dom;
    }

    private boolean createPrimaryAndAdditionalColorSchemeInfos() {
        Document dom = this.getFileDocument(this.colorSchemesFile);
        Element rootElement = dom.getDocumentElement();
        NodeList schemeNodeList = rootElement.getElementsByTagName("Scheme");
        if (schemeNodeList != null && schemeNodeList.getLength() > 0) {
            for (int i = 0; i < schemeNodeList.getLength(); ++i) {
                Element schemeElement = (Element)schemeNodeList.item(i);
                if (schemeElement == null) continue;
                String id = schemeElement.getAttribute("name");
                String description = ColorSchemeManager.getTextValue(schemeElement, "DESCRIPTION");
                String displayName = ColorSchemeManager.getTextValue(schemeElement, "VERBOSE_NAME");
                String colorBarLabels = ColorSchemeManager.getTextValue(schemeElement, "COLORBAR_LABELS");
                String colorBarTitle = ColorSchemeManager.getTextValue(schemeElement, "COLORBAR_TITLE");
                String minStr = ColorSchemeManager.getTextValue(schemeElement, "MIN");
                String maxStr = ColorSchemeManager.getTextValue(schemeElement, "MAX");
                String logScaledStr = ColorSchemeManager.getTextValue(schemeElement, "LOG_SCALE");
                String standardCpdFilename = ColorSchemeManager.getTextValue(schemeElement, "STANDARD_FILENAME");
                String universalCpdFilename = ColorSchemeManager.getTextValue(schemeElement, "UNIVERSAL_FILENAME");
                String dividerString = ColorSchemeManager.getTextValue(schemeElement, "DIVIDER");
                String primarySchemeString = ColorSchemeManager.getTextValue(schemeElement, "PRIMARY");
                boolean validEntry = true;
                boolean fieldsInitialized = false;
                Double min = minStr != null && minStr.length() > 0 ? Double.valueOf(minStr) : Double.valueOf(-1.7976931348623157E308);
                Double max = maxStr != null && maxStr.length() > 0 ? Double.valueOf(maxStr) : Double.valueOf(-1.7976931348623157E308);
                boolean logScaled = false;
                if (logScaledStr != null && logScaledStr.length() > 0 && logScaledStr.toLowerCase().equals("true")) {
                    logScaled = true;
                }
                boolean divider = false;
                if (dividerString != null && dividerString.length() > 0 && dividerString.toLowerCase().equals("true")) {
                    divider = true;
                }
                boolean primaryScheme = false;
                if (primarySchemeString != null && primarySchemeString.length() > 0 && primarySchemeString.toLowerCase().equals("true")) {
                    primaryScheme = true;
                }
                if (id != null && id.length() > 0) {
                    fieldsInitialized = true;
                }
                if (!fieldsInitialized) continue;
                if (!this.testMinMax(min, max, logScaled)) {
                    validEntry = false;
                }
                if (validEntry) {
                    if (standardCpdFilename != null) {
                        File standardCpdFile = new File(this.colorPaletteAuxDir, standardCpdFilename);
                        if (standardCpdFile == null || !standardCpdFile.exists()) {
                            validEntry = false;
                        }
                    } else {
                        validEntry = false;
                    }
                }
                if (validEntry) {
                    if (universalCpdFilename != null) {
                        File colorBlindCpdFile = new File(this.colorPaletteAuxDir, universalCpdFilename);
                        if (colorBlindCpdFile == null || !colorBlindCpdFile.exists()) {
                            validEntry = false;
                        }
                    } else {
                        validEntry = false;
                    }
                }
                ColorSchemeInfo colorSchemeInfo = null;
                boolean enabled = validEntry;
                colorSchemeInfo = new ColorSchemeInfo(id, primaryScheme, divider, displayName, description, standardCpdFilename, min.doubleValue(), max.doubleValue(), logScaled, enabled, universalCpdFilename, colorBarTitle, colorBarLabels, this.colorPaletteAuxDir);
                if (!colorSchemeInfo.isEnabled()) {
                    description = this.checkScheme(colorSchemeInfo);
                    colorSchemeInfo.setDescription(description);
                }
                if (colorSchemeInfo == null) continue;
                if (!colorSchemeInfo.isDuplicateEntry()) {
                    for (ColorSchemeInfo storedColorSchemeInfo : this.colorSchemeStoredInfos) {
                        if (!id.equals(storedColorSchemeInfo.getName())) continue;
                        colorSchemeInfo.setDuplicateEntry(true);
                        break;
                    }
                }
                if (colorSchemeInfo.isDuplicateEntry()) {
                    colorSchemeInfo.setDescription("WARNING!: duplicate scheme entry");
                }
                this.colorSchemeStoredInfos.add(colorSchemeInfo);
            }
        }
        return true;
    }

    private void initColorSchemeLookup() {
        Document dom = this.getFileDocument(this.colorSchemeLutFile);
        Element rootElement = dom.getDocumentElement();
        NodeList keyNodeList = rootElement.getElementsByTagName("KEY");
        if (keyNodeList != null && keyNodeList.getLength() > 0) {
            for (int i = 0; i < keyNodeList.getLength(); ++i) {
                ColorSchemeLookupInfo colorSchemeLookupInfo;
                ColorSchemeInfo colorSchemeInfo;
                boolean checksOut = true;
                Element schemeElement = (Element)keyNodeList.item(i);
                if (schemeElement == null) continue;
                String regex = schemeElement.getAttribute("REGEX");
                String schemeId = ColorSchemeManager.getTextValue(schemeElement, "SCHEME_ID");
                String description = ColorSchemeManager.getTextValue(schemeElement, "DESCRIPTION");
                if (regex == null || regex.length() == 0) {
                    checksOut = false;
                }
                if (schemeId == null || schemeId.length() == 0) {
                    schemeId = regex;
                }
                if (schemeId == null || schemeId.length() == 0) {
                    checksOut = false;
                }
                if ((colorSchemeInfo = this.getColorSchemeInfoBySchemeId(schemeId)) == null) {
                    checksOut = false;
                }
                if (!checksOut || (colorSchemeLookupInfo = new ColorSchemeLookupInfo(regex, schemeId, description, colorSchemeInfo)) == null) continue;
                this.colorSchemeLookupInfos.add(colorSchemeLookupInfo);
            }
        }
    }

    public ColorSchemeInfo getColorSchemeInfoBySchemeId(String schemeId) {
        if (schemeId != null && schemeId.length() > 0) {
            for (ColorSchemeInfo colorSchemeInfo : this.colorSchemeStoredInfos) {
                if (colorSchemeInfo == null || colorSchemeInfo.getName() == null || !schemeId.toLowerCase().equals(colorSchemeInfo.getName().toLowerCase())) continue;
                return colorSchemeInfo;
            }
        }
        return null;
    }

    private boolean testMinMax(double min, double max, boolean isLogScaled) {
        boolean checksOut = true;
        if (min != -1.7976931348623157E308 && max != -1.7976931348623157E308 && min >= max) {
            checksOut = false;
        }
        if (min != -1.7976931348623157E308 && max != -1.7976931348623157E308 && isLogScaled && min == 0.0) {
            checksOut = false;
        }
        return checksOut;
    }

    public void setSelected(ColorSchemeInfo colorSchemeInfo) {
        boolean shouldFire = this.isjComboBoxShouldFire();
        this.setjComboBoxShouldFire(false);
        this.setCurrentSelection(colorSchemeInfo);
        if (this.jComboBox != null) {
            if (colorSchemeInfo != null) {
                this.jComboBox.setSelectedItem(colorSchemeInfo);
            } else {
                this.reset();
            }
        }
        this.setjComboBoxShouldFire(shouldFire);
    }

    public void reset() {
        this.setSelected(this.getNoneColorSchemeInfo());
    }

    public boolean isSchemeSet() {
        return this.jComboBox != null && this.getNoneColorSchemeInfo() != this.jComboBox.getSelectedItem();
    }

    public static String getTextValue(Element ele, String tagName) {
        Element el;
        String textVal = null;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0 && (el = (Element)nl.item(0)).hasChildNodes()) {
            textVal = el.getFirstChild().getNodeValue();
        }
        return textVal;
    }

    public JComboBox getjComboBox() {
        return this.jComboBox;
    }

    public ArrayList<ColorSchemeLookupInfo> getColorSchemeLookupInfos() {
        return this.colorSchemeLookupInfos;
    }

    private boolean isVerbose() {
        return this.verbose;
    }

    private void setVerbose(boolean verbose) {
        this.verbose = verbose;
        for (ColorSchemeInfo colorSchemeInfo : this.colorSchemeStoredInfos) {
            colorSchemeInfo.setUseDisplayName(verbose);
        }
    }

    public ColorSchemeInfo getNoneColorSchemeInfo() {
        return this.noneColorSchemeInfo;
    }

    public void setNoneColorSchemeInfo(ColorSchemeInfo noneColorSchemeInfo) {
        this.noneColorSchemeInfo = noneColorSchemeInfo;
    }

    public ColorSchemeInfo getCurrentSelection() {
        return this.currentSelection;
    }

    public void setCurrentSelection(ColorSchemeInfo currentSelection) {
        if (currentSelection == null) {
            currentSelection = this.noneColorSchemeInfo;
        }
        ColorManipulationDefaults.debug((String)("Setting currentSelection=" + currentSelection.toString()));
        this.currentSelection = currentSelection;
    }

    public boolean isSplitComboBox() {
        return this.splitComboBox;
    }

    public void setSplitComboBox(boolean splitComboBox) {
        this.splitComboBox = splitComboBox;
    }

    public String getjComboBoxNoneEntryName() {
        return this.jComboBoxNoneEntryName;
    }

    private void setjComboBoxNoneEntryName(String jComboBoxNoneEntryName) {
        this.jComboBoxNoneEntryName = jComboBoxNoneEntryName;
    }

    public boolean isNoneScheme(ColorSchemeInfo colorSchemeInfo) {
        return this.noneColorSchemeInfo != null && this.noneColorSchemeInfo == colorSchemeInfo;
    }

    public String checkScheme(ColorSchemeInfo colorSchemeInfo) {
        Object message = "";
        if (colorSchemeInfo != null) {
            Object standardFileMessage = "";
            Object universalFileMessage = "";
            String message_head = "WARNING!: Configuration issue for scheme = '" + colorSchemeInfo.getName() + "':<br>";
            String standardFilename = colorSchemeInfo.getCpdFilename(false);
            if (standardFilename != null && standardFilename.length() > 0) {
                File standardFile = new File(this.colorPaletteAuxDir, standardFilename);
                if (standardFile == null || !standardFile.exists()) {
                    standardFileMessage = "Scheme standard file '" + standardFilename + "' does not exist<br>";
                }
            } else {
                standardFileMessage = "Scheme does not contain a standard file<br>";
            }
            String universalFilename = colorSchemeInfo.getCpdFilename(true);
            if (universalFilename != null && universalFilename.length() > 0) {
                File universalFile = new File(this.colorPaletteAuxDir, universalFilename);
                if (universalFile == null || !universalFile.exists()) {
                    universalFileMessage = "Scheme universal file '" + universalFilename + "' does not exist<br>";
                }
            } else {
                universalFileMessage = "Scheme does not contain a universal file<br>";
            }
            Object minMaxIssue = "";
            if (!this.testMinMax(colorSchemeInfo.getMinValue(), colorSchemeInfo.getMaxValue(), colorSchemeInfo.isLogScaled())) {
                minMaxIssue = "Issue with min, max values: min= '" + colorSchemeInfo.getMinValue() + "', max= '" + colorSchemeInfo.getMaxValue() + "' <br>";
            }
            message = "<html>" + message_head + (String)standardFileMessage + (String)universalFileMessage + (String)minMaxIssue + "</html>";
        } else {
            message = "Configuration Error";
        }
        return message;
    }

    public boolean isjComboBoxShouldFire() {
        return this.jComboBoxShouldFire;
    }

    public void setjComboBoxShouldFire(boolean jComboBoxShouldFire) {
        this.jComboBoxShouldFire = jComboBoxShouldFire;
    }

    class MyComboBoxRenderer
    extends BasicComboBoxRenderer {
        private String[] tooltips;
        private Boolean[] enabledList;
        private Boolean[] dividerList;
        private Boolean[] duplicateList;

        MyComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index >= 0 && this.dividerList != null && index < this.dividerList.length && this.dividerList[index].booleanValue()) {
                this.setBackground(Color.lightGray);
                this.setForeground(Color.black);
            } else if (isSelected) {
                this.setBackground(Color.blue);
                this.setForeground(Color.white);
                if (index >= 0 && this.enabledList != null && index < this.enabledList.length && !this.enabledList[index].booleanValue()) {
                    this.setForeground(Color.gray);
                }
                if (index >= 0 && this.tooltips != null && index < this.tooltips.length) {
                    list.setToolTipText(this.tooltips[index]);
                }
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
                if (index >= 0 && this.duplicateList != null && index < this.duplicateList.length && this.duplicateList[index].booleanValue()) {
                    this.setForeground(Color.red);
                } else if (index >= 0 && this.enabledList != null && index < this.enabledList.length && !this.enabledList[index].booleanValue()) {
                    this.setForeground(Color.gray);
                }
            }
            if (index == 0) {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }

        public void setTooltipList(String[] tooltipList) {
            this.tooltips = tooltipList;
        }

        public void setEnabledList(Boolean[] enabledList) {
            this.enabledList = enabledList;
        }

        public void setDividerList(Boolean[] dividerList) {
            this.dividerList = dividerList;
        }

        public void setDuplicateList(Boolean[] duplicateList) {
            this.duplicateList = duplicateList;
        }
    }
}

