/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import org.esa.snap.core.datamodel.ColorSchemeInfo;

public class ColorSchemeLookupInfo {
    private String regex;
    private String[] regexArray;
    private String scheme_id;
    private ColorSchemeInfo colorSchemeInfo;
    private String description;

    public ColorSchemeLookupInfo(String regex, String scheme_id, String description, ColorSchemeInfo colorSchemeInfo) {
        if (regex != null && scheme_id != null) {
            this.setRegex(regex);
            this.setScheme_id(scheme_id);
            this.setDescription(description);
            this.setColorSchemeInfo(colorSchemeInfo);
            this.setRegexArray(regex);
        }
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String[] getRegexArray() {
        return this.regexArray;
    }

    public void setRegexArray(String regex) {
        if (regex != null && regex.length() > 0) {
            String wildcard = ",";
            String[] regexArray = regex.split(wildcard);
            for (int i = 0; i < regexArray.length - 1; ++i) {
                regexArray[i] = regexArray[i].trim();
            }
            this.regexArray = regexArray;
        } else {
            this.regexArray = null;
        }
    }

    public String getScheme_id() {
        return this.scheme_id;
    }

    public void setScheme_id(String scheme_id) {
        this.scheme_id = scheme_id;
    }

    public ColorSchemeInfo getColorSchemeInfo() {
        return this.colorSchemeInfo;
    }

    public void setColorSchemeInfo(ColorSchemeInfo colorSchemeInfo) {
        this.colorSchemeInfo = colorSchemeInfo;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMatch(String bandName, String regex) {
        boolean match = false;
        if (bandName == null || bandName.length() == 0) {
            return false;
        }
        if (regex == null || regex.length() == 0) {
            return false;
        }
        String WILDCARD = new String("*");
        if (bandName.equals(regex = regex.trim())) {
            match = true;
        } else if (regex.contains(WILDCARD)) {
            if (!regex.startsWith(WILDCARD) && regex.endsWith(WILDCARD)) {
                String basename = regex.substring(0, regex.length() - 1);
                if (bandName.startsWith(basename)) {
                    match = true;
                }
            } else if (regex.startsWith(WILDCARD) && !regex.endsWith(WILDCARD)) {
                String basename = regex.substring(1, regex.length());
                if (bandName.endsWith(basename)) {
                    match = true;
                }
            } else if (regex.startsWith(WILDCARD) && regex.endsWith(WILDCARD)) {
                String basename = regex.substring(1, regex.length() - 1);
                if (bandName.contains(basename)) {
                    match = true;
                }
            } else {
                String basename = regex;
                String wildcard = "\\*";
                String[] basenameSplit = basename.split(wildcard);
                if (basenameSplit.length == 2 && basenameSplit[0].length() > 0 && basenameSplit[1].length() > 0 && bandName.startsWith(basenameSplit[0]) && bandName.endsWith(basenameSplit[1])) {
                    match = true;
                }
            }
        }
        return match;
    }

    public boolean isMatch(String bandName) {
        String regex;
        boolean match = false;
        if (bandName == null || bandName.length() == 0) {
            return false;
        }
        String[] stringArray = this.getRegexArray();
        int n = stringArray.length;
        for (int i = 0; i < n && !(match = this.isMatch(bandName, regex = stringArray[i])); ++i) {
        }
        return match;
    }
}

