/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.util.SystemUtils;

class ColorPaletteManager {
    static ColorPaletteManager manager = new ColorPaletteManager();
    private List<ColorPaletteDef> cpdList = new ArrayList<ColorPaletteDef>();
    private List<String> cpdNames = new ArrayList<String>();

    public static ColorPaletteManager getDefault() {
        return manager;
    }

    ColorPaletteManager() {
    }

    public void loadAvailableColorPalettes(File palettesDir) {
        this.cpdNames.clear();
        this.cpdList.clear();
        File[] files = palettesDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".cpd") || name.toLowerCase().endsWith(".cpt"));
        if (files != null) {
            for (File file : files) {
                try {
                    ColorPaletteDef newCpd = file.getName().endsWith("cpt") ? ColorPaletteDef.loadCpt((File)file) : ColorPaletteDef.loadColorPaletteDef((File)file);
                    this.cpdList.add(newCpd);
                    this.cpdNames.add(file.getName());
                }
                catch (IOException e) {
                    Logger logger = SystemUtils.LOG;
                    logger.warning("Unable to load color palette definition from file '" + file.getAbsolutePath() + "'");
                    logger.log(Level.INFO, e.getMessage(), e);
                }
            }
        }
    }

    public List<ColorPaletteDef> getColorPaletteDefList() {
        return Collections.unmodifiableList(this.cpdList);
    }

    public String getNameFor(ColorPaletteDef cpdForRaster) {
        for (int i = 0; i < this.cpdList.size(); ++i) {
            ColorPaletteDef colorPaletteDef = this.cpdList.get(i);
            if (colorPaletteDef != cpdForRaster) continue;
            return this.cpdNames.get(i);
        }
        return null;
    }
}

