/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.math.Range;
import org.esa.snap.rcp.colormanip.ColorPaletteManager;

class ColorPaletteChooser
extends JComboBox<ColorPaletteWrapper> {
    private final String DERIVED_FROM = "derived from";
    private final String UNNAMED = "unnamed";
    private boolean discreteDisplay;
    private boolean log10Display;

    public ColorPaletteChooser() {
        super(ColorPaletteChooser.getPalettes());
        this.setRenderer(this.createPaletteRenderer());
        this.setEditable(false);
    }

    public void removeUserDefinedPalette() {
        String name;
        if (this.getItemCount() > 0 && ("unnamed".equals(name = ((ColorPaletteWrapper)this.getItemAt((int)0)).name) || name.startsWith("derived from"))) {
            this.removeItemAt(0);
        }
    }

    public ColorPaletteDef getSelectedColorPaletteDefinition() {
        int selectedIndex = this.getSelectedIndex();
        ComboBoxModel model = this.getModel();
        ColorPaletteWrapper colorPaletteWrapper = (ColorPaletteWrapper)model.getElementAt(selectedIndex);
        ColorPaletteDef cpd = colorPaletteWrapper.cpd;
        cpd.getFirstPoint().setLabel(colorPaletteWrapper.name);
        return cpd;
    }

    public void setSelectedColorPaletteDefinition(ColorPaletteDef cpd) {
        this.removeUserDefinedPalette();
        ComboBoxModel model = this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!((ColorPaletteWrapper)model.getElementAt((int)i)).cpd.equals((Object)cpd)) continue;
            this.setSelectedIndex(i);
            return;
        }
        this.setUserDefinedPalette(cpd);
    }

    public void reloadPalettes() {
        this.setModel(new DefaultComboBoxModel<ColorPaletteWrapper>(ColorPaletteChooser.getPalettes()));
        this.repaint();
    }

    private void setUserDefinedPalette(ColorPaletteDef userPalette) {
        String suffix = userPalette.getFirstPoint().getLabel();
        Object name = suffix != null && suffix.trim().length() > 0 ? "derived from " + suffix.trim() : "unnamed";
        ColorPaletteWrapper item = new ColorPaletteWrapper((String)name, userPalette);
        this.insertItemAt(item, 0);
        this.setSelectedIndex(0);
    }

    private static Vector<ColorPaletteWrapper> getPalettes() {
        List<ColorPaletteDef> defList = ColorPaletteManager.getDefault().getColorPaletteDefList();
        Vector<ColorPaletteWrapper> paletteWrappers = new Vector<ColorPaletteWrapper>();
        for (ColorPaletteDef colorPaletteDef : defList) {
            String nameFor = ColorPaletteChooser.getNameForWithoutExtension(colorPaletteDef);
            paletteWrappers.add(new ColorPaletteWrapper(nameFor, colorPaletteDef));
        }
        return paletteWrappers;
    }

    private static String getNameForWithoutExtension(ColorPaletteDef colorPaletteDef) {
        String nameFor = ColorPaletteManager.getDefault().getNameFor(colorPaletteDef);
        if (nameFor.toLowerCase().endsWith(".cpd")) {
            return nameFor.substring(0, nameFor.length() - 4);
        }
        return nameFor;
    }

    private ListCellRenderer<ColorPaletteWrapper> createPaletteRenderer() {
        return new ListCellRenderer<ColorPaletteWrapper>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends ColorPaletteWrapper> list, ColorPaletteWrapper value, final int index, final boolean isSelected, boolean cellHasFocus) {
                Font font = ColorPaletteChooser.this.getFont();
                Font smaller = font.deriveFont((float)font.getSize() * 0.85f);
                JLabel nameComp = new JLabel(value.name);
                nameComp.setFont(smaller);
                final ColorPaletteDef cpd = value.cpd;
                JLabel rampComp = new JLabel(" "){

                    @Override
                    public void paint(Graphics g) {
                        super.paint(g);
                        ColorPaletteChooser.this.drawPalette((Graphics2D)g, cpd, g.getClipBounds().getSize(), index, isSelected);
                    }
                };
                JPanel palettePanel = new JPanel(new BorderLayout(0, 2));
                palettePanel.add((Component)nameComp, "North");
                palettePanel.add((Component)rampComp, "Center");
                if (isSelected) {
                    list.setToolTipText(value.name);
                }
                return palettePanel;
            }
        };
    }

    private void drawPalette(Graphics2D g2, ColorPaletteDef colorPaletteDef, Dimension paletteDim, int index, boolean isSelected) {
        int width = paletteDim.width;
        int height = paletteDim.height;
        ColorPaletteDef cpdCopy = colorPaletteDef.createDeepCopy();
        cpdCopy.setDiscrete(this.discreteDisplay);
        cpdCopy.setNumColors(width);
        ImageInfo imageInfo = new ImageInfo(cpdCopy);
        imageInfo.setLogScaled(this.log10Display);
        imageInfo.setLogScaled(colorPaletteDef.isLogScaled());
        Color[] colorPalette = ImageManager.createColorPalette((ImageInfo)imageInfo);
        g2.setStroke(new BasicStroke(1.0f));
        for (int x = 0; x < width; ++x) {
            if (isSelected && index != 0) {
                int edgeThickness = 1;
                g2.setColor(colorPalette[x]);
                g2.drawLine(x, edgeThickness + 1, x, height - (edgeThickness + 1));
                g2.setColor(Color.blue);
                g2.drawLine(x, 0, x, edgeThickness);
                g2.drawLine(x, height - edgeThickness, x, height);
                continue;
            }
            g2.setColor(colorPalette[x]);
            g2.drawLine(x, 0, x, height);
        }
    }

    public void setLog10Display(boolean log10Display) {
        this.log10Display = log10Display;
        this.repaint();
    }

    public void setDiscreteDisplay(boolean discreteDisplay) {
        this.discreteDisplay = discreteDisplay;
        this.repaint();
    }

    public Range getRangeFromFile() {
        ColorPaletteDef cpd;
        ComboBoxModel model = this.getModel();
        int selectedIndex = this.getSelectedIndex();
        ColorPaletteWrapper paletteWrapper = (ColorPaletteWrapper)model.getElementAt(selectedIndex);
        String name = paletteWrapper.name;
        if (name.startsWith("derived from")) {
            if ((name = name.substring("derived from".length()).trim()).toLowerCase().endsWith(".cpd")) {
                name = FileUtils.getFilenameWithoutExtension((String)name);
            }
            cpd = this.findColorPalette(name);
        } else {
            cpd = paletteWrapper.cpd;
        }
        return new Range(cpd.getMinDisplaySample(), cpd.getMaxDisplaySample());
    }

    private ColorPaletteDef findColorPalette(String name) {
        ComboBoxModel model = this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ColorPaletteWrapper paletteWrapper = (ColorPaletteWrapper)model.getElementAt(i);
            if (!paletteWrapper.name.equals(name)) continue;
            return paletteWrapper.cpd;
        }
        return null;
    }

    public static final class ColorPaletteWrapper {
        public final String name;
        public final ColorPaletteDef cpd;

        private ColorPaletteWrapper(String name, ColorPaletteDef cpd) {
            this.name = name;
            this.cpd = cpd;
        }
    }
}

