/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.cli;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.esa.snap.rcp.cli.SnapArgs;
import org.esa.snap.rcp.session.SessionManager;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Arg;
import org.netbeans.spi.sendopts.ArgsProcessor;
import org.netbeans.spi.sendopts.Description;
import org.netbeans.spi.sendopts.Env;

public class SnapArgsProcessor
implements ArgsProcessor {
    @Arg(longName="open")
    @Description(shortDescription="#TXT_OpenOption_Description")
    public String[] openArgs;
    @Arg(longName="python")
    @Description(shortDescription="#TXT_PythonOption_Description")
    public String[] pythonArgs;

    public void process(Env env) throws CommandException {
        if (this.openArgs != null) {
            SnapArgsProcessor.processOpen(this.openArgs);
        }
    }

    private static void processOpen(String[] args) throws CommandException {
        int errorExitCode = 100;
        Path sessionFile = null;
        ArrayList<Path> fileList = new ArrayList<Path>();
        for (String arg : args) {
            Path file = Paths.get(arg, new String[0]);
            if (Files.exists(file, new LinkOption[0])) {
                if (file.toFile() != null && SessionManager.getDefault().getSessionFileFilter().accept(file.toFile())) {
                    if (sessionFile != null) {
                        throw new CommandException(errorExitCode, "Only a single SNAP session file can be given.");
                    }
                    sessionFile = file;
                    continue;
                }
                fileList.add(file);
                continue;
            }
            System.err.println("File not found: " + file);
        }
        SnapArgs.getDefault().setSessionFile(sessionFile);
        SnapArgs.getDefault().setFileList(fileList);
    }
}

