/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.bandmaths;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.rcp.bandmaths.Bundle;

class ProductNodeNameValidator
implements Validator {
    Product targetProduct;

    public ProductNodeNameValidator(Product targetProduct) {
        this.targetProduct = targetProduct;
    }

    public void validateValue(Property property, Object value) throws ValidationException {
        String name = (String)value;
        if (!ProductNode.isValidNodeName((String)name)) {
            throw new ValidationException(Bundle.CTL_PNNV_ExMsg_ContainedCharacter(name));
        }
        if (this.targetProduct.containsRasterDataNode(name)) {
            throw new ValidationException(Bundle.CTL_PNNV_ExMsg_UniqueBandName());
        }
    }
}

