/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.bandmaths;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import com.bc.ceres.swing.binding.internal.CheckBoxEditor;
import com.bc.ceres.swing.binding.internal.NumericEditor;
import com.bc.ceres.swing.binding.internal.SingleSelectionEditor;
import com.bc.ceres.swing.binding.internal.TextComponentAdapter;
import com.bc.ceres.swing.binding.internal.TextFieldEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductNodeList;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.dataop.barithm.RasterDataSymbol;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.window.OpenImageViewAction;
import org.esa.snap.rcp.bandmaths.Bundle;
import org.esa.snap.rcp.bandmaths.ProductNodeNameValidator;
import org.esa.snap.rcp.bandmaths.PropagateUncertaintyAction;
import org.esa.snap.rcp.nodes.UndoableProductNodeInsertion;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.product.ProductExpressionPane;
import org.openide.awt.UndoRedo;

class BandMathsDialog
extends ModalDialog {
    static final String PREF_KEY_AUTO_SHOW_NEW_BANDS = "BandMaths.autoShowNewBands";
    static final String PREF_KEY_LAST_EXPRESSION_PATH = "BandMaths.lastExpressionPath";
    private static final String PROPERTY_NAME_PRODUCT = "productName";
    private static final String PROPERTY_NAME_EXPRESSION = "expression";
    private static final String PROPERTY_NAME_NO_DATA_VALUE = "noDataValue";
    private static final String PROPERTY_NAME_NO_DATA_VALUE_USED = "noDataValueUsed";
    private static final String PROPERTY_NAME_SAVE_EXPRESSION_ONLY = "saveExpressionOnly";
    private static final String PROPERTY_NAME_GENERATE_UNCERTAINTY_BAND = "generateUncertaintyBand";
    private static final String PROPERTY_NAME_BAND_NAME = "bandName";
    private static final String PROPERTY_NAME_BAND_DESC = "bandDescription";
    private static final String PROPERTY_NAME_BAND_UNIT = "bandUnit";
    private static final String PROPERTY_NAME_BAND_WAVELENGTH = "bandWavelength";
    private final ProductNodeList<Product> productsList;
    private final BindingContext bindingContext;
    private Product targetProduct;
    private String productName;
    private String expression;
    private double noDataValue;
    private boolean noDataValueUsed;
    private boolean saveExpressionOnly;
    private boolean generateUncertaintyBand;
    private String bandName;
    private String bandDescription;
    private String bandUnit;
    private float bandWavelength;
    private static int numNewBands = 0;

    public BandMathsDialog(Product currentProduct, ProductNodeList<Product> productsList, String expression, String helpId) {
        super((Window)SnapApp.getDefault().getMainFrame(), Bundle.CTL_BandMathsDialog_Title(), 161, helpId);
        Assert.notNull((Object)expression, (String)PROPERTY_NAME_EXPRESSION);
        Assert.notNull((Object)currentProduct, (String)"currentProduct");
        Assert.notNull(productsList, (String)"productsList");
        Assert.argument((productsList.size() > 0 ? 1 : 0) != 0, (String)"productsList must be not empty");
        this.targetProduct = currentProduct;
        this.productsList = productsList;
        this.bindingContext = this.createBindingContext();
        this.expression = expression;
        this.bandDescription = "";
        this.bandUnit = "";
        this.makeUI();
    }

    protected void onOK() {
        Band band;
        String validMaskExpression;
        int width = this.targetProduct.getSceneRasterWidth();
        int height = this.targetProduct.getSceneRasterHeight();
        RasterDataNode prototypeRasterDataNode = null;
        try {
            Product[] products = this.getCompatibleProducts();
            int defaultProductIndex = Arrays.asList(products).indexOf(this.targetProduct);
            validMaskExpression = BandArithmetic.getValidMaskExpression((String)this.getExpression(), (Product[])products, (int)defaultProductIndex, null);
            RasterDataNode[] refRasters = BandArithmetic.getRefRasters((String)this.getExpression(), (Product[])products, (int)defaultProductIndex);
            if (refRasters.length > 0) {
                prototypeRasterDataNode = refRasters[0];
                width = prototypeRasterDataNode.getRasterWidth();
                height = prototypeRasterDataNode.getRasterHeight();
            }
        }
        catch (ParseException e) {
            String errorMessage = Bundle.CTL_BandMathsDialog_ErrBandNotCreated() + e.getMessage();
            Dialogs.showError(Bundle.CTL_BandMathsDialog_Title() + " - Error", errorMessage);
            this.hide();
            return;
        }
        if (this.saveExpressionOnly) {
            band = new VirtualBand(this.getBandName(), 30, width, height, this.getExpression());
            this.setBandProperties(band, validMaskExpression);
        } else {
            band = new Band(this.getBandName(), 30, width, height);
            this.setBandProperties(band, "");
        }
        ProductNodeGroup bandGroup = this.targetProduct.getBandGroup();
        bandGroup.add((ProductNode)band);
        if (prototypeRasterDataNode != null) {
            ProductUtils.copyImageGeometry((RasterDataNode)prototypeRasterDataNode, (RasterDataNode)band, (boolean)false);
        }
        if (this.saveExpressionOnly) {
            this.checkExpressionForExternalReferences(this.getExpression());
        } else {
            Object expression = this.getExpression();
            if (validMaskExpression != null && !validMaskExpression.isEmpty()) {
                expression = "(" + validMaskExpression + ") ? (" + (String)expression + ") : NaN";
            }
            band.setSourceImage(VirtualBand.createSourceImage((RasterDataNode)band, (String)expression));
        }
        UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(this.targetProduct);
        if (undoManager != null) {
            undoManager.addEdit(new UndoableProductNodeInsertion<Band>(bandGroup, band));
        }
        this.hide();
        band.setModified(true);
        if (SnapApp.getDefault().getPreferences().getBoolean(PREF_KEY_AUTO_SHOW_NEW_BANDS, true)) {
            OpenImageViewAction.openImageView((RasterDataNode)band);
        }
        if (this.generateUncertaintyBand && band instanceof VirtualBand) {
            VirtualBand virtualBand = (VirtualBand)band;
            PropagateUncertaintyAction uncertaintyAction = new PropagateUncertaintyAction(virtualBand);
            uncertaintyAction.actionPerformed(null);
        }
    }

    private void setBandProperties(Band band, String validMaskExpression) {
        band.setDescription(this.bandDescription);
        band.setUnit(this.bandUnit);
        band.setSpectralWavelength(this.bandWavelength);
        band.setGeophysicalNoDataValue(this.noDataValue);
        band.setNoDataValueUsed(this.noDataValueUsed);
        band.setValidPixelExpression(validMaskExpression);
    }

    protected boolean verifyUserInput() {
        if (!this.isValidExpression()) {
            this.showErrorDialog(Bundle.CTL_BandMathsDialog_ErrExpressionNotValid());
            return false;
        }
        if (this.isTargetBandReferencedInExpression()) {
            this.showErrorDialog(Bundle.CTL_BandMathsDialog_ErrBandCannotBeReferenced(this.getBandName()));
            return false;
        }
        return super.verifyUserInput();
    }

    private void makeUI() {
        JButton loadExpressionButton = new JButton("Load...");
        loadExpressionButton.setName("loadExpressionButton");
        loadExpressionButton.addActionListener(this.createLoadExpressionButtonListener());
        JButton saveExpressionButton = new JButton("Save...");
        saveExpressionButton.setName("saveExpressionButton");
        saveExpressionButton.addActionListener(this.createSaveExpressionButtonListener());
        JButton editExpressionButton = new JButton("Edit Expression...");
        editExpressionButton.setName("editExpressionButton");
        editExpressionButton.addActionListener(this.createEditExpressionButtonListener());
        JPanel panel = GridBagUtils.createPanel();
        int line = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        JComponent[] components = this.createComponents(PROPERTY_NAME_PRODUCT, SingleSelectionEditor.class);
        ++line;
        gbc.gridy = line++;
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[1], (GridBagConstraints)gbc, (String)"gridwidth=3, fill=BOTH, weightx=1");
        gbc.gridy = line++;
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[0], (GridBagConstraints)gbc, (String)"insets.top=3, gridwidth=3, fill=BOTH, anchor=WEST");
        gbc.gridy = line++;
        components = this.createComponents(PROPERTY_NAME_BAND_NAME, TextFieldEditor.class);
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[1], (GridBagConstraints)gbc, (String)"weightx=0, insets.top=3, gridwidth=1, fill=HORIZONTAL, anchor=WEST");
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[0], (GridBagConstraints)gbc, (String)"weightx=1, insets.top=3, gridwidth=2, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        components = this.createComponents(PROPERTY_NAME_BAND_DESC, TextFieldEditor.class);
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[1], (GridBagConstraints)gbc, (String)"weightx=0, insets.top=3, gridwidth=1, fill=HORIZONTAL, anchor=WEST");
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[0], (GridBagConstraints)gbc, (String)"weightx=1, insets.top=3, gridwidth=2, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        components = this.createComponents(PROPERTY_NAME_BAND_UNIT, TextFieldEditor.class);
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[1], (GridBagConstraints)gbc, (String)"weightx=0, insets.top=3, gridwidth=1, fill=HORIZONTAL, anchor=WEST");
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[0], (GridBagConstraints)gbc, (String)"weightx=1, insets.top=3, gridwidth=2, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        components = this.createComponents(PROPERTY_NAME_BAND_WAVELENGTH, TextFieldEditor.class);
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[1], (GridBagConstraints)gbc, (String)"weightx=0, insets.top=3, gridwidth=1, fill=HORIZONTAL, anchor=WEST");
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[0], (GridBagConstraints)gbc, (String)"weightx=1, insets.top=3, gridwidth=2, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        components = this.createComponents(PROPERTY_NAME_SAVE_EXPRESSION_ONLY, CheckBoxEditor.class);
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[0], (GridBagConstraints)gbc, (String)"insets.top=3, gridwidth=3, fill=HORIZONTAL, anchor=EAST");
        gbc.gridy = line++;
        JPanel nodataPanel = new JPanel(new BorderLayout());
        components = this.createComponents(PROPERTY_NAME_NO_DATA_VALUE_USED, CheckBoxEditor.class);
        nodataPanel.add((Component)components[0], "West");
        components = this.createComponents(PROPERTY_NAME_NO_DATA_VALUE, NumericEditor.class);
        nodataPanel.add(components[0]);
        GridBagUtils.addToPanel((JPanel)panel, (Component)nodataPanel, (GridBagConstraints)gbc, (String)"weightx=1, insets.top=3, gridwidth=3, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        components = this.createComponents(PROPERTY_NAME_GENERATE_UNCERTAINTY_BAND, CheckBoxEditor.class);
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[0], (GridBagConstraints)gbc, (String)"insets.top=3, gridwidth=3, fill=HORIZONTAL, anchor=EAST");
        gbc.gridy = line++;
        JLabel expressionLabel = new JLabel(Bundle.CTL_BandMathsDialog_LblExpression());
        JTextArea expressionArea = new JTextArea();
        expressionArea.setRows(3);
        TextComponentAdapter textComponentAdapter = new TextComponentAdapter((JTextComponent)expressionArea);
        this.bindingContext.bind(PROPERTY_NAME_EXPRESSION, (ComponentAdapter)textComponentAdapter);
        GridBagUtils.addToPanel((JPanel)panel, (Component)expressionLabel, (GridBagConstraints)gbc, (String)"insets.top=3, gridwidth=3, anchor=WEST");
        gbc.gridy = line++;
        GridBagUtils.addToPanel((JPanel)panel, (Component)expressionArea, (GridBagConstraints)gbc, (String)"weighty=1, insets.top=3, gridwidth=3, fill=BOTH, anchor=WEST");
        gbc.gridy = line++;
        JPanel loadSavePanel = new JPanel();
        loadSavePanel.add(loadExpressionButton);
        loadSavePanel.add(saveExpressionButton);
        GridBagUtils.addToPanel((JPanel)panel, (Component)loadSavePanel, (GridBagConstraints)gbc, (String)"weighty=0, insets.top=3, gridwidth=2, fill=NONE, anchor=WEST");
        GridBagUtils.addToPanel((JPanel)panel, (Component)editExpressionButton, (GridBagConstraints)gbc, (String)"weighty=1, insets.top=3, gridwidth=1, fill=HORIZONTAL, anchor=EAST");
        gbc.gridy = line;
        GridBagUtils.addToPanel((JPanel)panel, (Component)new JLabel(""), (GridBagConstraints)gbc, (String)"insets.top=10, weightx=1, weighty=1, gridwidth=3, fill=BOTH, anchor=WEST");
        this.setContent(panel);
        expressionArea.selectAll();
        expressionArea.requestFocus();
    }

    private ActionListener createLoadExpressionButtonListener() {
        return e -> {
            try {
                File file = Dialogs.requestFileForOpen("Load Band Maths Expression", false, null, PREF_KEY_LAST_EXPRESSION_PATH);
                if (file != null) {
                    this.expression = new String(Files.readAllBytes(file.toPath()));
                    this.bindingContext.getBinding(PROPERTY_NAME_EXPRESSION).setPropertyValue((Object)this.expression);
                    this.bindingContext.getBinding(PROPERTY_NAME_EXPRESSION).adjustComponents();
                }
            }
            catch (IOException ex) {
                this.showErrorDialog(ex.getMessage());
            }
        };
    }

    private ActionListener createSaveExpressionButtonListener() {
        return e -> {
            try {
                File file = Dialogs.requestFileForSave("Save Band Maths Expression", false, null, ".txt", "myExpression", null, PREF_KEY_LAST_EXPRESSION_PATH);
                if (file != null) {
                    FileOutputStream out = new FileOutputStream(file.getAbsolutePath(), false);
                    PrintStream p = new PrintStream(out);
                    p.print(this.getExpression());
                }
            }
            catch (IOException ex) {
                this.showErrorDialog(ex.getMessage());
            }
        };
    }

    private JComponent[] createComponents(String propertyName, Class<? extends PropertyEditor> editorClass) {
        PropertyDescriptor descriptor = this.bindingContext.getPropertySet().getDescriptor(propertyName);
        PropertyEditor editor = PropertyEditorRegistry.getInstance().getPropertyEditor(editorClass.getName());
        return editor.createComponents(descriptor, this.bindingContext);
    }

    private BindingContext createBindingContext() {
        String newBandName;
        PropertyContainer container = PropertyContainer.createObjectBacked((Object)((Object)this));
        BindingContext context = new BindingContext((PropertySet)container);
        container.addPropertyChangeListener(PROPERTY_NAME_PRODUCT, evt -> {
            this.targetProduct = (Product)this.productsList.getByDisplayName(this.productName);
        });
        this.productName = this.targetProduct.getDisplayName();
        PropertyDescriptor descriptor = container.getDescriptor(PROPERTY_NAME_PRODUCT);
        descriptor.setValueSet(new ValueSet((Object[])this.productsList.getDisplayNames()));
        descriptor.setDisplayName("Target product");
        descriptor = container.getDescriptor(PROPERTY_NAME_BAND_NAME);
        descriptor.setDisplayName("Name");
        descriptor.setDescription("The name for the new band.");
        descriptor.setNotEmpty(true);
        descriptor.setValidator((Validator)new ProductNodeNameValidator(this.targetProduct));
        while (this.targetProduct.containsRasterDataNode(newBandName = "new_band_" + ++numNewBands)) {
        }
        descriptor.setDefaultValue((Object)("new_band_" + numNewBands));
        descriptor = container.getDescriptor(PROPERTY_NAME_BAND_DESC);
        descriptor.setDisplayName("Description");
        descriptor.setDescription("The description for the new band.");
        descriptor = container.getDescriptor(PROPERTY_NAME_BAND_UNIT);
        descriptor.setDisplayName("Unit");
        descriptor.setDescription("The physical unit for the new band.");
        descriptor = container.getDescriptor(PROPERTY_NAME_BAND_WAVELENGTH);
        descriptor.setDisplayName("Spectral wavelength");
        descriptor.setDescription("The physical unit for the new band.");
        descriptor = container.getDescriptor(PROPERTY_NAME_EXPRESSION);
        descriptor.setDisplayName("Band maths expression");
        descriptor.setDescription("Band maths expression");
        descriptor.setNotEmpty(true);
        descriptor = container.getDescriptor(PROPERTY_NAME_SAVE_EXPRESSION_ONLY);
        descriptor.setDisplayName("Virtual (save expression only, don't store data)");
        descriptor.setDefaultValue((Object)Boolean.TRUE);
        descriptor = container.getDescriptor(PROPERTY_NAME_NO_DATA_VALUE_USED);
        descriptor.setDisplayName("Replace NaN and infinity results by");
        descriptor.setDefaultValue((Object)Boolean.TRUE);
        descriptor = container.getDescriptor(PROPERTY_NAME_NO_DATA_VALUE);
        descriptor.setDefaultValue((Object)Double.NaN);
        descriptor = container.getDescriptor(PROPERTY_NAME_GENERATE_UNCERTAINTY_BAND);
        descriptor.setDisplayName("Generate associated uncertainty band");
        descriptor.setDefaultValue((Object)Boolean.FALSE);
        container.setDefaultValues();
        context.addPropertyChangeListener(PROPERTY_NAME_SAVE_EXPRESSION_ONLY, evt -> {
            boolean saveExpressionOnly1 = (Boolean)context.getBinding(PROPERTY_NAME_SAVE_EXPRESSION_ONLY).getPropertyValue();
            if (!saveExpressionOnly1) {
                context.getBinding(PROPERTY_NAME_NO_DATA_VALUE_USED).setPropertyValue((Object)true);
            }
        });
        context.bindEnabledState(PROPERTY_NAME_NO_DATA_VALUE_USED, false, PROPERTY_NAME_SAVE_EXPRESSION_ONLY, (Object)Boolean.FALSE);
        context.bindEnabledState(PROPERTY_NAME_NO_DATA_VALUE, true, PROPERTY_NAME_NO_DATA_VALUE_USED, (Object)Boolean.TRUE);
        context.bindEnabledState(PROPERTY_NAME_GENERATE_UNCERTAINTY_BAND, true, PROPERTY_NAME_SAVE_EXPRESSION_ONLY, (Object)Boolean.TRUE);
        return context;
    }

    private String getBandName() {
        return this.bandName.trim();
    }

    private String getExpression() {
        return this.expression.trim();
    }

    private Product[] getCompatibleProducts() {
        ArrayList<Product> compatibleProducts = new ArrayList<Product>(this.productsList.size());
        compatibleProducts.add(this.targetProduct);
        for (int i = 0; i < this.productsList.size(); ++i) {
            Product product = (Product)this.productsList.getAt(i);
            if (this.targetProduct == product || this.targetProduct.getSceneRasterWidth() != product.getSceneRasterWidth() || this.targetProduct.getSceneRasterHeight() != product.getSceneRasterHeight()) continue;
            compatibleProducts.add(product);
        }
        return compatibleProducts.toArray(new Product[compatibleProducts.size()]);
    }

    private ActionListener createEditExpressionButtonListener() {
        return e -> {
            Product[] compatibleProducts = this.getCompatibleProducts();
            ProductExpressionPane pep = ProductExpressionPane.createGeneralExpressionPane((Product[])compatibleProducts, (Product)this.targetProduct, (PropertyMap)SnapApp.getDefault().getPreferencesPropertyMap());
            pep.setCode(this.getExpression());
            int status = pep.showModalDialog((Window)this.getJDialog(), "Band Maths Expression Editor");
            if (status == 1) {
                this.bindingContext.getBinding(PROPERTY_NAME_EXPRESSION).setPropertyValue((Object)pep.getCode());
            }
            pep.dispose();
        };
    }

    private void checkExpressionForExternalReferences(String expression) {
        Product[] compatibleProducts = this.getCompatibleProducts();
        if (compatibleProducts.length > 1) {
            int defaultIndex = Arrays.asList(compatibleProducts).indexOf(this.targetProduct);
            RasterDataNode[] rasters = null;
            try {
                rasters = BandArithmetic.getRefRasters((String)expression, (Product[])compatibleProducts, (int)defaultIndex);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (rasters != null && rasters.length > 0) {
                HashSet<Product> externalProducts = new HashSet<Product>(compatibleProducts.length);
                for (RasterDataNode rdn : rasters) {
                    Product product = rdn.getProduct();
                    if (product == this.targetProduct) continue;
                    externalProducts.add(product);
                }
                if (!externalProducts.isEmpty()) {
                    String message = "The entered maths expression references multiple products.\nIt will cause problems unless the session is restored as is.\n\nNote: You can save the session from the file menu.";
                    Dialogs.showWarning(message);
                }
            }
        }
    }

    private boolean isValidExpression() {
        Product[] products = this.getCompatibleProducts();
        if (products.length == 0 || this.getExpression().isEmpty()) {
            return false;
        }
        int defaultIndex = Arrays.asList(products).indexOf(this.targetProduct);
        try {
            BandArithmetic.parseExpression((String)this.getExpression(), (Product[])products, (int)(defaultIndex == -1 ? 0 : defaultIndex));
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private boolean isTargetBandReferencedInExpression() {
        Product[] products = this.getCompatibleProducts();
        int defaultIndex = Arrays.asList(products).indexOf(SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.EXPLORER));
        try {
            Term term = BandArithmetic.parseExpression((String)this.getExpression(), (Product[])products, (int)(defaultIndex == -1 ? 0 : defaultIndex));
            RasterDataSymbol[] refRasterDataSymbols = BandArithmetic.getRefRasterDataSymbols((Term[])new Term[]{term});
            String bName = this.getBandName();
            if (this.targetProduct.containsRasterDataNode(bName)) {
                for (RasterDataSymbol refRasterDataSymbol : refRasterDataSymbols) {
                    String refRasterName = refRasterDataSymbol.getRaster().getName();
                    if (!bName.equalsIgnoreCase(refRasterName)) continue;
                    return true;
                }
            }
        }
        catch (ParseException e) {
            return false;
        }
        return false;
    }
}

