/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.window;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.quicklooks.Quicklook;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.window.Bundle;
import org.esa.snap.rcp.quicklooks.QuicklookToolView;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;

public class OpenQuicklookViewAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private Lookup lookup;
    private final Lookup.Result<ProductNode> result;

    public OpenQuicklookViewAction() {
        this(Utilities.actionsGlobalContext());
    }

    public OpenQuicklookViewAction(Lookup lookup) {
        this.lookup = lookup;
        this.result = lookup.lookupResult(ProductNode.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnableState();
        this.putValue("Name", Bundle.CTL_OpenQuicklookViewAction_MenuText());
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new OpenQuicklookViewAction(lookup);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setEnableState();
    }

    private void setEnableState() {
        ProductNode productNode = (ProductNode)this.lookup.lookup(ProductNode.class);
        this.setEnabled(productNode != null && productNode instanceof Quicklook);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openQuicklookView((Quicklook)SnapApp.getDefault().getSelectedProductNode(SnapApp.SelectionSourceHint.EXPLORER));
    }

    public void openQuicklookView(Quicklook ql) {
        this.openDocumentWindow(ql);
    }

    private void openDocumentWindow(final Quicklook ql) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QuicklookToolView window = (QuicklookToolView)WindowManager.getDefault().findTopComponent("QuicklookToolView");
                if (window != null) {
                    window.open();
                    window.requestActive();
                    window.setSelectedQuicklook(ql);
                }
            }
        });
    }
}

