/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.window;

import eu.esa.snap.netbeans.docwin.DocumentWindow;
import eu.esa.snap.netbeans.docwin.DocumentWindowManager;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.window.Bundle;
import org.esa.snap.rcp.placemark.PlacemarkViewTopComponent;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class OpenPlacemarkViewAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private Lookup lookup;
    private final Lookup.Result<VectorDataNode> result;

    public OpenPlacemarkViewAction() {
        this(Utilities.actionsGlobalContext());
    }

    public OpenPlacemarkViewAction(Lookup lookup) {
        this.lookup = lookup;
        this.result = lookup.lookupResult(VectorDataNode.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnableState();
        this.putValue("Name", Bundle.CTL_OpenPlacemarkViewAction_MenuText());
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new OpenPlacemarkViewAction(lookup);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setEnableState();
    }

    private void setEnableState() {
        this.setEnabled(this.lookup.lookup(VectorDataNode.class) != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ProductNode selectedProductNode = SnapApp.getDefault().getSelectedProductNode(SnapApp.SelectionSourceHint.EXPLORER);
        if (selectedProductNode instanceof VectorDataNode) {
            VectorDataNode vectorDataNode = (VectorDataNode)selectedProductNode;
            this.openView(vectorDataNode);
        }
    }

    public void openView(VectorDataNode vectorDataNode) {
        PlacemarkViewTopComponent placemarkViewTopComponent = new PlacemarkViewTopComponent(vectorDataNode);
        DocumentWindowManager.getDefault().openWindow((DocumentWindow)placemarkViewTopComponent);
        placemarkViewTopComponent.requestSelected();
    }
}

