/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.window;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import eu.esa.snap.netbeans.docwin.DocumentWindow;
import eu.esa.snap.netbeans.docwin.DocumentWindowManager;
import eu.esa.snap.netbeans.docwin.WindowUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoManager;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.Debug;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.window.Bundle;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSceneImage;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.awt.UndoRedo;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class OpenImageViewAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private RasterDataNode rasterDataNode;
    private Lookup lookup;

    public OpenImageViewAction() {
        this(Utilities.actionsGlobalContext());
    }

    public OpenImageViewAction(Lookup lookup) {
        this.putValue("Name", Bundle.CTL_OpenImageViewActionName());
        this.lookup = lookup;
        Lookup.Result rasterDataNodeResult = lookup.lookupResult(RasterDataNode.class);
        rasterDataNodeResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)rasterDataNodeResult));
        this.setEnabledState();
        this.setActionName();
    }

    public OpenImageViewAction(RasterDataNode rasterDataNode) {
        this.putValue("Name", Bundle.CTL_OpenImageViewActionName());
        this.rasterDataNode = rasterDataNode;
    }

    public static OpenImageViewAction create(RasterDataNode rasterDataNode) {
        return new OpenImageViewAction(rasterDataNode);
    }

    public static void showImageView(RasterDataNode rasterDataNode) {
        new OpenImageViewAction().openRasterDataNode(rasterDataNode);
    }

    public static void openImageView(RasterDataNode rasterDataNode) {
        new OpenImageViewAction().openRasterDataNode(rasterDataNode);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    public void execute() {
        Collection<? extends RasterDataNode> selectedRasterD = this.getSelectedRasterDataNodes();
        if (Objects.nonNull(selectedRasterD)) {
            for (RasterDataNode rasterDataNode : selectedRasterD) {
                this.openRasterDataNode(rasterDataNode);
            }
        } else if (Objects.nonNull(this.rasterDataNode)) {
            this.openRasterDataNode(this.rasterDataNode);
        }
    }

    public static ProductSceneViewTopComponent getProductSceneViewTopComponent(RasterDataNode raster) {
        return WindowUtilities.getOpened(ProductSceneViewTopComponent.class).filter(topComponent -> topComponent.getView().getNumRasters() == 1 && raster == topComponent.getView().getRaster()).findFirst().orElse(null);
    }

    public static ProductSceneView getProductSceneView(RasterDataNode raster) {
        ProductSceneViewTopComponent component = OpenImageViewAction.getProductSceneViewTopComponent(raster);
        return component != null ? component.getView() : null;
    }

    public static void updateProductSceneViewImage(ProductSceneView view) {
        SwingUtilities.invokeLater(() -> ((ProductSceneView)view).updateImage());
    }

    public static void updateProductSceneViewImages(RasterDataNode[] rasters) {
        OpenImageViewAction.updateProductSceneViewImages(rasters, ProductSceneViewImageUpdater.DEFAULT);
    }

    public static void updateProductSceneViewImages(RasterDataNode[] rasters, ProductSceneViewImageUpdater updateMethod) {
        List views = WindowUtilities.getOpened(ProductSceneViewTopComponent.class).map(ProductSceneViewTopComponent::getView).collect(Collectors.toList());
        for (ProductSceneView view : views) {
            boolean updateView = false;
            for (int j = 0; j < rasters.length && !updateView; ++j) {
                RasterDataNode raster = rasters[j];
                for (int k = 0; k < view.getNumRasters() && !updateView; ++k) {
                    if (view.getRaster(k) != raster) continue;
                    updateView = true;
                }
            }
            if (!updateView) continue;
            SwingUtilities.invokeLater(() -> updateMethod.updateView(view));
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new OpenImageViewAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnabledState();
        this.setActionName();
    }

    private void openRasterDataNode(RasterDataNode rasterDataNode) {
        ProductSceneViewTopComponent tc = OpenImageViewAction.getProductSceneViewTopComponent(rasterDataNode);
        if (tc != null) {
            tc.requestSelected();
        } else {
            this.openProductSceneView(rasterDataNode);
        }
    }

    private Collection<? extends RasterDataNode> getSelectedRasterDataNodes() {
        return this.lookup.lookupAll(RasterDataNode.class);
    }

    private void setActionName() {
        Collection<? extends RasterDataNode> selectedRasterDataNode = this.getSelectedRasterDataNodes();
        int size = selectedRasterDataNode.size();
        if (size > 1) {
            this.putValue("Name", String.format("Open %d Image Window", size));
        } else {
            this.putValue("Name", Bundle.CTL_OpenImageViewActionName());
        }
    }

    private void setEnabledState() {
        if (Objects.nonNull(this.lookup)) {
            this.setEnabled(this.lookup.lookup(RasterDataNode.class) != null);
        }
    }

    private void openProductSceneView(final RasterDataNode rasterDataNode) {
        final SnapApp snapApp = SnapApp.getDefault();
        snapApp.setStatusBarMessage("Opening image view...");
        UIUtils.setRootFrameWaitCursor((Component)snapApp.getMainFrame());
        String progressMonitorTitle = MessageFormat.format("Creating image for ''{0}''", rasterDataNode.getName());
        final ProductSceneView existingView = OpenImageViewAction.getProductSceneView(rasterDataNode);
        ProgressMonitorSwingWorker<ProductSceneImage, Object> worker = new ProgressMonitorSwingWorker<ProductSceneImage, Object>((Component)snapApp.getMainFrame(), progressMonitorTitle){

            public void done() {
                UIUtils.setRootFrameDefaultCursor((Component)snapApp.getMainFrame());
                snapApp.setStatusBarMessage("");
                try {
                    ProductSceneImage sceneImage = (ProductSceneImage)this.get();
                    UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(sceneImage.getProduct());
                    ProductSceneView view = new ProductSceneView(sceneImage, (UndoManager)undoManager);
                    OpenImageViewAction.this.openDocumentWindow(view);
                }
                catch (Exception e) {
                    snapApp.handleError(MessageFormat.format("Failed to open image view.\n\n{0}", e.getMessage()), e);
                }
            }

            protected ProductSceneImage doInBackground(ProgressMonitor pm) {
                try {
                    ProductSceneImage productSceneImage = OpenImageViewAction.this.createProductSceneImage(rasterDataNode, existingView, pm);
                    return productSceneImage;
                }
                finally {
                    if (pm.isCanceled()) {
                        rasterDataNode.unloadRasterData();
                    }
                }
            }
        };
        worker.execute();
    }

    private void openDocumentWindow(ProductSceneView view) {
        UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(view.getProduct());
        ProductSceneViewTopComponent productSceneViewWindow = new ProductSceneViewTopComponent(view, (UndoRedo)undoManager);
        DocumentWindowManager.getDefault().openWindow((DocumentWindow)productSceneViewWindow);
        productSceneViewWindow.requestSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProductSceneImage createProductSceneImage(RasterDataNode raster, ProductSceneView existingView, ProgressMonitor pm) {
        Debug.assertNotNull((Object)raster);
        Debug.assertNotNull((Object)pm);
        try {
            pm.beginTask("Creating image...", 1);
            ProductSceneImage sceneImage = existingView != null ? new ProductSceneImage(raster, existingView) : new ProductSceneImage(raster, SnapApp.getDefault().getPreferencesPropertyMap(), SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            sceneImage.initVectorDataCollectionLayer();
            sceneImage.initMaskCollectionLayer();
            ProductSceneImage productSceneImage = sceneImage;
            return productSceneImage;
        }
        finally {
            pm.done();
        }
    }

    public static interface ProductSceneViewImageUpdater {
        public static final ProductSceneViewImageUpdater DEFAULT = ProductSceneView::updateImage;

        public void updateView(ProductSceneView var1);
    }
}

