/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.vector;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.EventListener;
import javax.swing.Action;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkDescriptorRegistry;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.core.util.io.CsvReader;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.esa.snap.rcp.actions.vector.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.product.ProductSceneView;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ImportTrackAction
extends AbstractSnapAction
implements ContextAwareAction,
LookupListener {
    private Lookup lookup;
    private final Lookup.Result<ProductNode> result;

    public ImportTrackAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ImportTrackAction(Lookup lookup) {
        this.lookup = lookup;
        this.result = lookup.lookupResult(ProductNode.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnableState();
        this.setHelpId(Bundle.CTL_ImportSeadasTrackActionHelp());
        this.putValue("Name", Bundle.CTL_ImportSeadasTrackActionText());
        this.putValue("ShortDescription", Bundle.CTL_ImportSeadasTrackActionName());
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ImportTrackAction(lookup);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection;
        File file = Dialogs.requestFileForOpen(Bundle.CTL_ImportSeadasTrackActionName(), false, null, "importTrack.lastDir");
        if (file == null) {
            return;
        }
        Product product = SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.AUTO);
        try {
            featureCollection = ImportTrackAction.readTrack(file, product.getSceneGeoCoding());
        }
        catch (IOException e) {
            Dialogs.showError(Bundle.CTL_ImportSeadasTrackActionName(), "Failed to load track file:\n" + e.getMessage());
            return;
        }
        if (featureCollection.isEmpty()) {
            Dialogs.showError(Bundle.CTL_ImportSeadasTrackActionName(), "No records found.");
            return;
        }
        String name = FileUtils.getFilenameWithoutExtension((File)file);
        PlacemarkDescriptor placemarkDescriptor = PlacemarkDescriptorRegistry.getInstance().getPlacemarkDescriptor((SimpleFeatureType)featureCollection.getSchema());
        placemarkDescriptor.setUserDataOf((SimpleFeatureType)featureCollection.getSchema());
        VectorDataNode vectorDataNode = new VectorDataNode(name, featureCollection, placemarkDescriptor);
        product.getVectorDataGroup().add((ProductNode)vectorDataNode);
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        if (view != null) {
            view.setLayersVisible(new VectorDataNode[]{vectorDataNode});
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setEnableState();
    }

    private void setEnableState() {
        boolean state = false;
        ProductNode productNode = (ProductNode)this.lookup.lookup(ProductNode.class);
        if (productNode != null) {
            Product product = productNode.getProduct();
            state = product != null && product.getSceneGeoCoding() != null;
        }
        this.setEnabled(state);
    }

    private static FeatureCollection<SimpleFeatureType, SimpleFeature> readTrack(File file, GeoCoding geoCoding) throws IOException {
        try (FileReader reader = new FileReader(file);){
            FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection = ImportTrackAction.readTrack(reader, geoCoding);
            return featureCollection;
        }
    }

    static FeatureCollection<SimpleFeatureType, SimpleFeature> readTrack(Reader reader, GeoCoding geoCoding) throws IOException {
        double[] record;
        CsvReader csvReader = new CsvReader(reader, new char[]{'\t', ' '}, true, "#");
        SimpleFeatureType trackFeatureType = ImportTrackAction.createTrackFeatureType(geoCoding);
        ListFeatureCollection featureCollection = new ListFeatureCollection(trackFeatureType);
        int pointIndex = 0;
        while ((record = csvReader.readDoubleRecord()) != null) {
            if (record.length < 3) {
                throw new IOException("Illegal track file format.\nExpecting tab-separated lines containing 3 values: lat, lon, data.");
            }
            float lat = (float)record[0];
            float lon = (float)record[1];
            double data = record[2];
            SimpleFeature feature = ImportTrackAction.createFeature(trackFeatureType, geoCoding, pointIndex, lat, lon, data);
            if (feature != null) {
                featureCollection.add(feature);
            }
            ++pointIndex;
        }
        if (featureCollection.isEmpty()) {
            throw new IOException("No track point found or all of them are located outside the scene boundaries.");
        }
        CoordinateReferenceSystem mapCRS = geoCoding.getMapCRS();
        if (!mapCRS.equals(DefaultGeographicCRS.WGS84)) {
            try {
                ImportTrackAction.transformFeatureCollection((FeatureCollection<SimpleFeatureType, SimpleFeature>)featureCollection, mapCRS);
            }
            catch (TransformException e) {
                throw new IOException("Cannot transform the ship track onto CRS '" + mapCRS.toWKT() + "'.", e);
            }
        }
        return featureCollection;
    }

    private static void transformFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection, CoordinateReferenceSystem targetCRS) throws TransformException {
        GeometryCoordinateSequenceTransformer transform = FeatureUtils.getTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)targetCRS);
        FeatureIterator features = featureCollection.features();
        GeometryFactory geometryFactory = new GeometryFactory();
        while (features.hasNext()) {
            SimpleFeature simpleFeature = (SimpleFeature)features.next();
            Point sourcePoint = (Point)simpleFeature.getDefaultGeometry();
            Point targetPoint = transform.transformPoint(sourcePoint, geometryFactory);
            simpleFeature.setDefaultGeometry((Object)targetPoint);
        }
    }

    private static SimpleFeatureType createTrackFeatureType(GeoCoding geoCoding) {
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("org.esa.snap.TrackPoint");
        ftb.add("pixelPos", Point.class, geoCoding.getImageCRS());
        ftb.add("geoPos", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ftb.add("data", Double.class);
        ftb.setDefaultGeometry(geoCoding instanceof CrsGeoCoding ? "geoPos" : "pixelPos");
        SimpleFeatureType ft = ftb.buildFeatureType();
        ft.getUserData().put("trackPoints", "true");
        return ft;
    }

    private static SimpleFeature createFeature(SimpleFeatureType type, GeoCoding geoCoding, int pointIndex, float lat, float lon, double data) {
        PixelPos pixelPos = geoCoding.getPixelPos(new GeoPos((double)lat, (double)lon), null);
        if (!pixelPos.isValid()) {
            return null;
        }
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(type);
        GeometryFactory gf = new GeometryFactory();
        fb.add((Object)gf.createPoint(new Coordinate(pixelPos.x, pixelPos.y)));
        fb.add((Object)gf.createPoint(new Coordinate((double)lon, (double)lat)));
        fb.add((Object)data);
        return fb.buildFeature(String.format("ID%08d", pointIndex));
    }
}

