/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.tools;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.actions.tools.Bundle;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class CopyPixelInfoToClipboardAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private final Lookup.Result<ProductSceneView> result;

    public CopyPixelInfoToClipboardAction() {
        this(Utilities.actionsGlobalContext());
    }

    public CopyPixelInfoToClipboardAction(Lookup lkp) {
        super(Bundle.CTL_CopyPixelInfoToClipboardAction_MenuText());
        this.putValue("popupText", Bundle.CTL_CopyPixelInfoToClipboardAction_PopupText());
        this.result = lkp.lookupResult(ProductSceneView.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.updateEnableState(this.getCurrentSceneView());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.copyPixelInfoStringToClipboard();
    }

    public Action createContextAwareInstance(Lookup lkp) {
        return new CopyPixelInfoToClipboardAction(lkp);
    }

    public void resultChanged(LookupEvent le) {
        this.updateEnableState(this.getCurrentSceneView());
    }

    private void copyPixelInfoStringToClipboard() {
        Product product;
        ProductSceneView view = this.getCurrentSceneView();
        if (view != null && (product = view.getProduct()) != null) {
            RasterDataNode viewRaster = view.getRaster();
            SystemUtils.copyToClipboard((String)product.createPixelInfoString(view.getCurrentPixelX(), view.getCurrentPixelY(), viewRaster));
        }
    }

    private ProductSceneView getCurrentSceneView() {
        return this.result.allInstances().stream().findFirst().orElse(null);
    }

    private void updateEnableState(ProductSceneView sceneView) {
        this.setEnabled(sceneView != null);
    }
}

