/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.tools;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.esa.snap.core.dataio.geocoding.ComponentFactory;
import org.esa.snap.core.dataio.geocoding.ComponentGeoCoding;
import org.esa.snap.core.dataio.geocoding.ForwardCoding;
import org.esa.snap.core.dataio.geocoding.GeoChecks;
import org.esa.snap.core.dataio.geocoding.GeoRaster;
import org.esa.snap.core.dataio.geocoding.InverseCoding;
import org.esa.snap.core.dataio.geocoding.util.RasterUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.tools.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.runtime.Config;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.UIUtils;
import org.openide.awt.UndoRedo;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class AttachPixelGeoCodingAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private static final String HELP_ID = "pixelGeoCodingSetup";
    private static final int ONE_MB = 0x100000;
    private final Lookup lkp;

    public AttachPixelGeoCodingAction() {
        this(Utilities.actionsGlobalContext());
    }

    private AttachPixelGeoCodingAction(Lookup lkp) {
        super(Bundle.CTL_AttachPixelGeoCodingActionText());
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)lkpContext));
        this.putValue("ShortDescription", Bundle.CTL_AttachPixelGeoCodingDialogDescription());
        this.setEnableState();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new AttachPixelGeoCodingAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Product selectedProduct = ((ProductNode)this.lkp.lookup(ProductNode.class)).getProduct();
        int validBandCount = AttachPixelGeoCodingAction.getValidBandCount(selectedProduct);
        if (validBandCount < 2) {
            Dialogs.showError("Pixel Geo-Coding cannot be attached: Too few bands of product scene size");
            return;
        }
        AttachPixelGeoCodingAction.attachPixelGeoCoding(selectedProduct);
    }

    static int getValidBandCount(Product product) {
        Band band;
        Band[] bands = product.getBands();
        int validBandsCount = 0;
        Band[] bandArray = bands;
        int n = bandArray.length;
        for (int i = 0; !(i >= n || (band = bandArray[i]).getRasterSize().equals(product.getSceneRasterSize()) && ++validBandsCount == 2); ++i) {
        }
        return validBandsCount;
    }

    static long getRequiredMemory(Product product) {
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        int sizeOfDouble = 8;
        return width * height * 2 * 8;
    }

    private void setEnableState() {
        Product product;
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        boolean state = false;
        if (productNode != null && (product = productNode.getProduct()) != null) {
            state = product.getNumBands() >= 2;
        }
        this.setEnabled(state);
    }

    private static void attachPixelGeoCoding(final Product product) {
        String message;
        Dialogs.Answer answer;
        String dialogTitle;
        SnapApp snapApp = SnapApp.getDefault();
        final Frame mainFrame = snapApp.getMainFrame();
        PixelGeoCodingSetupDialog setupDialog = new PixelGeoCodingSetupDialog(mainFrame, dialogTitle = Bundle.CTL_AttachPixelGeoCodingDialogTitle(), HELP_ID, product);
        if (setupDialog.show() != 1) {
            return;
        }
        final Band lonBand = setupDialog.getSelectedLonBand();
        final Band latBand = setupDialog.getSelectedLatBand();
        String groundResString = setupDialog.getGroundResString();
        final double groundResInKm = Double.parseDouble(groundResString);
        String msgPattern = "New Pixel Geo-Coding: lon = ''{0}'' ; lat = ''{1}'' ; ground resolution=''{2}''";
        snapApp.getLogger().log(Level.INFO, MessageFormat.format("New Pixel Geo-Coding: lon = ''{0}'' ; lat = ''{1}'' ; ground resolution=''{2}''", lonBand.getName(), latBand.getName(), groundResString));
        long requiredBytes = AttachPixelGeoCodingAction.getRequiredMemory(product);
        long requiredMegas = requiredBytes / 0x100000L;
        long freeMegas = Runtime.getRuntime().freeMemory() / 0x100000L;
        if (freeMegas < requiredMegas && (answer = Dialogs.requestDecision(dialogTitle, message = MessageFormat.format("This operation requires to load at least {0} M\nof additional data into memory.\n\nDo you really want to continue?", requiredMegas), false, "load_latlon_band_data")) != Dialogs.Answer.YES) {
            return;
        }
        UIUtils.setRootFrameWaitCursor((Component)mainFrame);
        ProgressMonitorSwingWorker<Void, Void> swingWorker = new ProgressMonitorSwingWorker<Void, Void>((Component)mainFrame, dialogTitle){

            protected Void doInBackground(ProgressMonitor pm) throws Exception {
                InverseCoding inverse;
                ForwardCoding forward;
                double[] longitudes = RasterUtils.loadDataScaled((RasterDataNode)lonBand);
                double[] latitudes = RasterUtils.loadDataScaled((RasterDataNode)latBand);
                GeoRaster geoRaster = new GeoRaster(longitudes, latitudes, lonBand.getName(), latBand.getName(), product.getSceneRasterWidth(), product.getSceneRasterHeight(), groundResInKm);
                Preferences preferences = Config.instance((String)"snap").preferences();
                boolean useFractAccuracy = preferences.getBoolean("snap.pixelGeoCoding.fractionAccuracy", false);
                if (useFractAccuracy) {
                    forward = ComponentFactory.getForward((String)"FWD_PIXEL_INTERPOLATING");
                    inverse = ComponentFactory.getInverse((String)"INV_PIXEL_QUAD_TREE_INTERPOLATING");
                } else {
                    forward = ComponentFactory.getForward((String)"FWD_PIXEL");
                    inverse = ComponentFactory.getInverse((String)"INV_PIXEL_QUAD_TREE");
                }
                ComponentGeoCoding geoCoding = new ComponentGeoCoding(geoRaster, forward, inverse, GeoChecks.POLES);
                geoCoding.initialize();
                GeoCoding oldGeoCoding = product.getSceneGeoCoding();
                product.setSceneGeoCoding((GeoCoding)geoCoding);
                UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(product);
                if (undoManager != null) {
                    undoManager.addEdit((UndoableEdit)new UndoableAttachGeoCoding(product, (GeoCoding)geoCoding, oldGeoCoding));
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done() {
                try {
                    this.get();
                    Dialogs.showInformation(dialogTitle, "Pixel geo-coding has been attached.", null);
                }
                catch (Exception e) {
                    Throwable cause = e;
                    if (e instanceof ExecutionException) {
                        cause = e.getCause();
                    }
                    String msg = "An internal error occurred:\n" + e.getMessage();
                    if (cause instanceof IOException) {
                        msg = "An I/O error occurred:\n" + e.getMessage();
                    }
                    Dialogs.showError(dialogTitle, msg);
                }
                finally {
                    UIUtils.setRootFrameDefaultCursor((Component)mainFrame);
                }
            }
        };
        swingWorker.executeWithBlocking();
    }

    private static class UndoableAttachGeoCoding
    extends AbstractUndoableEdit {
        private Product product;
        private GeoCoding oldGeoCoding;
        private GeoCoding currentGeoCoding;

        UndoableAttachGeoCoding(Product product, GeoCoding currentGeoCoding, GeoCoding oldGeoCoding) {
            this.product = product;
            this.currentGeoCoding = currentGeoCoding;
            this.oldGeoCoding = oldGeoCoding;
        }

        @Override
        public String getPresentationName() {
            return Bundle.CTL_AttachPixelGeoCodingDialogTitle();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.product.setSceneGeoCoding(this.oldGeoCoding);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.product.setSceneGeoCoding(this.currentGeoCoding);
        }

        @Override
        public void die() {
            this.oldGeoCoding = null;
            this.currentGeoCoding = null;
            this.product = null;
        }
    }

    private static class PixelGeoCodingSetupDialog
    extends ModalDialog {
        private Product product;
        private String selectedLonBand;
        private String selectedLatBand;
        private String[] bandNames;
        private JComboBox<String> lonBox;
        private JComboBox<String> latBox;
        private JTextField groundResField;
        private final double defaultResolution = 1.0;

        PixelGeoCodingSetupDialog(Window parent, String title, String helpID, Product product) {
            super(parent, title, 161, helpID);
            this.product = product;
            Band[] bands = product.getBands();
            if (product.isMultiSize()) {
                ArrayList<String> bandNameList = new ArrayList<String>();
                for (Band band : bands) {
                    if (!band.getRasterSize().equals(product.getSceneRasterSize())) continue;
                    bandNameList.add(band.getName());
                }
                this.bandNames = bandNameList.toArray(new String[0]);
            } else {
                this.bandNames = (String[])Arrays.stream(bands).map(ProductNode::getName).toArray(String[]::new);
            }
        }

        public int show() {
            this.createUI();
            return super.show();
        }

        Band getSelectedLonBand() {
            return this.product.getBand(this.selectedLonBand);
        }

        Band getSelectedLatBand() {
            return this.product.getBand(this.selectedLatBand);
        }

        String getGroundResString() {
            return this.groundResField.getText();
        }

        protected void onOK() {
            String lonValue = (String)this.lonBox.getSelectedItem();
            this.selectedLonBand = this.findBandName(lonValue);
            String latValue = (String)this.latBox.getSelectedItem();
            this.selectedLatBand = this.findBandName(latValue);
            if (this.selectedLatBand == null || this.selectedLonBand == null || Objects.equals(this.selectedLatBand, this.selectedLonBand)) {
                Dialogs.showWarning(Bundle.CTL_AttachPixelGeoCodingDialogTitle(), "You have to select two different bands for the pixel geo-coding.", null);
            } else {
                super.onOK();
            }
        }

        protected void onCancel() {
            this.selectedLatBand = null;
            this.selectedLonBand = null;
            super.onCancel();
        }

        private void createUI() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = GridBagUtils.createDefaultConstraints();
            JLabel lonLabel = new JLabel("Longitude band:");
            JLabel latLabel = new JLabel("Latitude band:");
            JLabel groundResLabel = new JLabel("Ground Resolution in km:");
            this.lonBox = new JComboBox<String>(this.bandNames);
            this.latBox = new JComboBox<String>(this.bandNames);
            this.doPreSelection(this.lonBox, "lon");
            this.doPreSelection(this.latBox, "lat");
            this.groundResField = new JTextField(Double.toString(1.0));
            this.groundResField.setCaretPosition(0);
            gbc.insets = new Insets(3, 2, 3, 2);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            panel.add((Component)lonLabel, gbc);
            gbc.weightx = 1.0;
            ++gbc.gridx;
            gbc.gridwidth = 1;
            panel.add(this.lonBox, gbc);
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 1;
            panel.add((Component)latLabel, gbc);
            gbc.weightx = 1.0;
            ++gbc.gridx;
            gbc.gridwidth = 1;
            panel.add(this.latBox, gbc);
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 1;
            panel.add((Component)groundResLabel, gbc);
            gbc.weightx = 1.0;
            ++gbc.gridx;
            panel.add((Component)this.groundResField, gbc);
            this.setContent(panel);
        }

        private void doPreSelection(JComboBox comboBox, String toFind) {
            String bandToSelect = this.getBandNameContaining(toFind);
            if (StringUtils.isNotNullAndNotEmpty((String)bandToSelect)) {
                comboBox.setSelectedItem(bandToSelect);
            }
        }

        private String getBandNameContaining(String toFind) {
            return Arrays.stream(this.bandNames).filter(s -> s.contains(toFind)).findFirst().orElse(null);
        }

        private String findBandName(String bandName) {
            return Arrays.stream(this.bandNames).filter(s -> s.equals(bandName)).findFirst().orElseGet(() -> null);
        }
    }
}

