/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.raster;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.EventListener;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.raster.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.UIUtils;
import org.openide.awt.UndoRedo;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class CreateGeoCodingDisplacementBandsAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private final Lookup lookup;
    public static final float[][] OFFSETS = new float[][]{{0.0f, 0.0f}, {0.25f, 0.25f}, {0.5f, 0.5f}, {0.75f, 0.75f}, {0.25f, 0.75f}, {0.75f, 0.25f}};

    public CreateGeoCodingDisplacementBandsAction() {
        this(Utilities.actionsGlobalContext());
    }

    public CreateGeoCodingDisplacementBandsAction(Lookup lookup) {
        super(Bundle.CTL_CreateGeoCodingDisplacementBandsActionText());
        this.lookup = lookup;
        Lookup.Result lkpContext = lookup.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)lkpContext));
        this.setEnableState();
        this.putValue("ShortDescription", Bundle.CTL_CreateGeoCodingDisplacementBandsDescription());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new CreateGeoCodingDisplacementBandsAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.createXYDisplacementBands(((ProductNode)this.lookup.lookup(ProductNode.class)).getProduct());
    }

    private void setEnableState() {
        Product product;
        ProductNode productNode = (ProductNode)this.lookup.lookup(ProductNode.class);
        boolean state = false;
        if (productNode != null && (product = productNode.getProduct()) != null && !product.isMultiSize()) {
            state = product.getSceneGeoCoding() != null && product.getSceneGeoCoding().canGetGeoPos() && product.getSceneGeoCoding().canGetPixelPos();
        }
        this.setEnabled(state);
    }

    private void createXYDisplacementBands(final Product product) {
        final SnapApp snapApp = SnapApp.getDefault();
        final Frame mainFrame = snapApp.getMainFrame();
        final String dialogTitle = Bundle.CTL_CreateGeoCodingDisplacementBandsDialogTitle();
        ProgressMonitorSwingWorker<Band[], Object> swingWorker = new ProgressMonitorSwingWorker<Band[], Object>((Component)mainFrame, dialogTitle){

            protected Band[] doInBackground(ProgressMonitor pm) throws Exception {
                Band[] xyDisplacementBands = CreateGeoCodingDisplacementBandsAction.createXYDisplacementBands(product, pm);
                UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(product);
                if (undoManager != null) {
                    undoManager.addEdit((UndoableEdit)new UndoableDisplacementBandsCreation(product, xyDisplacementBands));
                }
                return xyDisplacementBands;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done() {
                if (snapApp.getPreferences().getBoolean("autoshowbands.enabled", true)) {
                    try {
                        Band[] bands = (Band[])this.get();
                        if (bands == null) {
                            return;
                        }
                        for (Band band : bands) {
                            Band oldBand = product.getBand(band.getName());
                            if (oldBand != null) {
                                product.removeBand(oldBand);
                            }
                            product.addBand(band);
                        }
                    }
                    catch (Exception e) {
                        Throwable cause = e;
                        if (e instanceof ExecutionException) {
                            cause = e.getCause();
                        }
                        String msg = "An internal error occurred:\n" + e.getMessage();
                        if (cause instanceof IOException) {
                            msg = "An I/O error occurred:\n" + e.getMessage();
                        }
                        Dialogs.showError(dialogTitle, msg);
                    }
                    finally {
                        UIUtils.setRootFrameDefaultCursor((Component)mainFrame);
                    }
                }
            }
        };
        swingWorker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Band[] createXYDisplacementBands(Product product, ProgressMonitor pm) {
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        ImageInfo blueToRedGrad = new ImageInfo(new ColorPaletteDef(new ColorPaletteDef.Point[]{new ColorPaletteDef.Point(-1.0, Color.BLUE), new ColorPaletteDef.Point(0.0, Color.WHITE), new ColorPaletteDef.Point(1.0, Color.RED)}));
        ImageInfo amplGrad = new ImageInfo(new ColorPaletteDef(new ColorPaletteDef.Point[]{new ColorPaletteDef.Point(0.0, Color.WHITE), new ColorPaletteDef.Point(1.0, Color.RED)}));
        ImageInfo phaseGrad = new ImageInfo(new ColorPaletteDef(new ColorPaletteDef.Point[]{new ColorPaletteDef.Point(-Math.PI, Color.WHITE), new ColorPaletteDef.Point(0.0, Color.BLUE), new ColorPaletteDef.Point(Math.PI, Color.WHITE)}));
        Band bandX = new Band("gc_displ_x", 31, width, height);
        CreateGeoCodingDisplacementBandsAction.configureBand(bandX, blueToRedGrad.clone(), "pixels", "Geo-coding X-displacement");
        Band bandY = new Band("gc_displ_y", 31, width, height);
        CreateGeoCodingDisplacementBandsAction.configureBand(bandY, blueToRedGrad.clone(), "pixels", "Geo-coding Y-displacement");
        VirtualBand bandAmpl = new VirtualBand("gc_displ_ampl", 31, width, height, "ampl(gc_displ_x, gc_displ_y)");
        CreateGeoCodingDisplacementBandsAction.configureBand((Band)bandAmpl, amplGrad.clone(), "pixels", "Geo-coding displacement amplitude");
        VirtualBand bandPhase = new VirtualBand("gc_displ_phase", 31, width, height, "phase(gc_displ_x, gc_displ_y)");
        CreateGeoCodingDisplacementBandsAction.configureBand((Band)bandPhase, phaseGrad.clone(), "radians", "Geo-coding displacement phase");
        double[] dataX = new double[width * height];
        double[] dataY = new double[width * height];
        bandX.setRasterData(ProductData.createInstance((double[])dataX));
        bandY.setRasterData(ProductData.createInstance((double[])dataY));
        pm.beginTask("Computing geo-coding displacements for product '" + product.getName() + "'...", height);
        try {
            GeoPos geoPos = new GeoPos();
            PixelPos pixelPos1 = new PixelPos();
            PixelPos pixelPos2 = new PixelPos();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    double maxX = 0.0;
                    double maxY = 0.0;
                    double valueX = 0.0;
                    double valueY = 0.0;
                    for (float[] offset : OFFSETS) {
                        pixelPos1.setLocation((double)((float)x + offset[0]), (double)((float)y + offset[1]));
                        product.getSceneGeoCoding().getGeoPos(pixelPos1, geoPos);
                        product.getSceneGeoCoding().getPixelPos(geoPos, pixelPos2);
                        double dx = pixelPos2.x - pixelPos1.x;
                        double dy = pixelPos2.y - pixelPos1.y;
                        if (Math.abs(dx) > maxX) {
                            maxX = Math.abs(dx);
                            valueX = dx;
                        }
                        if (!(Math.abs(dy) > maxY)) continue;
                        maxY = Math.abs(dy);
                        valueY = dy;
                    }
                    dataX[y * width + x] = valueX;
                    dataY[y * width + x] = valueY;
                }
                if (pm.isCanceled()) {
                    Band[] bandArray = null;
                    return bandArray;
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
        return new Band[]{bandX, bandY, bandAmpl, bandPhase};
    }

    private static void configureBand(Band band05X, ImageInfo imageInfo, String unit, String description) {
        band05X.setUnit(unit);
        band05X.setDescription(description);
        band05X.setImageInfo(imageInfo);
        band05X.setNoDataValue(Double.NaN);
        band05X.setNoDataValueUsed(true);
    }

    private static class UndoableDisplacementBandsCreation
    extends AbstractUndoableEdit {
        private Band[] displacementBands;
        private Product product;

        public UndoableDisplacementBandsCreation(Product product, Band[] displacementBands) {
            Assert.notNull((Object)product, (String)"product");
            Assert.notNull((Object)displacementBands, (String)"displacementBands");
            this.product = product;
            this.displacementBands = displacementBands;
        }

        @Override
        public String getPresentationName() {
            return Bundle.CTL_CreateGeoCodingDisplacementBandsDialogTitle();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            for (Band displacementBand : this.displacementBands) {
                if (!this.product.containsBand(displacementBand.getName())) continue;
                this.product.removeBand(displacementBand);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            for (Band displacementBand : this.displacementBands) {
                if (this.product.containsBand(displacementBand.getName())) continue;
                this.product.addBand(displacementBand);
                this.product.fireProductNodeChanged(displacementBand.getName());
            }
        }

        @Override
        public void die() {
            this.product = null;
            this.displacementBands = null;
        }
    }
}

