/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.interactors;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.support.LayerUtils;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.swing.figure.AbstractInteractorInterceptor;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureEditor;
import com.bc.ceres.swing.figure.Interactor;
import com.bc.ceres.swing.figure.interactions.SelectionInteractor;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.product.VectorDataFigureEditor;
import org.esa.snap.ui.product.VectorDataLayer;

class SelectionInteractorInterceptor
extends AbstractInteractorInterceptor {
    SelectionInteractorInterceptor() {
    }

    public void interactionStopped(Interactor interactor, InputEvent inputEvent) {
        MouseEvent mouseEvent;
        VectorDataFigureEditor figureEditor;
        SelectionInteractor selectionInteractor;
        FigureEditor editor;
        if (interactor instanceof SelectionInteractor && (editor = (selectionInteractor = (SelectionInteractor)interactor).getFigureEditor(inputEvent)) instanceof VectorDataFigureEditor && inputEvent instanceof MouseEvent && !this.isSelectionOnCurrentLayer(figureEditor = (VectorDataFigureEditor)editor, mouseEvent = (MouseEvent)inputEvent)) {
            this.findLayerForSelection(figureEditor, mouseEvent);
        }
    }

    private boolean isSelectionOnCurrentLayer(VectorDataFigureEditor figureEditor, MouseEvent mouseEvent) {
        Layer selectedLayer = figureEditor.getProductSceneView().getSelectedLayer();
        if (selectedLayer instanceof VectorDataLayer) {
            VectorDataLayer vectorDataLayer = (VectorDataLayer)selectedLayer;
            return SelectionInteractorInterceptor.getFigures(vectorDataLayer, figureEditor, mouseEvent).length > 0;
        }
        return false;
    }

    private static Figure[] getFigures(VectorDataLayer vectorDataLayer, VectorDataFigureEditor figureEditor, MouseEvent mouseEvent) {
        Viewport viewport = figureEditor.getViewport();
        AffineTransform v2mTransform = viewport.getViewToModelTransform();
        Rectangle rectangle = figureEditor.getSelectionRectangle();
        Figure[] figures = new Figure[]{};
        if (rectangle != null) {
            Shape shape = v2mTransform.createTransformedShape(rectangle);
            figures = vectorDataLayer.getFigureCollection().getFigures(shape);
        } else {
            v2mTransform.transform(mouseEvent.getPoint(), null);
            Point2D modelPoint = v2mTransform.transform(mouseEvent.getPoint(), null);
            AffineTransform m2vTransform = viewport.getModelToViewTransform();
            Figure figure = vectorDataLayer.getFigureCollection().getFigure(modelPoint, m2vTransform);
            if (figure != null) {
                figures = new Figure[]{figure};
            }
        }
        return figures;
    }

    private void findLayerForSelection(VectorDataFigureEditor figureEditor, MouseEvent mouseEvent) {
        LayerWithNearFigureFilter figureFilter = new LayerWithNearFigureFilter(figureEditor, mouseEvent);
        ProductSceneView sceneView = figureEditor.getProductSceneView();
        Layer rootLayer = sceneView.getRootLayer();
        this.selectLayer(rootLayer, figureFilter);
    }

    private void selectLayer(Layer rootLayer, LayerWithNearFigureFilter figureFilter) {
        LayerUtils.getChildLayer((Layer)rootLayer, (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (LayerFilter)figureFilter);
    }

    private static class LayerWithNearFigureFilter
    implements LayerFilter {
        private VectorDataFigureEditor figureEditor;
        private final MouseEvent mouseEvent;

        public LayerWithNearFigureFilter(VectorDataFigureEditor figureEditor, MouseEvent mouseEvent) {
            this.figureEditor = figureEditor;
            this.mouseEvent = mouseEvent;
        }

        public boolean accept(Layer layer) {
            VectorDataLayer vectorDataLayer;
            Figure[] figures;
            if (layer instanceof VectorDataLayer && (figures = SelectionInteractorInterceptor.getFigures(vectorDataLayer = (VectorDataLayer)layer, this.figureEditor, this.mouseEvent)).length > 0) {
                ProductSceneView sceneView = this.figureEditor.getProductSceneView();
                Rectangle selectionRectangle = this.figureEditor.getSelectionRectangle();
                sceneView.selectVectorDataLayer(vectorDataLayer.getVectorDataNode());
                if (selectionRectangle != null) {
                    this.figureEditor.setSelectionRectangle(selectionRectangle);
                }
                return true;
            }
            return false;
        }
    }
}

