/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file.export;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.EventListener;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.export.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.SelectExportMethodDialog;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ExportMaskPixelsAction
extends AbstractAction
implements ContextAwareAction,
LookupListener,
HelpCtx.Provider {
    private static final String HELP_ID = "exportMaskPixels";
    private static final String ERR_MSG_BASE = "Mask pixels cannot be exported:\n";
    private final Lookup.Result<ProductSceneView> result;

    public ExportMaskPixelsAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ExportMaskPixelsAction(Lookup lkp) {
        super(Bundle.CTL_ExportMaskPixelsAction_MenuText());
        this.putValue("popupText", Bundle.CTL_ExportMaskPixelsAction_PopupText());
        this.result = lkp.lookupResult(ProductSceneView.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnabled(false);
    }

    private static String createDefaultFileName(Product raster, String maskName) {
        String productName = FileUtils.getFilenameWithoutExtension((String)raster.getProduct().getName());
        return productName + "_" + maskName + "_Mask.txt";
    }

    private static String getWindowTitle() {
        return SnapApp.getDefault().getInstanceName() + " - " + Bundle.CTL_ExportMaskPixelsAction_DialogTitle();
    }

    private static File promptForFile(String defaultFileName) {
        SnapFileFilter fileFilter = new SnapFileFilter("TXT", "txt", "Text");
        return Dialogs.requestFileForSave(Bundle.CTL_ExportMaskPixelsAction_DialogTitle(), false, (FileFilter)fileFilter, ".txt", defaultFileName, null, "exportMaskPixels.lastDir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exportMaskPixels(PrintWriter out, Product product, String maskName, boolean mustCreateHeader, boolean mustExportTiePoints, boolean mustExportWavelengthsAndSF, ProgressMonitor pm) throws IOException {
        MultiLevelImage maskImage = ((Mask)product.getMaskGroup().get(maskName)).getSourceImage();
        int minTileX = maskImage.getMinTileX();
        int minTileY = maskImage.getMinTileY();
        int numXTiles = maskImage.getNumXTiles();
        int numYTiles = maskImage.getNumYTiles();
        int w = product.getSceneRasterWidth();
        int h = product.getSceneRasterHeight();
        Rectangle imageRect = new Rectangle(0, 0, w, h);
        pm.beginTask("Writing pixel data...", numXTiles * numYTiles + 2);
        try {
            if (mustCreateHeader) {
                ExportMaskPixelsAction.createHeader(out, product, maskName, mustExportWavelengthsAndSF);
            }
            pm.worked(1);
            ExportMaskPixelsAction.writeColumnNames(out, product, maskName, mustExportTiePoints);
            pm.worked(1);
            for (int tileX = minTileX; tileX < minTileX + numXTiles; ++tileX) {
                for (int tileY = minTileY; tileY < minTileY + numYTiles; ++tileY) {
                    if (pm.isCanceled()) {
                        boolean bl = false;
                        return bl;
                    }
                    Rectangle tileRectangle = new Rectangle(maskImage.getTileGridXOffset() + tileX * maskImage.getTileWidth(), maskImage.getTileGridYOffset() + tileY * maskImage.getTileHeight(), maskImage.getTileWidth(), maskImage.getTileHeight());
                    Rectangle r = imageRect.intersection(tileRectangle);
                    if (!r.isEmpty()) {
                        Raster maskTile = maskImage.getTile(tileX, tileY);
                        for (int y = r.y; y < r.y + r.height; ++y) {
                            for (int x = r.x; x < r.x + r.width; ++x) {
                                if (maskTile.getSample(x, y, 0) == 0) continue;
                                ExportMaskPixelsAction.writeDataLine(out, product, maskName, x, y, mustExportTiePoints);
                            }
                        }
                    }
                    pm.worked(1);
                }
            }
        }
        finally {
            pm.done();
        }
        return true;
    }

    private static void createHeader(PrintWriter out, Product product, String maskName, boolean mustExportWavelengthsAndSF) {
        out.write("# Exported mask '" + maskName + "' on " + new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.mmmmmm").format(new GregorianCalendar().getTime()) + "\n");
        out.write("# Product name: " + product.getName() + "\n");
        if (product.getFileLocation() != null) {
            out.write("# Product file location: " + product.getFileLocation() + "\n");
        }
        out.write("\n");
        if (mustExportWavelengthsAndSF) {
            out.write("# Wavelength:");
            out.write("\t\t\t");
            for (Band band : product.getBands()) {
                out.print("\t");
                out.print("" + band.getSpectralWavelength());
            }
            out.print("\n");
            out.write("# Solar flux:");
            out.write("\t\t\t");
            for (Band band : product.getBands()) {
                out.print("\t");
                out.print("" + band.getSolarFlux());
            }
            out.print("\n");
        }
    }

    private static void writeColumnNames(PrintWriter out, Product product, String maskName, boolean mustExportTiePointGrids) {
        if (!product.isMultiSize()) {
            out.print("Pixel-X");
            out.print("\t");
            out.print("Pixel-Y");
        } else {
            out.print("Pixel-X." + maskName);
            out.print("\t");
            out.print("Pixel-Y." + maskName);
        }
        if (product.getSceneGeoCoding() != null) {
            out.print("\t");
            out.print("Longitude");
            out.print("\t");
            out.print("Latitude");
        }
        for (Band band : product.getBands()) {
            out.print("\t");
            out.print(band.getName());
        }
        if (mustExportTiePointGrids) {
            for (Band band : product.getTiePointGrids()) {
                out.print("\t");
                out.print(band.getName());
            }
        }
        out.print("\n");
    }

    private static void writeDataLine(PrintWriter out, Product product, String maskName, int x, int y, boolean mustExportTiePoints) throws IOException {
        PixelPos pixelPosRef = new PixelPos((double)((float)x + 0.5f), (double)((float)y + 0.5f));
        out.print(pixelPosRef.x);
        out.print("\t");
        out.print(pixelPosRef.y);
        Mask mask = (Mask)product.getMaskGroup().get(maskName);
        GeoCoding maskGeocoding = mask.getGeoCoding();
        if (maskGeocoding != null) {
            GeoPos geoPos = maskGeocoding.getGeoPos(pixelPosRef, null);
            out.print("\t");
            out.print(geoPos.lon);
            out.print("\t");
            out.print(geoPos.lat);
        }
        int[] intPixel = new int[1];
        float[] floatPixel = new float[1];
        for (Band band : product.getBands()) {
            out.print("\t");
            PixelPos pixelForBand = product.getPixelForBand(pixelPosRef, (RasterDataNode)mask, (RasterDataNode)band);
            int xForBand = MathUtils.floorInt((double)pixelForBand.x);
            int yForBand = MathUtils.floorInt((double)pixelForBand.y);
            if (band.isPixelValid(xForBand, yForBand)) {
                if (band.isFloatingPointType()) {
                    band.readPixels(xForBand, yForBand, 1, 1, floatPixel, ProgressMonitor.NULL);
                    out.print(floatPixel[0]);
                    continue;
                }
                band.readPixels(xForBand, yForBand, 1, 1, intPixel, ProgressMonitor.NULL);
                out.print(intPixel[0]);
                continue;
            }
            out.print("NaN");
        }
        if (mustExportTiePoints) {
            for (Band band : product.getTiePointGrids()) {
                PixelPos pixelForGrid = product.getPixelForBand(pixelPosRef, (RasterDataNode)mask, (RasterDataNode)band);
                band.readPixels(MathUtils.floorInt((double)pixelForGrid.x), MathUtils.floorInt((double)pixelForGrid.y), 1, 1, floatPixel, ProgressMonitor.NULL);
                out.print("\t");
                out.print(floatPixel[0]);
                if (!Float.isNaN(floatPixel[0])) continue;
                System.out.println("NaN for " + band.getName());
            }
        }
        out.print("\n");
    }

    private static long getNumMaskPixels(RenderedImage maskImage, int sceneRasterWidth, int sceneRasterHeight) {
        int minTileX = maskImage.getMinTileX();
        int minTileY = maskImage.getMinTileY();
        int numXTiles = maskImage.getNumXTiles();
        int numYTiles = maskImage.getNumYTiles();
        Rectangle imageRect = new Rectangle(0, 0, sceneRasterWidth, sceneRasterHeight);
        long numMaskPixels = 0L;
        for (int tileX = minTileX; tileX < minTileX + numXTiles; ++tileX) {
            for (int tileY = minTileY; tileY < minTileY + numYTiles; ++tileY) {
                Rectangle tileRectangle = new Rectangle(maskImage.getTileGridXOffset() + tileX * maskImage.getTileWidth(), maskImage.getTileGridYOffset() + tileY * maskImage.getTileHeight(), maskImage.getTileWidth(), maskImage.getTileHeight());
                Rectangle r = imageRect.intersection(tileRectangle);
                if (r.isEmpty()) continue;
                Raster maskTile = maskImage.getTile(tileX, tileY);
                for (int y = r.y; y < r.y + r.height; ++y) {
                    for (int x = r.x; x < r.x + r.width; ++x) {
                        if (maskTile.getSample(x, y, 0) == 0) continue;
                        ++numMaskPixels;
                    }
                }
            }
        }
        return numMaskPixels;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
        if (sceneView != null) {
            Product product = sceneView.getProduct();
            this.exportMaskPixels(product);
        }
    }

    public Action createContextAwareInstance(Lookup lkp) {
        return new ExportMaskPixelsAction(lkp);
    }

    public void resultChanged(LookupEvent le) {
        Product product;
        ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
        boolean enabled = false;
        if (sceneView != null && (product = sceneView.getProduct()) != null) {
            enabled = product.getMaskGroup().getNodeCount() > 0;
        }
        this.setEnabled(enabled);
    }

    private void exportMaskPixels(final Product product) {
        StringBuffer clipboardText;
        PrintWriter out;
        String maskName;
        String[] maskNames = product.getMaskGroup().getNodeNames();
        if (maskNames.length == 1) {
            maskName = maskNames[0];
        } else {
            JPanel panel = new JPanel();
            BoxLayout boxLayout = new BoxLayout(panel, 0);
            panel.setLayout(boxLayout);
            panel.add(new JLabel("Select Mask: "));
            JComboBox<String> maskCombo = new JComboBox<String>(maskNames);
            panel.add(maskCombo);
            ModalDialog modalDialog = new ModalDialog((Window)SnapApp.getDefault().getMainFrame(), Bundle.CTL_ExportMaskPixelsAction_DialogTitle(), (Object)panel, 161, this.getHelpCtx().getHelpID());
            if (modalDialog.show() == 1) {
                maskName = (String)maskCombo.getSelectedItem();
            } else {
                return;
            }
        }
        MultiLevelImage maskImage = ((Mask)product.getMaskGroup().get(maskName)).getSourceImage();
        if (maskImage == null) {
            Dialogs.showError(Bundle.CTL_ExportMaskPixelsAction_DialogTitle(), "Mask pixels cannot be exported:\nNo Mask image available.");
            return;
        }
        long numMaskPixels = ExportMaskPixelsAction.getNumMaskPixels((RenderedImage)maskImage, product.getSceneRasterWidth(), product.getSceneRasterHeight());
        Object numPixelsText = numMaskPixels == 1L ? "One Mask pixel will be exported.\n" : numMaskPixels + " Mask pixels will be exported.\n";
        String questionText = "How do you want to export the pixel values?\n";
        JCheckBox createHeaderBox = new JCheckBox("Create header");
        JCheckBox exportTiePointsBox = new JCheckBox("Export tie-points");
        JCheckBox exportWavelengthsAndSFBox = new JCheckBox("Export wavelengths + solar fluxes");
        int method = SelectExportMethodDialog.run((Component)SnapApp.getDefault().getMainFrame(), (String)ExportMaskPixelsAction.getWindowTitle(), (String)("How do you want to export the pixel values?\n" + (String)numPixelsText), (JCheckBox[])new JCheckBox[]{createHeaderBox, exportTiePointsBox, exportWavelengthsAndSFBox}, (String)this.getHelpCtx().getHelpID());
        final boolean mustCreateHeader = createHeaderBox.isSelected();
        final boolean mustExportTiePoints = exportTiePointsBox.isSelected();
        final boolean mustExportWavelengthsAndSF = exportWavelengthsAndSFBox.isSelected();
        int initialBufferSize = 256000;
        if (method == 0) {
            StringWriter stringWriter = new StringWriter(256000);
            out = new PrintWriter(stringWriter);
            clipboardText = stringWriter.getBuffer();
        } else if (method == 1) {
            FileWriter fileWriter;
            File file = ExportMaskPixelsAction.promptForFile(ExportMaskPixelsAction.createDefaultFileName(product, maskName));
            if (file == null) {
                return;
            }
            try {
                fileWriter = new FileWriter(file);
            }
            catch (IOException e) {
                Dialogs.showError(Bundle.CTL_ExportMaskPixelsAction_DialogTitle(), "Mask pixels cannot be exported:\nFailed to create file '" + file + "':\n" + e.getMessage());
                return;
            }
            out = new PrintWriter(new BufferedWriter(fileWriter, 256000));
            clipboardText = null;
        } else {
            return;
        }
        ProgressMonitorSwingWorker<Exception, Object> swingWorker = new ProgressMonitorSwingWorker<Exception, Object>((Component)SnapApp.getDefault().getMainFrame(), Bundle.CTL_ExportMaskPixelsAction_DialogTitle()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Exception doInBackground(ProgressMonitor pm) {
                Exception returnValue = null;
                try {
                    boolean success = ExportMaskPixelsAction.exportMaskPixels(out, product, maskName, mustCreateHeader, mustExportTiePoints, mustExportWavelengthsAndSF, pm);
                    if (success && clipboardText != null) {
                        SystemUtils.copyToClipboard((String)clipboardText.toString());
                        clipboardText.setLength(0);
                    }
                }
                catch (Exception e) {
                    returnValue = e;
                }
                finally {
                    out.close();
                }
                return returnValue;
            }

            public void done() {
                Exception exception;
                SnapApp.getDefault().setStatusBarMessage("");
                UIUtils.setRootFrameDefaultCursor((Component)SnapApp.getDefault().getMainFrame());
                try {
                    exception = (Exception)this.get();
                }
                catch (Exception e) {
                    exception = e;
                }
                if (exception != null) {
                    Dialogs.showError(Bundle.CTL_ExportMaskPixelsAction_DialogTitle(), ExportMaskPixelsAction.ERR_MSG_BASE + exception.getMessage());
                }
            }
        };
        UIUtils.setRootFrameWaitCursor((Component)SnapApp.getDefault().getMainFrame());
        SnapApp.getDefault().setStatusBarMessage("Exporting Mask pixels...");
        swingWorker.execute();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }
}

