/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file.export;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.export.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.UIUtils;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ExportGeometryAction
extends AbstractAction
implements ContextAwareAction,
LookupListener,
HelpCtx.Provider {
    private static final String ESRI_SHAPEFILE = "ESRI Shapefile";
    private static final String FILE_EXTENSION_SHAPEFILE = ".shp";
    private static final String HELP_ID = "exportShapefile";
    private final Lookup.Result<VectorDataNode> result;
    private final Lookup lookup;
    private VectorDataNode vectorDataNode;

    public ExportGeometryAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ExportGeometryAction(Lookup lookup) {
        super(Bundle.CTL_ExportGeometryAction_MenuText());
        this.lookup = lookup;
        this.result = lookup.lookupResult(VectorDataNode.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.vectorDataNode = (VectorDataNode)lookup.lookup(VectorDataNode.class);
        this.setEnabled(this.vectorDataNode != null);
    }

    private static File promptForFile(String defaultFileName) {
        return Dialogs.requestFileForSave(Bundle.CTL_ExportGeometryAction_DialogTitle(), false, (FileFilter)new SnapFileFilter(ESRI_SHAPEFILE, FILE_EXTENSION_SHAPEFILE, ESRI_SHAPEFILE), FILE_EXTENSION_SHAPEFILE, defaultFileName, null, "exportVectorDataNode.lastDir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportVectorDataNode(VectorDataNode vectorNode, File file, ProgressMonitor pm) throws Exception {
        Map<Class<?>, List<SimpleFeature>> featureListMap = ExportGeometryAction.createGeometryToFeaturesListMap(vectorNode);
        if (featureListMap.size() > 1) {
            String msg = "The selected geometry contains different types of shapes.\nEach type of shape will be exported as a separate shapefile.";
            Dialogs.showInformation(Bundle.CTL_ExportGeometryAction_DialogTitle(), "The selected geometry contains different types of shapes.\nEach type of shape will be exported as a separate shapefile.", ExportGeometryAction.class.getName() + ".exportInfo");
        }
        Set<Map.Entry<Class<?>, List<SimpleFeature>>> entries = featureListMap.entrySet();
        pm.beginTask("Writing ESRI Shapefiles...", featureListMap.size());
        try {
            for (Map.Entry<Class<?>, List<SimpleFeature>> entry : entries) {
                ExportGeometryAction.writeEsriShapefile(entry.getKey(), entry.getValue(), file);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    static void writeEsriShapefile(Class<?> geomType, List<SimpleFeature> features, File file) throws IOException {
        String geomName = geomType.getSimpleName();
        String basename = file.getName();
        if (basename.endsWith(FILE_EXTENSION_SHAPEFILE)) {
            basename = basename.substring(0, basename.length() - 4);
        }
        File file1 = new File(file.getParentFile(), basename + "_" + geomName + FILE_EXTENSION_SHAPEFILE);
        SimpleFeature simpleFeature = features.get(0);
        SimpleFeatureType simpleFeatureType = ExportGeometryAction.changeGeometryType(simpleFeature.getType(), geomType);
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        Map<String, URL> map = Collections.singletonMap("url", file1.toURI().toURL());
        ShapefileDataStore dataStore = (ShapefileDataStore)factory.createNewDataStore(map);
        dataStore.createSchema(simpleFeatureType);
        String typeName = dataStore.getTypeNames()[0];
        ContentFeatureSource featureSource = dataStore.getFeatureSource(typeName);
        DefaultTransaction transaction = new DefaultTransaction("X");
        if (featureSource instanceof SimpleFeatureStore) {
            SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
            ListFeatureCollection collection = new ListFeatureCollection(simpleFeatureType, features);
            featureStore.setTransaction((Transaction)transaction);
            dataStore.getEntry(featureSource.getName()).getState((Transaction)transaction).setFeatureType(simpleFeatureType);
            try {
                featureStore.addFeatures((FeatureCollection)collection);
                transaction.commit();
            }
            catch (Exception problem) {
                transaction.rollback();
                throw new IOException(problem);
            }
            finally {
                transaction.close();
            }
        } else {
            throw new IOException(typeName + " does not support read/write access");
        }
    }

    private static Map<Class<?>, List<SimpleFeature>> createGeometryToFeaturesListMap(VectorDataNode vectorNode) throws TransformException, SchemaException {
        DefaultFeatureCollection featureCollection = vectorNode.getFeatureCollection();
        CoordinateReferenceSystem crs = vectorNode.getFeatureType().getCoordinateReferenceSystem();
        if (crs == null) {
            crs = vectorNode.getProduct().getSceneCRS();
        }
        Object modelCrs = vectorNode.getProduct().getSceneGeoCoding() instanceof CrsGeoCoding ? vectorNode.getProduct().getSceneCRS() : DefaultGeographicCRS.WGS84;
        GeometryCoordinateSequenceTransformer transformer = ExportGeometryAction.createTransformer(crs, (CoordinateReferenceSystem)modelCrs);
        HashMap featureListMap = new HashMap();
        FeatureIterator featureIterator = featureCollection.features();
        SimpleFeatureType schema = (SimpleFeatureType)featureCollection.getSchema();
        SimpleFeatureType transformedSchema = FeatureTypes.transform((SimpleFeatureType)schema, (CoordinateReferenceSystem)modelCrs);
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            Object defaultGeometry = feature.getDefaultGeometry();
            feature.setDefaultGeometry((Object)transformer.transform((Geometry)defaultGeometry));
            Class<?> geometryType = defaultGeometry.getClass();
            List featureList = featureListMap.computeIfAbsent(geometryType, k -> new ArrayList());
            SimpleFeature exportFeature = SimpleFeatureBuilder.build((SimpleFeatureType)transformedSchema, (List)feature.getAttributes(), (String)feature.getID());
            featureList.add(exportFeature);
        }
        return featureListMap;
    }

    private static GeometryCoordinateSequenceTransformer createTransformer(CoordinateReferenceSystem crs, CoordinateReferenceSystem modelCrs) {
        GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
        try {
            MathTransform reprojTransform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)modelCrs, (boolean)true);
            transformer.setMathTransform(reprojTransform);
            return transformer;
        }
        catch (FactoryException e) {
            throw new IllegalStateException("Could not create math transform", e);
        }
    }

    static SimpleFeatureType changeGeometryType(SimpleFeatureType original, Class<?> geometryType) {
        SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
        sftb.setCRS(original.getCoordinateReferenceSystem());
        sftb.setDefaultGeometry(original.getGeometryDescriptor().getLocalName());
        boolean defaultGeometryAdded = false;
        for (AttributeDescriptor descriptor : original.getAttributeDescriptors()) {
            if (original.getGeometryDescriptor().getLocalName().equals(descriptor.getLocalName())) {
                sftb.add(descriptor.getLocalName(), geometryType);
                defaultGeometryAdded = true;
                continue;
            }
            sftb.add(descriptor);
        }
        if (!defaultGeometryAdded) {
            sftb.add(original.getGeometryDescriptor().getLocalName(), geometryType);
        }
        sftb.setName("FT_" + geometryType.getSimpleName());
        return sftb.buildFeatureType();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.exportVectorDataNode();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ExportGeometryAction(actionContext);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.vectorDataNode = (VectorDataNode)this.lookup.lookup(VectorDataNode.class);
        this.setEnabled(this.vectorDataNode != null);
    }

    private void exportVectorDataNode() {
        SnapApp snapApp = SnapApp.getDefault();
        if (this.vectorDataNode.getFeatureCollection().isEmpty()) {
            Dialogs.showInformation(Bundle.CTL_ExportGeometryAction_DialogTitle(), "The selected geometry is empty. Nothing to export.", null);
            return;
        }
        File file = ExportGeometryAction.promptForFile(this.vectorDataNode.getName());
        if (file == null) {
            return;
        }
        ExportVectorNodeSwingWorker swingWorker = new ExportVectorNodeSwingWorker(snapApp, this.vectorDataNode, file);
        UIUtils.setRootFrameWaitCursor((Component)snapApp.getMainFrame());
        snapApp.setStatusBarMessage("Exporting Geometry...");
        ((SwingWorker)((Object)swingWorker)).execute();
    }

    private static class ExportVectorNodeSwingWorker
    extends ProgressMonitorSwingWorker<Exception, Object> {
        private final SnapApp snapApp;
        private final VectorDataNode vectorDataNode;
        private final File file;

        private ExportVectorNodeSwingWorker(SnapApp snapApp, VectorDataNode vectorDataNode, File file) {
            super((Component)snapApp.getMainFrame(), Bundle.CTL_ExportGeometryAction_DialogTitle());
            this.snapApp = snapApp;
            this.vectorDataNode = vectorDataNode;
            this.file = file;
        }

        protected Exception doInBackground(ProgressMonitor pm) throws Exception {
            try {
                ExportGeometryAction.exportVectorDataNode(this.vectorDataNode, this.file, pm);
            }
            catch (Exception e) {
                return e;
            }
            return null;
        }

        public void done() {
            Exception exception = null;
            try {
                UIUtils.setRootFrameDefaultCursor((Component)SnapApp.getDefault().getMainFrame());
                this.snapApp.setStatusBarMessage("");
                exception = (Exception)this.get();
            }
            catch (InterruptedException | ExecutionException e) {
                exception = e;
            }
            finally {
                if (exception != null) {
                    exception.printStackTrace();
                    Dialogs.showError(Bundle.CTL_ExportGeometryAction_DialogTitle(), "Can not export geometry.\n" + exception.getMessage());
                }
            }
        }
    }
}

