/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file.export;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.export.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.runtime.Config;
import org.esa.snap.ui.SnapFileChooser;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ExportEnviGcpFileAction
extends AbstractAction
implements LookupListener,
ContextAwareAction,
HelpCtx.Provider {
    private static final String GCP_FILE_DESCRIPTION = "ENVI Ground Control Points";
    private static final String GCP_FILE_EXTENSION = ".pts";
    private static final String GCP_LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String GCP_EXPORT_DIR_PREFERENCES_KEY = "user.gcp.export.dir";
    private static final String HELP_ID = "exportEnviGcpFile";
    private final Lookup.Result<ProductNode> result;

    public ExportEnviGcpFileAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ExportEnviGcpFileAction(Lookup lookup) {
        super(Bundle.CTL_ExportEnviGcpFileAction_MenuText());
        this.result = lookup.lookupResult(ProductNode.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnabled(false);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ExportEnviGcpFileAction(lookup);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.exportGroundControlPoints();
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setEnabled(SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.AUTO) != null);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    private void exportGroundControlPoints() {
        SnapApp snapApp = SnapApp.getDefault();
        Product product = snapApp.getSelectedProduct(SnapApp.SelectionSourceHint.AUTO);
        if (product == null) {
            return;
        }
        JFileChooser fileChooser = this.createFileChooser();
        int result = fileChooser.showSaveDialog(snapApp.getMainFrame());
        if (result != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (file == null || file.getName().equals("")) {
            return;
        }
        File absoluteFile = FileUtils.ensureExtension((File)file.getAbsoluteFile(), (String)GCP_FILE_EXTENSION);
        String lastDirPath = absoluteFile.getParent();
        Config.instance().load().preferences().put(GCP_EXPORT_DIR_PREFERENCES_KEY, lastDirPath);
        GeoCoding geoCoding = product.getSceneGeoCoding();
        if (geoCoding == null) {
            return;
        }
        Boolean decision = Dialogs.requestOverwriteDecision(Bundle.CTL_ExportEnviGcpFileAction_DialogTitle(), absoluteFile);
        if (decision == null || !decision.booleanValue()) {
            return;
        }
        if (absoluteFile.exists()) {
            absoluteFile.delete();
        }
        try (FileWriter writer = new FileWriter(absoluteFile);){
            writer.write(ExportEnviGcpFileAction.createLineString("; ENVI Registration GCP File"));
            int width = product.getSceneRasterWidth();
            int height = product.getSceneRasterHeight();
            int resolution = Config.instance().load().preferences().getInt("gcp.resolution", 112);
            int gcpWidth = Math.max(width / resolution + 1, 2);
            int gcpHeight = Math.max(height / resolution + 1, 2);
            float xMultiplier = 1.0f * (float)(width - 1) / (float)(gcpWidth - 1);
            float yMultiplier = 1.0f * (float)(height - 1) / (float)(gcpHeight - 1);
            PixelPos pixelPos = new PixelPos();
            GeoPos geoPos = new GeoPos();
            for (int y = 0; y < gcpHeight; ++y) {
                for (int x = 0; x < gcpWidth; ++x) {
                    float imageX = xMultiplier * (float)x;
                    float imageY = yMultiplier * (float)y;
                    pixelPos.x = imageX + 0.5f;
                    pixelPos.y = imageY + 0.5f;
                    geoCoding.getGeoPos(pixelPos, geoPos);
                    double mapX = geoPos.lon;
                    double mapY = geoPos.lat;
                    writer.write(ExportEnviGcpFileAction.createLineString(mapX, mapY, pixelPos.x + 1.0, pixelPos.y + 1.0));
                }
            }
        }
        catch (IOException e) {
            Dialogs.showInformation(Bundle.CTL_ExportEnviGcpFileAction_DialogTitle(), "An I/O error occurred:\n" + e.getMessage());
        }
    }

    private static String createLineString(String str) {
        return str.concat(GCP_LINE_SEPARATOR);
    }

    private static String createLineString(double mapX, double mapY, double imageX, double imageY) {
        return mapX + "\t" + mapY + "\t" + imageX + "\t" + imageY + GCP_LINE_SEPARATOR;
    }

    private JFileChooser createFileChooser() {
        String lastDirPath = Config.instance().load().preferences().get(GCP_EXPORT_DIR_PREFERENCES_KEY, SystemUtils.getUserHomeDir().getPath());
        SnapFileChooser fileChooser = new SnapFileChooser();
        HelpCtx.setHelpIDString((JComponent)fileChooser, (String)this.getHelpCtx().getHelpID());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setCurrentDirectory(new File(lastDirPath));
        fileChooser.setFileFilter((FileFilter)new SnapFileFilter(GCP_FILE_DESCRIPTION, GCP_FILE_EXTENSION, GCP_FILE_DESCRIPTION));
        fileChooser.setDialogTitle(Bundle.CTL_ExportEnviGcpFileAction_DialogTitle());
        fileChooser.setFileSelectionMode(0);
        return fileChooser;
    }
}

