/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file.export;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncoder;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.geotiff.GeoTIFF;
import org.esa.snap.core.util.geotiff.GeoTIFFMetadata;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.runtime.Config;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.LookupListener;

public abstract class AbstractExportImageAction
extends AbstractAction
implements LookupListener,
ContextAwareAction,
HelpCtx.Provider {
    public static final String IMAGE_EXPORT_DIR_PREFERENCES_KEY = "user.image.export.dir";
    protected static final String[] BMP_FORMAT_DESCRIPTION = new String[]{"BMP", "bmp", "BMP - Microsoft Windows Bitmap"};
    protected static final String[] PNG_FORMAT_DESCRIPTION = new String[]{"PNG", "png", "PNG - Portable Network Graphics"};
    protected static final String[] JPEG_FORMAT_DESCRIPTION = new String[]{"JPEG", "jpg,jpeg", "JPEG - Joint Photographic Experts Group"};
    protected static final String[] GEOTIFF_FORMAT_DESCRIPTION = new String[]{"GeoTIFF", "tif,tiff", "GeoTIFF - TIFF with geo-location"};
    protected static final String[] TIFF_FORMAT_DESCRIPTION = new String[]{"TIFF", "tif,tiff", "TIFF - Tagged Image File Format"};
    private static final String[] TRANSPARENCY_IMAGE_FORMATS = new String[]{"TIFF", "PNG"};
    private String dialogTitle;
    private final String helpId;

    public AbstractExportImageAction(String name, String helpId) {
        super(name);
        this.dialogTitle = name;
        this.helpId = helpId;
        Config.instance().load();
    }

    protected static boolean isTransparencySupportedByFormat(String formatName) {
        for (String format : TRANSPARENCY_IMAGE_FORMATS) {
            if (!format.equalsIgnoreCase(formatName)) continue;
            return true;
        }
        return false;
    }

    protected static SnapFileFilter createFileFilter(String[] description) {
        String formatName = description[0];
        String formatExt = description[1];
        String formatDescr = description[2];
        return new SnapFileFilter(formatName, formatExt, formatDescr);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.helpId);
    }

    protected void exportImage(SnapFileFilter[] filters) {
        String imageFormat;
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        if (view == null) {
            return;
        }
        String lastDir = Config.instance().preferences().get(IMAGE_EXPORT_DIR_PREFERENCES_KEY, SystemUtils.getUserHomeDir().getPath());
        File currentDir = new File(lastDir);
        SnapFileChooser fileChooser = new SnapFileChooser();
        HelpCtx.setHelpIDString((JComponent)fileChooser, (String)this.getHelpCtx().getHelpID());
        fileChooser.setCurrentDirectory(currentDir);
        for (int i = 0; i < filters.length; ++i) {
            SnapFileFilter filter = filters[i];
            Debug.trace((String)("export image: supported format " + (i + 1) + ": " + filter.getFormatName()));
            fileChooser.addChoosableFileFilter((FileFilter)filter);
        }
        fileChooser.setAcceptAllFileFilterUsed(false);
        String name = view.getProduct().getName();
        String imageBaseName = FileUtils.getFilenameWithoutExtension((String)name).replace('.', '_');
        this.configureFileChooser(fileChooser, view, imageBaseName);
        fileChooser.setFileSelectionMode(0);
        Dimension fileChooserSize = fileChooser.getPreferredSize();
        if (fileChooserSize != null) {
            fileChooser.setPreferredSize(new Dimension(fileChooserSize.width + 120, fileChooserSize.height));
        } else {
            fileChooser.setPreferredSize(new Dimension(512, 256));
        }
        int result = fileChooser.showSaveDialog((Component)SnapApp.getDefault().getMainFrame());
        File file = fileChooser.getSelectedFile();
        fileChooser.addPropertyChangeListener(evt -> Debug.trace((String)evt.toString()));
        File currentDirectory = fileChooser.getCurrentDirectory();
        if (currentDirectory != null) {
            Config.instance().preferences().put(IMAGE_EXPORT_DIR_PREFERENCES_KEY, currentDirectory.getPath());
        }
        if (result != 0) {
            return;
        }
        if (file == null || file.getName().equals("")) {
            return;
        }
        boolean entireImageSelected = this.isEntireImageSelected();
        SnapFileFilter fileFilter = fileChooser.getSnapFileFilter();
        String string = imageFormat = fileFilter != null ? fileFilter.getFormatName() : "TIFF";
        if (imageFormat.equals(GEOTIFF_FORMAT_DESCRIPTION[0]) && !entireImageSelected) {
            String msg = "GeoTIFF is not applicable to image clippings. Please select 'Full scene' option.\nShall TIFF format be used instead?";
            Dialogs.Answer status = Dialogs.requestDecision(this.dialogTitle, "GeoTIFF is not applicable to image clippings. Please select 'Full scene' option.\nShall TIFF format be used instead?", true, null);
            if (status == Dialogs.Answer.YES) {
                imageFormat = "TIFF";
            } else {
                return;
            }
        }
        if (Boolean.TRUE.equals(Dialogs.requestOverwriteDecision(this.dialogTitle, file))) {
            this.exportImage(imageFormat, view, entireImageSelected, file);
        }
    }

    protected void exportImage(String imageFormat, ProductSceneView view, boolean entireImageSelected, File file) {
        SaveImageSwingWorker worker = new SaveImageSwingWorker(SnapApp.getDefault(), "Save Image", imageFormat, view, entireImageSelected, file);
        worker.executeWithBlocking();
    }

    protected abstract RenderedImage createImage(String var1, ProductSceneView var2);

    protected abstract boolean isEntireImageSelected();

    protected abstract void configureFileChooser(SnapFileChooser var1, ProductSceneView var2, String var3);

    private class SaveImageSwingWorker
    extends ProgressMonitorSwingWorker {
        private final String imageFormat;
        private final ProductSceneView view;
        private final boolean entireImageSelected;
        private final File file;
        private final SnapApp snapApp;

        SaveImageSwingWorker(SnapApp snapApp, String message, String imageFormat, ProductSceneView view, boolean entireImageSelected, File file) {
            super((Component)snapApp.getMainFrame(), message);
            this.snapApp = snapApp;
            this.imageFormat = imageFormat;
            this.view = view;
            this.entireImageSelected = entireImageSelected;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground(ProgressMonitor pm) throws Exception {
            block14: {
                try {
                    GeoTIFFMetadata metadata;
                    String message = "Saving image as " + this.file.getPath() + "...";
                    pm.beginTask(message, 1);
                    this.snapApp.setStatusBarMessage(message);
                    this.snapApp.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
                    RenderedImage image = AbstractExportImageAction.this.createImage(this.imageFormat, this.view);
                    boolean geoTIFFWritten = false;
                    if (this.imageFormat.equals("GeoTIFF") && this.entireImageSelected && (metadata = ProductUtils.createGeoTIFFMetadata((Product)this.view.getProduct())) != null) {
                        GeoTIFF.writeImage((RenderedImage)image, (File)this.file, (GeoTIFFMetadata)metadata);
                        geoTIFFWritten = true;
                    }
                    if (geoTIFFWritten) break block14;
                    if ("JPEG".equalsIgnoreCase(this.imageFormat)) {
                        image = BandSelectDescriptor.create((RenderedImage)image, (int[])new int[]{0, 1, 2}, null);
                    }
                    try (FileOutputStream stream = new FileOutputStream(this.file);){
                        ImageEncoder encoder = ImageCodec.createImageEncoder((String)this.imageFormat, (OutputStream)stream, null);
                        encoder.encode(image);
                    }
                }
                catch (OutOfMemoryError e) {
                    Dialogs.showOutOfMemoryError("The image could not be exported.");
                }
                catch (Throwable e) {
                    this.snapApp.handleError("The image could not be exported.", e);
                }
                finally {
                    this.snapApp.getMainFrame().setCursor(Cursor.getDefaultCursor());
                    this.snapApp.setStatusBarMessage("");
                    pm.done();
                }
            }
            return null;
        }
    }
}

