/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.Bundle;
import org.esa.snap.rcp.actions.file.OpenProductAction;
import org.openide.util.actions.Presenter;

public final class ReopenProductAction
extends AbstractAction
implements Presenter.Toolbar,
Presenter.Menu,
Presenter.Popup {
    private final int DEFAULT_MAX_FILE_LIST_REOPEN = 10;

    public JMenuItem getMenuPresenter() {
        List<File> openedFiles = OpenProductAction.getOpenedProductFiles();
        List<String> pathList = OpenProductAction.getRecentProductPaths().get();
        Preferences preference = SnapApp.getDefault().getPreferences();
        int maxFileList = preference.getInt("filesToReopen", 10);
        JMenu menu = new JMenu(Bundle.CTL_ReopenProductActionMenuText());
        pathList.stream().limit(maxFileList).forEach(path -> {
            File theFile = new File((String)path);
            if (!openedFiles.contains(theFile) && theFile.exists()) {
                JMenuItem menuItem = new JMenuItem((String)path);
                OpenProductAction openProductAction = new OpenProductAction();
                openProductAction.setFile(theFile);
                menuItem.addActionListener(openProductAction);
                menu.add(menuItem);
            }
        });
        if (menu.getComponentCount() > 0 || pathList.size() > 0) {
            menu.addSeparator();
            JMenuItem menuItem = new JMenuItem(Bundle.CTL_ClearListActionMenuText());
            menuItem.addActionListener(e -> OpenProductAction.getRecentProductPaths().clear());
            menu.add(menuItem);
        }
        return menu;
    }

    public JMenuItem getPopupPresenter() {
        return this.getMenuPresenter();
    }

    public Component getToolbarPresenter() {
        return this.getMenuPresenter();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

