/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.esa.snap.vfs.NioPaths;

class RecentPaths {
    private final Preferences preferences;
    private final String key;
    private final boolean filterExisting;

    public RecentPaths(Preferences preferences, String key, boolean filterExisting) {
        this.preferences = preferences;
        this.key = key;
        this.filterExisting = filterExisting;
    }

    public List<String> get() {
        return this.getAsStream().collect(Collectors.toList());
    }

    public void add(String path) {
        if (path.isEmpty() || !this.isPathValid(path)) {
            return;
        }
        String value = Stream.concat(Stream.of(path), this.getAsStream().filter(p -> !p.equals(path))).collect(Collectors.joining(File.pathSeparator));
        this.preferences.put(this.key, value);
        this.flush();
    }

    private boolean isPathValid(String path) {
        try {
            Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
        return true;
    }

    public void clear() {
        this.preferences.remove(this.key);
        this.flush();
    }

    private Stream<String> getAsStream() {
        String value = this.preferences.get(this.key, null);
        if (value == null) {
            return Stream.empty();
        }
        return Arrays.stream(value.split(File.pathSeparator)).map(this::convertToPath).filter(Objects::nonNull).map(Path::toString);
    }

    private Path convertToPath(String pathAsString) {
        try {
            return NioPaths.get((String)pathAsString, (String[])new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    private void flush() {
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }
}

